/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystem;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;

public final class S3FileSystemFactory
implements TrinoFileSystemFactory {
    private final S3Client client;
    private final S3Context context;

    @Inject
    public S3FileSystemFactory(OpenTelemetry openTelemetry, S3FileSystemConfig config) {
        S3ClientBuilder s3 = S3Client.builder();
        s3.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.builder((OpenTelemetry)openTelemetry).setCaptureExperimentalSpanAttributes(true).setRecordIndividualHttpError(true).build().newExecutionInterceptor()).build());
        Optional<StaticCredentialsProvider> staticCredentialsProvider = S3FileSystemFactory.getStaticCredentialsProvider(config);
        staticCredentialsProvider.ifPresent(arg_0 -> ((S3ClientBuilder)s3).credentialsProvider(arg_0));
        Optional.ofNullable(config.getRegion()).map(Region::of).ifPresent(arg_0 -> ((S3ClientBuilder)s3).region(arg_0));
        Optional.ofNullable(config.getEndpoint()).map(URI::create).ifPresent(arg_0 -> ((S3ClientBuilder)s3).endpointOverride(arg_0));
        s3.forcePathStyle(Boolean.valueOf(config.isPathStyleAccess()));
        if (config.getIamRole() != null) {
            StsClientBuilder sts = StsClient.builder();
            Optional.ofNullable(config.getStsEndpoint()).map(URI::create).ifPresent(arg_0 -> ((StsClientBuilder)sts).endpointOverride(arg_0));
            Optional.ofNullable(config.getStsRegion()).or(() -> Optional.ofNullable(config.getRegion())).map(Region::of).ifPresent(arg_0 -> ((StsClientBuilder)sts).region(arg_0));
            staticCredentialsProvider.ifPresent(arg_0 -> ((StsClientBuilder)sts).credentialsProvider(arg_0));
            s3.credentialsProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest(request -> request.roleArn(config.getIamRole()).roleSessionName(config.getRoleSessionName()).externalId(config.getExternalId())).stsClient((StsClient)sts.build())).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build());
        }
        ApacheHttpClient.Builder httpClient = ApacheHttpClient.builder().maxConnections(config.getMaxConnections());
        if (config.getHttpProxy() != null) {
            URI endpoint = URI.create("%s://%s".formatted(config.isHttpProxySecure() ? "https" : "http", config.getHttpProxy()));
            httpClient.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(endpoint).build());
        }
        s3.httpClientBuilder((SdkHttpClient.Builder)httpClient);
        this.client = (S3Client)s3.build();
        this.context = new S3Context(Math.toIntExact(config.getStreamingPartSize().toBytes()), config.isRequesterPays(), config.getSseType(), config.getSseKmsKeyId());
    }

    @PreDestroy
    public void destroy() {
        this.client.close();
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new S3FileSystem(this.client, this.context);
    }

    private static Optional<StaticCredentialsProvider> getStaticCredentialsProvider(S3FileSystemConfig config) {
        if (config.getAwsAccessKey() != null || config.getAwsSecretKey() != null) {
            return Optional.of(StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)config.getAwsAccessKey(), (String)config.getAwsSecretKey())));
        }
        return Optional.empty();
    }
}

