/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveAnalyzeProperties;
import io.trino.plugin.hive.HiveApplyProjectionUtil;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveInputInfo;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveMaterializedViewMetadata;
import io.trino.plugin.hive.HiveMergeTableHandle;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HivePartitionResult;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveRedirectionsProvider;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableExecuteHandle;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveUpdateHandle;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.HiveWritableTableHandle;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionUpdateAndMergeResults;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.projection.PartitionProjectionProperties;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.statistics.HiveStatisticsProvider;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.hive.util.RetryDriver;
import io.trino.plugin.hive.util.Statistics;
import io.trino.plugin.hive.util.SystemTables;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;

public class HiveMetadata
implements TransactionalMetadata {
    private static final Logger log = Logger.get(HiveMetadata.class);
    public static final String TRINO_VERSION_NAME = "trino_version";
    public static final String TRINO_CREATED_BY = "trino_created_by";
    public static final String TRINO_QUERY_ID_NAME = "trino_query_id";
    public static final String BUCKETING_VERSION = "bucketing_version";
    public static final String TABLE_COMMENT = "comment";
    public static final String STORAGE_TABLE = "storage_table";
    public static final String TRANSACTIONAL = "transactional";
    public static final String PRESTO_VIEW_COMMENT = "Presto View";
    public static final String PRESTO_VIEW_EXPANDED_TEXT_MARKER = "/* Presto View */";
    public static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    public static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    public static final String SKIP_HEADER_COUNT_KEY = "skip.header.line.count";
    public static final String SKIP_FOOTER_COUNT_KEY = "skip.footer.line.count";
    private static final String TEXT_FIELD_SEPARATOR_KEY = "field.delim";
    private static final String TEXT_FIELD_SEPARATOR_ESCAPE_KEY = "escape.delim";
    private static final String NULL_FORMAT_KEY = "serialization.null.format";
    public static final String AVRO_SCHEMA_URL_KEY = "avro.schema.url";
    public static final String AVRO_SCHEMA_LITERAL_KEY = "avro.schema.literal";
    private static final String CSV_SEPARATOR_KEY = "separatorChar";
    private static final String CSV_QUOTE_KEY = "quoteChar";
    private static final String CSV_ESCAPE_KEY = "escapeChar";
    private static final String REGEX_KEY = "input.regex";
    private static final String REGEX_CASE_SENSITIVE_KEY = "input.regex.case.insensitive";
    private static final String AUTO_PURGE_KEY = "auto.purge";
    public static final String MODIFYING_NON_TRANSACTIONAL_TABLE_MESSAGE = "Modifying Hive table rows is only supported for transactional tables";
    private final CatalogName catalogName;
    private final SemiTransactionalHiveMetastore metastore;
    private final boolean autoCommit;
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final MetadataProvider metadataProvider;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean translateHiveViews;
    private final boolean hiveViewsRunAsInvoker;
    private final boolean hideDeltaLakeTables;
    private final String trinoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final HiveRedirectionsProvider hiveRedirectionsProvider;
    private final Set<SystemTableProvider> systemTableProviders;
    private final HiveMaterializedViewMetadata hiveMaterializedViewMetadata;
    private final AccessControlMetadata accessControlMetadata;
    private final DirectoryLister directoryLister;
    private final boolean partitionProjectionEnabled;
    private final boolean allowTableRename;
    private final long maxPartitionDropsPerQuery;
    private final HiveTimestampPrecision hiveViewsTimestampPrecision;

    public HiveMetadata(CatalogName catalogName, SemiTransactionalHiveMetastore metastore, boolean autoCommit, Set<HiveFileWriterFactory> fileWriterFactories, TrinoFileSystemFactory fileSystemFactory, HivePartitionManager partitionManager, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean translateHiveViews, boolean hiveViewsRunAsInvoker, boolean hideDeltaLakeTables, TypeManager typeManager, MetadataProvider metadataProvider, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, String trinoVersion, HiveStatisticsProvider hiveStatisticsProvider, HiveRedirectionsProvider hiveRedirectionsProvider, Set<SystemTableProvider> systemTableProviders, HiveMaterializedViewMetadata hiveMaterializedViewMetadata, AccessControlMetadata accessControlMetadata, DirectoryLister directoryLister, boolean partitionProjectionEnabled, boolean allowTableRename, long maxPartitionDropsPerQuery, HiveTimestampPrecision hiveViewsTimestampPrecision) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.autoCommit = autoCommit;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metadataProvider = Objects.requireNonNull(metadataProvider, "metadataProvider is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.translateHiveViews = translateHiveViews;
        this.hiveViewsRunAsInvoker = hiveViewsRunAsInvoker;
        this.hideDeltaLakeTables = hideDeltaLakeTables;
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        this.hiveRedirectionsProvider = Objects.requireNonNull(hiveRedirectionsProvider, "hiveRedirectionsProvider is null");
        this.systemTableProviders = Objects.requireNonNull(systemTableProviders, "systemTableProviders is null");
        this.hiveMaterializedViewMetadata = Objects.requireNonNull(hiveMaterializedViewMetadata, "hiveMaterializedViewMetadata is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.partitionProjectionEnabled = partitionProjectionEnabled;
        this.allowTableRename = allowTableRename;
        this.maxPartitionDropsPerQuery = maxPartitionDropsPerQuery;
        this.hiveViewsTimestampPrecision = Objects.requireNonNull(hiveViewsTimestampPrecision, "hiveViewsTimestampPrecision is null");
    }

    @Override
    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    @Override
    public DirectoryLister getDirectoryLister() {
        return this.directoryLister;
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        if (!schemaName.equals(schemaName.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        if (HiveUtil.isHiveSystemSchema(schemaName)) {
            return false;
        }
        return this.metastore.getDatabase(schemaName).isPresent();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema(schemaName)).collect(ImmutableList.toImmutableList());
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (HiveUtil.isHiveSystemSchema(tableName.getSchemaName())) {
            return null;
        }
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElse(null);
        if (table == null) {
            return null;
        }
        if (HiveUtil.isDeltaLakeTable(table)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, String.format("Cannot query Delta Lake table '%s'", tableName));
        }
        if (HiveUtil.isIcebergTable(table)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, String.format("Cannot query Iceberg table '%s'", tableName));
        }
        if (HiveUtil.isHudiTable(table)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, String.format("Cannot query Hudi table '%s'", tableName));
        }
        if (SystemTables.getSourceTableNameFromSystemTable(this.systemTableProviders, tableName).isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Unexpected table present in Hive metastore: " + tableName);
        }
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters());
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName(), table.getParameters(), HiveUtil.getPartitionKeyColumnHandles(table, this.typeManager), HiveUtil.getRegularColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)), HiveBucketing.getHiveBucketHandle(session, table, this.typeManager));
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<List<List<String>>> partitionValuesList = HiveAnalyzeProperties.getPartitionList(analyzeProperties);
        Optional<Set<String>> analyzeColumnNames = HiveAnalyzeProperties.getColumnNames(analyzeProperties);
        List partitionedBy = (List)handle.getPartitionColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (partitionValuesList.isPresent()) {
            List<List<String>> list = partitionValuesList.get();
            if (partitionedBy.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition list provided but table is not partitioned");
            }
            for (List<String> values : list) {
                if (values.size() == partitionedBy.size()) continue;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition value count does not match partition column count");
            }
            handle = handle.withAnalyzePartitionValues(list);
            HivePartitionResult partitions = this.partitionManager.getPartitions(handle, list);
            handle = this.partitionManager.applyPartitionResult(handle, partitions, Constraint.alwaysTrue());
        }
        if (analyzeColumnNames.isPresent()) {
            Set<String> columnNames = analyzeColumnNames.get();
            ImmutableSet allColumnNames = ImmutableSet.builder().addAll((Iterable)handle.getDataColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet())).addAll((Iterable)partitionedBy).build();
            if (!allColumnNames.containsAll(columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference(columnNames, (Set)allColumnNames)));
            }
        }
        List columns = (List)handle.getDataColumns().stream().map(HiveColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata metadata = this.getStatisticsCollectionMetadata(columns, partitionedBy, analyzeColumnNames, true);
        return new ConnectorAnalyzeMetadata((ConnectorTableHandle)handle, metadata);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        for (SystemTableProvider systemTableProvider : this.systemTableProviders) {
            Optional<SystemTable> systemTable = systemTableProvider.getSystemTable(this, session, tableName);
            if (!systemTable.isPresent()) continue;
            return systemTable;
        }
        return Optional.empty();
    }

    public SchemaTableName getTableName(ConnectorSession session, ConnectorTableHandle table) {
        return ((HiveTableHandle)table).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((handle.getProjectedColumns().size() == handle.getPartitionColumns().size() + handle.getDataColumns().size() ? 1 : 0) != 0, (Object)"Unexpected projected columns");
        return this.getTableMetadata(session, handle.getSchemaTableName());
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        try {
            return this.doGetTableMetadata(session, tableName);
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to construct table metadata for table " + tableName, e);
        }
    }

    private ConnectorTableMetadata doGetTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        String avroSchemaLiteral;
        String avroSchemaUrl;
        String orcBloomFilterFfp;
        String orcBloomFilterColumns;
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (HiveUtil.isIcebergTable(table) || HiveUtil.isDeltaLakeTable(table)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, String.format("Not a Hive table '%s'", tableName));
        }
        boolean isTrinoView = ViewReaderUtil.isTrinoView(table);
        boolean isHiveView = ViewReaderUtil.isHiveView(table);
        boolean isTrinoMaterializedView = ViewReaderUtil.isTrinoMaterializedView(table);
        if (!isHiveView || !this.translateHiveViews) {
            if (isHiveView) {
                throw new TableNotFoundException(tableName);
            }
            if (isTrinoView || isTrinoMaterializedView) {
                throw new TableNotFoundException(tableName);
            }
        }
        List<ColumnMetadata> columns = HiveUtil.getTableColumnMetadata(session, table, this.typeManager);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (table.getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
            properties.put((Object)"external_location", (Object)table.getStorage().getLocation());
        }
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table);
            properties.put((Object)"format", (Object)format);
        }
        catch (TrinoException format) {
            // empty catch block
        }
        List partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", (Object)partitionedBy);
        }
        table.getStorage().getBucketProperty().ifPresent(property -> {
            properties.put((Object)BUCKETING_VERSION, (Object)property.getBucketingVersion().getVersion());
            properties.put((Object)"bucket_count", (Object)property.getBucketCount());
            properties.put((Object)"bucketed_by", property.getBucketedBy());
            properties.put((Object)"sorted_by", property.getSortedBy());
        });
        String transactionalProperty = table.getParameters().get(TRANSACTIONAL);
        if (Boolean.parseBoolean(transactionalProperty)) {
            properties.put((Object)TRANSACTIONAL, (Object)true);
        }
        if ((orcBloomFilterColumns = table.getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = table.getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        if ((avroSchemaUrl = table.getParameters().get(AVRO_SCHEMA_URL_KEY)) != null) {
            properties.put((Object)"avro_schema_url", (Object)avroSchemaUrl);
        }
        if ((avroSchemaLiteral = table.getParameters().get(AVRO_SCHEMA_LITERAL_KEY)) != null) {
            properties.put((Object)"avro_schema_literal", (Object)avroSchemaLiteral);
        }
        HiveMetadata.getSerdeProperty(table, SKIP_HEADER_COUNT_KEY).ifPresent(skipHeaderCount -> properties.put((Object)"skip_header_line_count", (Object)Integer.valueOf(skipHeaderCount)));
        HiveMetadata.getSerdeProperty(table, SKIP_FOOTER_COUNT_KEY).ifPresent(skipFooterCount -> properties.put((Object)"skip_footer_line_count", (Object)Integer.valueOf(skipFooterCount)));
        HiveMetadata.getSerdeProperty(table, NULL_FORMAT_KEY).ifPresent(nullFormat -> properties.put((Object)"null_format", nullFormat));
        HiveMetadata.getSerdeProperty(table, TEXT_FIELD_SEPARATOR_KEY).ifPresent(fieldSeparator -> properties.put((Object)"textfile_field_separator", fieldSeparator));
        HiveMetadata.getSerdeProperty(table, TEXT_FIELD_SEPARATOR_ESCAPE_KEY).ifPresent(fieldEscape -> properties.put((Object)"textfile_field_separator_escape", fieldEscape));
        HiveMetadata.getCsvSerdeProperty(table, CSV_SEPARATOR_KEY).ifPresent(csvSeparator -> properties.put((Object)"csv_separator", csvSeparator));
        HiveMetadata.getCsvSerdeProperty(table, CSV_QUOTE_KEY).ifPresent(csvQuote -> properties.put((Object)"csv_quote", csvQuote));
        HiveMetadata.getCsvSerdeProperty(table, CSV_ESCAPE_KEY).ifPresent(csvEscape -> properties.put((Object)"csv_escape", csvEscape));
        HiveMetadata.getSerdeProperty(table, REGEX_KEY).ifPresent(regex -> properties.put((Object)"regex", regex));
        HiveMetadata.getSerdeProperty(table, REGEX_CASE_SENSITIVE_KEY).ifPresent(regexCaseInsensitive -> properties.put((Object)"regex_case_insensitive", (Object)Boolean.parseBoolean(regexCaseInsensitive)));
        Optional<String> comment = Optional.ofNullable(table.getParameters().get(TABLE_COMMENT));
        String autoPurgeProperty = table.getParameters().get(AUTO_PURGE_KEY);
        if (Boolean.parseBoolean(autoPurgeProperty)) {
            properties.put((Object)"auto_purge", (Object)true);
        }
        properties.putAll(PartitionProjectionProperties.getPartitionProjectionTrinoTableProperties(table));
        return new ConnectorTableMetadata(tableName, columns, (Map)properties.buildOrThrow(), comment);
    }

    private static Optional<String> getCsvSerdeProperty(Table table, String key) {
        return HiveMetadata.getSerdeProperty(table, key).map(csvSerdeProperty -> csvSerdeProperty.substring(0, 1));
    }

    private static Optional<String> getSerdeProperty(Table table, String key) {
        String serdePropertyValue = table.getStorage().getSerdeParameters().get(key);
        String tablePropertyValue = table.getParameters().get(key);
        if (serdePropertyValue != null && tablePropertyValue != null && !tablePropertyValue.equals(serdePropertyValue)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Different values for '%s' set in serde properties and table properties: '%s' and '%s'", key, serdePropertyValue, tablePropertyValue));
        }
        return HiveMetadata.firstNonNullable(tablePropertyValue, serdePropertyValue);
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        List partitionIds = (List)hiveTableHandle.getPartitions().map(partitions -> (ImmutableList)partitions.stream().map(HivePartition::getPartitionId).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        Table table = this.metastore.getTable(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(hiveTableHandle.getSchemaTableName()));
        Optional<String> tableDefaultFileFormat = HiveStorageFormat.getHiveStorageFormat(table.getStorage().getStorageFormat()).map(Enum::name);
        return Optional.of(new HiveInputInfo(partitionIds, !hiveTableHandle.getPartitionColumns().isEmpty(), tableDefaultFileFormat));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        Optional<List<SchemaTableName>> allTables;
        if (optionalSchemaName.isEmpty() && (allTables = this.metastore.getAllTables()).isPresent()) {
            return ImmutableSet.builder().addAll((Iterable)allTables.get().stream().filter(table -> !HiveUtil.isHiveSystemSchema(table.getSchemaName())).collect(ImmutableList.toImmutableList())).addAll(this.listMaterializedViews(session, optionalSchemaName)).build().asList();
        }
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        tableNames.addAll(this.listMaterializedViews(session, optionalSchemaName));
        return tableNames.build().asList();
    }

    public Map<SchemaTableName, RelationType> getRelationTypes(ConnectorSession session, Optional<String> optionalSchemaName) {
        Optional<Map<SchemaTableName, RelationType>> relationTypes;
        ImmutableMap.Builder result = ImmutableMap.builder();
        boolean fetched = false;
        if (optionalSchemaName.isEmpty() && (relationTypes = this.metastore.getRelationTypes()).isPresent()) {
            relationTypes.get().entrySet().stream().filter(entry -> !HiveUtil.isHiveSystemSchema(((SchemaTableName)entry.getKey()).getSchemaName())).forEach(arg_0 -> ((ImmutableMap.Builder)result).put(arg_0));
            fetched = true;
        }
        if (!fetched) {
            for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
                for (Map.Entry<String, RelationType> entry2 : this.metastore.getRelationTypes(schemaName).entrySet()) {
                    result.put((Object)new SchemaTableName(schemaName, entry2.getKey()), (Object)entry2.getValue());
                }
            }
        }
        this.listMaterializedViews(session, optionalSchemaName).forEach(name -> result.put(name, (Object)RelationType.MATERIALIZED_VIEW));
        return result.buildKeepingLast();
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent()) {
            if (HiveUtil.isHiveSystemSchema(schemaName.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)schemaName.get());
        }
        return this.listSchemaNames(session);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return (Map)HiveUtil.hiveColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        return this.listTables(session, prefix).stream().flatMap(tableName -> this.streamTableColumns(session, (SchemaTableName)tableName)).iterator();
    }

    private Stream<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTableName tableName) {
        try {
            if (this.redirectTable(session, tableName).isPresent()) {
                return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)tableName));
            }
            return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, (List)this.getTableMetadata(session, tableName).getColumns()));
        }
        catch (HiveViewNotSupportedException e) {
            return Stream.empty();
        }
        catch (TableNotFoundException e) {
            return Stream.empty();
        }
        catch (TrinoException e) {
            if (e.getErrorCode().getType() == ErrorType.EXTERNAL) {
                return Stream.empty();
            }
            throw e;
        }
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        Set<ColumnHandle> projectedColumns = hiveTableHandle.getProjectedColumns();
        Map columns = (Map)projectedColumns.stream().map(columnHandle -> (HiveColumnHandle)columnHandle).filter(entry -> !entry.isHidden() && entry.getHiveType().getCategory().equals((Object)Category.PRIMITIVE)).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
        Map columnTypes = (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, tableHandle, new Constraint(hiveTableHandle.getEnforcedConstraint()));
        Optional<List<HivePartition>> partitions = this.partitionManager.tryLoadPartitions(partitionResult);
        if (partitions.isPresent()) {
            return this.hiveStatisticsProvider.getTableStatistics(session, hiveTableHandle.getSchemaTableName(), columns, columnTypes, partitions.get());
        }
        return TableStatistics.empty();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        Optional<Table> optionalTable;
        if (prefix.getSchema().map(HiveUtil::isHiveSystemSchema).orElse(false).booleanValue()) {
            return ImmutableList.of();
        }
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        try {
            optionalTable = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        }
        catch (HiveViewNotSupportedException e) {
            return ImmutableList.of((Object)tableName);
        }
        return (List)optionalTable.filter(table -> !this.hideDeltaLakeTables || !HiveUtil.isDeltaLakeTable(table)).map(table -> ImmutableList.of((Object)tableName)).orElseGet(ImmutableList::of);
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.fileSystemFactory.create(session).directoryExists(Location.of((String)locationUri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(this.accessControlMetadata.isUsingSystemSecurity() ? Optional.empty() : Optional.of(owner.getType())).setOwnerName(this.accessControlMetadata.isUsingSystemSecurity() ? Optional.empty() : Optional.of(owner.getName())).setParameters((Map<String, String>)ImmutableMap.of((Object)TRINO_QUERY_ID_NAME, (Object)session.getQueryId())).build();
        this.metastore.createDatabase(session, database);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        if (cascade) {
            List<SchemaTableName> views = this.listViews(session, Optional.of(schemaName));
            List tables = (List)this.listTables(session, Optional.of(schemaName)).stream().filter(table -> !views.contains(table)).collect(ImmutableList.toImmutableList());
            for (SchemaTableName viewName : views) {
                this.dropView(session, viewName);
            }
            for (SchemaTableName tableName : tables) {
                HiveTableHandle table2 = this.getTableHandle(session, tableName);
                if (table2 == null) {
                    log.debug("Table disappeared during DROP SCHEMA CASCADE: %s", new Object[]{tableName});
                    continue;
                }
                this.dropTable(session, table2);
            }
            this.metastore.commit();
            boolean deleteData = this.metastore.shouldDeleteDatabaseData(session, schemaName);
            this.metastore.unsafeGetRawHiveMetastoreClosure().dropDatabase(schemaName, deleteData);
        } else {
            this.metastore.dropDatabase(session, schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        this.metastore.setDatabaseOwner(schemaName, HivePrincipal.from(principal));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<Object> targetPath;
        boolean external;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        boolean isTransactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        if (bucketProperty.isPresent() && HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing columns not supported when Avro schema url is set");
        }
        if (bucketProperty.isPresent() && HiveTableProperties.getAvroSchemaLiteral(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing/Partitioning columns not supported when Avro schema literal is set");
        }
        if (isTransactional) {
            this.metastore.checkSupportsHiveAcidTransactions();
        }
        HiveMetadata.validateTimestampColumns(tableMetadata.getColumns(), HiveSessionProperties.getTimestampPrecision(session));
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, session);
        hiveStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = (List)partitionedBy.stream().map(((Map)columnHandlesByName)::get).collect(ImmutableList.toImmutableList());
        this.checkPartitionTypesSupported(partitionColumns);
        String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
        if (externalLocation != null) {
            if (!this.createsOfNonManagedTablesEnabled) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
            }
            external = true;
            targetPath = Optional.of(HiveMetadata.getValidatedExternalLocation(externalLocation));
            this.checkExternalPathAndCreateIfNotExists(session, (Location)targetPath.get());
        } else {
            external = false;
            targetPath = isTransactional && HiveSessionProperties.isDelegateTransactionalManagedTableLocationToMetastore(session) ? Optional.empty() : Optional.of(this.locationService.forNewTable(this.metastore, session, schemaName, tableName));
        }
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, tableProperties, targetPath, external, this.trinoVersion, this.accessControlMetadata.isUsingSystemSecurity());
        PrincipalPrivileges principalPrivileges = this.accessControlMetadata.isUsingSystemSecurity() ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        HiveBasicStatistics basicStatistics = !external && table.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of()), false);
    }

    private Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, Optional<HiveBucketProperty> bucketProperty, ConnectorSession session) {
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        boolean transactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        tableProperties.put((Object)TRANSACTIONAL, (Object)String.valueOf(transactional));
        boolean autoPurgeEnabled = HiveTableProperties.isAutoPurge(tableMetadata.getProperties()).orElse(false);
        tableProperties.put((Object)AUTO_PURGE_KEY, (Object)String.valueOf(autoPurgeEnabled));
        bucketProperty.ifPresent(hiveBucketProperty -> tableProperties.put((Object)BUCKETING_VERSION, (Object)Integer.toString(hiveBucketProperty.getBucketingVersion().getVersion())));
        List<String> columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (columns != null && !columns.isEmpty()) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.ORC, "orc_bloom_filter_columns");
            this.validateOrcBloomFilterColumns(tableMetadata, columns);
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((String)",").join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        String avroSchemaUrl = HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties());
        String avroSchemaLiteral = HiveTableProperties.getAvroSchemaLiteral(tableMetadata.getProperties());
        HiveMetadata.checkAvroSchemaProperties(avroSchemaUrl, avroSchemaLiteral);
        if (avroSchemaUrl != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.AVRO, "avro_schema_url");
            tableProperties.put((Object)AVRO_SCHEMA_URL_KEY, (Object)this.validateAvroSchemaUrl(session, avroSchemaUrl));
        } else if (avroSchemaLiteral != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.AVRO, "avro_schema_literal");
            tableProperties.put((Object)AVRO_SCHEMA_LITERAL_KEY, (Object)HiveMetadata.validateAvroSchemaLiteral(avroSchemaLiteral));
        }
        ImmutableSet csvAndTextFile = ImmutableSet.of((Object)((Object)HiveStorageFormat.TEXTFILE), (Object)((Object)HiveStorageFormat.CSV));
        HiveTableProperties.getHeaderSkipCount(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$29(hiveStorageFormat, (Set)csvAndTextFile, tableProperties, arg_0));
        HiveTableProperties.getFooterSkipCount(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$30(hiveStorageFormat, (Set)csvAndTextFile, tableProperties, arg_0));
        ImmutableSet allowsNullFormat = ImmutableSet.of((Object)((Object)HiveStorageFormat.TEXTFILE), (Object)((Object)HiveStorageFormat.RCTEXT), (Object)((Object)HiveStorageFormat.SEQUENCEFILE));
        HiveTableProperties.getNullFormat(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$31(hiveStorageFormat, (Set)allowsNullFormat, tableProperties, arg_0));
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "textfile_field_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, TEXT_FIELD_SEPARATOR_KEY);
            tableProperties.put((Object)TEXT_FIELD_SEPARATOR_KEY, (Object)separator.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "textfile_field_separator_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, TEXT_FIELD_SEPARATOR_ESCAPE_KEY);
            tableProperties.put((Object)TEXT_FIELD_SEPARATOR_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_escape");
            tableProperties.put((Object)CSV_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_quote").ifPresent(quote -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_quote");
            tableProperties.put((Object)CSV_QUOTE_KEY, (Object)quote.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_separator");
            tableProperties.put((Object)CSV_SEPARATOR_KEY, (Object)separator.toString());
        });
        HiveTableProperties.getRegexPattern(tableMetadata.getProperties()).ifPresentOrElse(regexPattern -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.REGEX, "regex");
            try {
                Pattern.compile(regexPattern);
            }
            catch (PatternSyntaxException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Invalid REGEX pattern value: " + regexPattern);
            }
            tableProperties.put((Object)REGEX_KEY, regexPattern);
        }, () -> {
            if (hiveStorageFormat == HiveStorageFormat.REGEX) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("REGEX format requires the '%s' table property", "regex"));
            }
        });
        HiveTableProperties.isRegexCaseInsensitive(tableMetadata.getProperties()).ifPresent(regexCaseInsensitive -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.REGEX, "regex_case_insensitive");
            tableProperties.put((Object)REGEX_CASE_SENSITIVE_KEY, (Object)String.valueOf(regexCaseInsensitive));
        });
        tableProperties.put((Object)"numFiles", (Object)"-1");
        tableProperties.put((Object)"totalSize", (Object)"-1");
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        if (this.partitionProjectionEnabled) {
            tableProperties.putAll(PartitionProjectionProperties.getPartitionProjectionHiveTableProperties(tableMetadata));
        } else if (PartitionProjectionProperties.arePartitionProjectionPropertiesSet(tableMetadata)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "Partition projection is disabled. Enable it in configuration by setting hive.partition-projection-enabled=true");
        }
        ImmutableMap baseProperties = tableProperties.buildOrThrow();
        Map extraProperties = HiveTableProperties.getExtraProperties(tableMetadata.getProperties()).orElseGet(ImmutableMap::of);
        Sets.SetView illegalExtraProperties = Sets.intersection((Set)ImmutableSet.builder().addAll(baseProperties.keySet()).addAll(ThriftMetastoreUtil.STATS_PROPERTIES).build(), extraProperties.keySet());
        if (!illegalExtraProperties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Illegal keys in extra_properties: " + (Set)illegalExtraProperties);
        }
        return ImmutableMap.builder().putAll((Map)baseProperties).putAll(extraProperties).buildOrThrow();
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, HiveStorageFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", new Object[]{propertyName, actualStorageFormat}));
        }
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, Set<HiveStorageFormat> expectedStorageFormats, String propertyName) {
        if (!expectedStorageFormats.contains((Object)actualStorageFormat)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", new Object[]{propertyName, actualStorageFormat}));
        }
    }

    private void validateOrcBloomFilterColumns(ConnectorTableMetadata tableMetadata, List<String> orcBloomFilterColumns) {
        Set allColumns = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        if (!allColumns.containsAll(orcBloomFilterColumns)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Orc bloom filter columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(orcBloomFilterColumns), (Set)allColumns)));
        }
    }

    private String validateAvroSchemaUrl(ConnectorSession session, String url) {
        try {
            Location location = Location.of((String)url);
            if (!this.fileSystemFactory.create(session).newInputFile(location).exists()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot locate Avro schema file: " + url);
            }
            return location.toString();
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Avro schema file is not a valid file system URI: " + url, (Throwable)e);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot open Avro schema file: " + url, (Throwable)e);
        }
    }

    private static void checkAvroSchemaProperties(String avroSchemaUrl, String avroSchemaLiteral) {
        if (avroSchemaUrl != null && avroSchemaLiteral != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "avro_schema_url and avro_schema_literal cannot both be set");
        }
    }

    private static String validateAvroSchemaLiteral(String avroSchemaLiteral) {
        try {
            new Schema.Parser().parse(avroSchemaLiteral);
            return avroSchemaLiteral;
        }
        catch (SchemaParseException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Failed to parse Avro schema: " + avroSchemaLiteral, (Throwable)e);
        }
    }

    private static Location getValidatedExternalLocation(String location) {
        Location validated;
        try {
            validated = Location.of((String)location);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + location, (Throwable)e);
        }
        if (validated.path().contains("//")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Unsupported location that cannot be internally represented: " + location);
        }
        return validated;
    }

    private void checkExternalPathAndCreateIfNotExists(ConnectorSession session, Location location) {
        block3: {
            try {
                if (this.fileSystemFactory.create(session).directoryExists(location).orElse(true).booleanValue()) break block3;
                if (this.writesToNonManagedTablesEnabled) {
                    this.createDirectory(session, location);
                    break block3;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory: " + location);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + location, (Throwable)e);
            }
        }
    }

    private void createDirectory(ConnectorSession session, Location location) {
        try {
            this.fileSystemFactory.create(session).createDirectory(location);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, e.getMessage());
        }
    }

    private void checkPartitionTypesSupported(List<HiveColumnHandle> partitionColumns) {
        for (HiveColumnHandle partitionColumn : partitionColumns) {
            HiveUtil.verifyPartitionTypeSupported(partitionColumn.getName(), partitionColumn.getType());
        }
    }

    private static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Optional<Location> targetPath, boolean external, String trinoVersion, boolean usingSystemSecurity) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = (List)partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(HiveColumnHandle::toMetastoreColumn).collect(ImmutableList.toImmutableList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment(), (Map<String, String>)ImmutableMap.of()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)TRINO_VERSION_NAME, (Object)trinoVersion).put((Object)TRINO_QUERY_ID_NAME, (Object)queryId).putAll(additionalTableParameters);
        if (external) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(usingSystemSecurity ? Optional.empty() : Optional.of(tableOwner)).setTableType((external ? TableType.EXTERNAL_TABLE : TableType.MANAGED_TABLE).name()).setDataColumns((List<Column>)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map<String, String>)tableParameters.buildOrThrow());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(hiveStorageFormat)).setBucketProperty(bucketProperty).setLocation(targetPath.map(Object::toString));
        return tableBuilder.build();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(handle);
        this.metastore.addColumn(handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType(column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(hiveTableHandle);
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        this.metastore.renameColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(hiveTableHandle);
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.dropColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName table, TrinoPrincipal principal) {
        this.metastore.setTableOwner(table.getSchemaName(), table.getTableName(), HivePrincipal.from(principal));
    }

    private void failIfAvroSchemaIsSet(HiveTableHandle handle) {
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getParameters().containsKey(AVRO_SCHEMA_URL_KEY) || table.getStorage().getSerdeParameters().containsKey(AVRO_SCHEMA_URL_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema url is set");
        }
        if (table.getParameters().containsKey(AVRO_SCHEMA_LITERAL_KEY) || table.getStorage().getSerdeParameters().containsKey(AVRO_SCHEMA_LITERAL_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema literal is set");
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (!this.allowTableRename) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not supported with current metastore configuration");
        }
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.commentTable(handle.getSchemaName(), handle.getTableName(), comment);
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        Table view = this.getTrinoView(viewName);
        ConnectorViewDefinition definition = this.toConnectorViewDefinition(session, viewName, Optional.of(view)).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.replaceView(session, viewName, view, newDefinition);
    }

    public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        Table view = this.getTrinoView(viewName);
        ConnectorViewDefinition definition = this.toConnectorViewDefinition(session, viewName, Optional.of(view)).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> columnName.equals(currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getComment(), definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.replaceView(session, viewName, view, newDefinition);
    }

    public void setMaterializedViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.hiveMaterializedViewMetadata.setMaterializedViewColumnComment(session, viewName, columnName, comment);
    }

    private Table getTrinoView(SchemaTableName viewName) {
        Table view = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).filter(table -> ViewReaderUtil.isTrinoView(table) || ViewReaderUtil.isHiveView(table)).orElseThrow(() -> new ViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoView(view)) {
            throw new HiveViewNotSupportedException(viewName);
        }
        return view;
    }

    private void replaceView(ConnectorSession session, SchemaTableName viewName, Table view, ConnectorViewDefinition newViewDefinition) {
        Table.Builder viewBuilder = Table.builder(view).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData(newViewDefinition)));
        PrincipalPrivileges principalPrivileges = this.accessControlMetadata.isUsingSystemSecurity() ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), viewBuilder.build(), principalPrivileges);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.commentColumn(handle.getSchemaName(), handle.getTableName(), columnHandle.getName(), comment);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        Verify.verify((boolean)HiveSessionProperties.isStatisticsEnabled(session), (String)"statistics not enabled", (Object[])new Object[0]);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        List<Column> partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HiveTimestampPrecision timestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table, this.typeManager, timestampPrecision);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager, timestampPrecision)));
        Map<List<String>, ComputedStatistics> computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionColumnNames, columnTypes);
        if (partitionColumns.isEmpty()) {
            this.metastore.setTableStatistics(table, this.createPartitionStatistics(columnTypes, computedStatisticsMap.get(ImmutableList.of())));
        } else {
            List partitionNames;
            List partitionValuesList;
            if (handle.getAnalyzePartitionValues().isPresent()) {
                partitionValuesList = handle.getAnalyzePartitionValues().get();
                partitionNames = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.makePartitionName(partitionColumns, partitionValues)).collect(ImmutableList.toImmutableList());
            } else {
                partitionNames = this.metastore.getPartitionNames(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
                partitionValuesList = (List)partitionNames.stream().map(HiveUtil::toPartitionValues).collect(ImmutableList.toImmutableList());
            }
            ImmutableMap.Builder partitionStatistics = ImmutableMap.builder();
            Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf(this.metastore.getSupportedColumnStatistics(column.getType()))));
            Supplier emptyPartitionStatistics = Suppliers.memoize(() -> Statistics.createEmptyPartitionStatistics(columnTypes, columnStatisticTypes));
            List partitionTypes = (List)handle.getPartitionColumns().stream().map(HiveColumnHandle::getType).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < partitionNames.size(); ++i) {
                ComputedStatistics collectedStatistics;
                String partitionName = (String)partitionNames.get(i);
                List partitionValues2 = (List)partitionValuesList.get(i);
                ComputedStatistics computedStatistics2 = collectedStatistics = computedStatisticsMap.containsKey(partitionValues2) ? computedStatisticsMap.get(partitionValues2) : computedStatisticsMap.get(HiveMetadata.canonicalizePartitionValues(partitionName, partitionValues2, partitionTypes));
                if (collectedStatistics == null) {
                    partitionStatistics.put((Object)partitionValues2, (Object)((PartitionStatistics)emptyPartitionStatistics.get()));
                    continue;
                }
                partitionStatistics.put((Object)partitionValues2, (Object)this.createPartitionStatistics(columnTypes, collectedStatistics));
            }
            this.metastore.setPartitionStatistics(table, (Map<List<String>, PartitionStatistics>)partitionStatistics.buildOrThrow());
        }
    }

    private static List<String> canonicalizePartitionValues(String partitionName, List<String> partitionValues, List<Type> partitionTypes) {
        Verify.verify((partitionValues.size() == partitionTypes.size() ? 1 : 0) != 0, (String)"Expected partitionTypes size to be %s but got %s", (int)partitionValues.size(), (int)partitionTypes.size());
        Block[] parsedPartitionValuesBlocks = new Block[partitionValues.size()];
        for (int i = 0; i < partitionValues.size(); ++i) {
            String partitionValue = partitionValues.get(i);
            Type partitionType = partitionTypes.get(i);
            parsedPartitionValuesBlocks[i] = HiveUtil.parsePartitionValue(partitionName, partitionValue, partitionType).asBlock();
        }
        return HiveWriteUtils.createPartitionValues(partitionTypes, new Page(parsedPartitionValuesBlocks), 0);
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        Optional<Location> externalLocation = Optional.ofNullable(HiveTableProperties.getExternalLocation(tableMetadata.getProperties())).map(HiveMetadata::getValidatedExternalLocation);
        if (!this.createsOfNonManagedTablesEnabled && externalLocation.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Creating non-managed Hive tables is disabled");
        }
        if (!this.writesToNonManagedTablesEnabled && externalLocation.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writes to non-managed Hive tables is disabled");
        }
        boolean isTransactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        if (isTransactional) {
            this.metastore.checkSupportsHiveAcidTransactions();
        }
        if (isTransactional && externalLocation.isEmpty() && HiveSessionProperties.isDelegateTransactionalManagedTableLocationToMetastore(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS is not supported for transactional tables without explicit location if location determining is delegated to metastore");
        }
        if (isTransactional && retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS is not supported for transactional tables with query retries enabled");
        }
        if (HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema url is set");
        }
        if (HiveTableProperties.getAvroSchemaLiteral(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema literal is set");
        }
        HiveTableProperties.getHeaderSkipCount(tableMetadata.getProperties()).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Creating Hive table with data with value of %s property greater than 1 is not supported", SKIP_HEADER_COUNT_KEY));
            }
        });
        HiveTableProperties.getFooterSkipCount(tableMetadata.getProperties()).ifPresent(footerSkipCount -> {
            if (footerSkipCount > 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Creating Hive table with data with value of %s property greater than 0 is not supported", SKIP_FOOTER_COUNT_KEY));
            }
        });
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, session);
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        actualStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = (List)partitionedBy.stream().map(((Map)columnHandlesByName)::get).collect(ImmutableList.toImmutableList());
        this.checkPartitionTypesSupported(partitionColumns);
        LocationHandle locationHandle = this.locationService.forNewTableAsSelect(this.metastore, session, schemaName, tableName, externalLocation);
        AcidTransaction transaction = isTransactional ? AcidTransaction.forCreateTable() : AcidTransaction.NO_ACID_TRANSACTION;
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, this.metastore.generatePageSinkMetadata(schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, bucketProperty, session.getUser(), tableProperties, transaction, externalLocation.isPresent(), retryMode != RetryMode.NO_RETRIES);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.writeMode(), writeInfo.writePath(), schemaTableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        PartitionStatistics tableStatistics;
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = (List<PartitionUpdate>)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), Optional.of(writeInfo.targetPath()), handle.isExternal(), this.trinoVersion, this.accessControlMetadata.isUsingSystemSecurity());
        PrincipalPrivileges principalPrivileges = this.accessControlMetadata.isUsingSystemSecurity() ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates((Iterable<PartitionUpdate>)partitionUpdates);
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, true, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                Location writePath = Location.of((String)partitionUpdate.getWritePath().toString());
                this.createEmptyFiles(session, writePath, table, partition, partitionUpdate.getFileNames());
            }
            if (handle.isTransactional()) {
                AcidTransaction transaction = handle.getTransaction();
                List partitionNames = (List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList());
                this.metastore.addDynamicPartitions(handle.getSchemaName(), handle.getTableName(), partitionNames, transaction.getAcidTransactionId(), transaction.getWriteId(), AcidOperation.CREATE_TABLE);
            }
        }
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> this.typeManager.getType(column.getHiveType().getTypeSignature())));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, handle.getPartitionedBy(), columnTypes);
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics basicStatistics = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce((first, second) -> Statistics.reduce(first, second, Statistics.ReduceOperator.ADD)).orElse(HiveBasicStatistics.createZeroStatistics());
            tableStatistics = this.createPartitionStatistics(basicStatistics, columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
        } else {
            tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
        Optional<Location> writePath = Optional.of(writeInfo.writePath());
        if (handle.getPartitionedBy().isEmpty()) {
            Object fileNames = partitionUpdates.isEmpty() ? ImmutableList.of() : ((PartitionUpdate)Iterables.getOnlyElement(partitionUpdates)).getFileNames();
            this.metastore.createTable(session, table, principalPrivileges, writePath, Optional.of(fileNames), false, tableStatistics, handle.isRetriesEnabled());
        } else {
            this.metastore.createTable(session, table, principalPrivileges, writePath, Optional.empty(), false, tableStatistics, false);
        }
        if (!handle.getPartitionedBy().isEmpty()) {
            if (HiveSessionProperties.isRespectTableFormat(session)) {
                Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
            }
            for (PartitionUpdate update : partitionUpdates) {
                Partition partition = this.buildPartitionObject(session, table, update);
                List<String> canonicalPartitionValues = partition.getValues();
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(update.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, canonicalPartitionValues));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), this.buildPartitionObject(session, table, update), update.getWritePath(), Optional.of(update.getFileNames()), partitionStatistics, handle.isRetriesEnabled());
            }
        }
        return Optional.of(new HiveWrittenPartitions((List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList())));
    }

    private List<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, boolean isCreateTable, List<PartitionUpdate> partitionUpdates) {
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, bucketCount, isCreateTable && handle.isTransactional(), partitionUpdate);
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), fileNamesForMissingBuckets, 0L, 0L, 0L));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, int bucketCount, boolean transactionalCreateTable, PartitionUpdate partitionUpdate) {
        if (partitionUpdate.getFileNames().size() == bucketCount) {
            return ImmutableList.of();
        }
        ImmutableSet fileNames = ImmutableSet.copyOf(partitionUpdate.getFileNames());
        Set bucketsWithFiles = (Set)fileNames.stream().map(HiveWriterFactory::getBucketFromFileName).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            if (bucketsWithFiles.contains(i)) continue;
            missingFileNamesBuilder.add((Object)(transactionalCreateTable ? HiveWriterFactory.computeTransactionalBucketedFilename(i) : HiveWriterFactory.computeNonTransactionalBucketedFilename(session.getQueryId(), i)));
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((fileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    private void createEmptyFiles(ConnectorSession session, Location path, Table table, Optional<Partition> partition, List<String> fileNames) {
        StorageFormat format;
        Map<String, String> schema;
        if (partition.isPresent()) {
            schema = MetastoreUtil.getHiveSchema(partition.get(), table);
            format = partition.get().getStorage().getStorageFormat();
        } else {
            schema = MetastoreUtil.getHiveSchema(table);
            format = table.getStorage().getStorageFormat();
        }
        for (String fileName : fileNames) {
            Location location = path.appendPath(fileName);
            ((FileWriter)this.fileWriterFactories.stream().map(factory -> factory.createFileWriter(location, (List<String>)ImmutableList.of(), format, HiveCompressionCodec.NONE, schema, session, OptionalInt.empty(), AcidTransaction.NO_ACID_TRANSACTION, false, WriterKind.INSERT)).flatMap(Optional::stream).findFirst().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Writing not supported for " + format))).commit();
        }
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<Map<String, String>> properties = handle.getTableParameters();
        if (AcidTables.isTransactionalTable(properties.get())) {
            return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, MODIFYING_NON_TRANSACTIONAL_TABLE_MESSAGE);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (!AcidTables.isFullAcidTable(table.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, MODIFYING_NON_TRANSACTIONAL_TABLE_MESSAGE);
        }
        HiveInsertTableHandle insertHandle = this.beginInsertOrMerge(session, tableHandle, retryMode, "Merging into", true);
        return new HiveMergeTableHandle(hiveTableHandle.withTransaction(insertHandle.getTransaction()), insertHandle);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveMergeTableHandle mergeHandle = (HiveMergeTableHandle)mergeTableHandle;
        HiveInsertTableHandle insertHandle = mergeHandle.getInsertHandle();
        HiveTableHandle handle = mergeHandle.getTableHandle();
        Preconditions.checkArgument((boolean)handle.isAcidMerge(), (String)"handle should be a merge handle, but is %s", (Object)handle);
        Objects.requireNonNull(fragments, "fragments is null");
        List partitionMergeResults = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> PartitionUpdateAndMergeResults.CODEC.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        List partitionUpdates = (List)partitionMergeResults.stream().map(PartitionUpdateAndMergeResults::getPartitionUpdate).collect(ImmutableList.toImmutableList());
        Table table = this.finishChangingTable(AcidOperation.MERGE, "merge", session, insertHandle, partitionUpdates, computedStatistics);
        for (PartitionUpdateAndMergeResults results : partitionMergeResults) {
            results.getDeltaDirectory().ifPresent(directory -> this.createOrcAcidVersionFile(session.getIdentity(), (String)directory));
            results.getDeleteDeltaDirectory().ifPresent(directory -> this.createOrcAcidVersionFile(session.getIdentity(), (String)directory));
        }
        List partitions = (List)partitionUpdates.stream().filter(update -> !update.getName().isEmpty()).map(update -> this.buildPartitionObject(session, table, (PartitionUpdate)update)).collect(ImmutableList.toImmutableList());
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.finishMerge(session, table.getDatabaseName(), table.getTableName(), writeInfo.writePath(), partitionMergeResults, partitions);
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        return this.beginInsertOrMerge(session, tableHandle, retryMode, "Inserting into", false);
    }

    private HiveInsertTableHandle beginInsertOrMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode, String description, boolean isForMerge) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s Hive table %s with column type %s not supported", description, tableName, column.getType()));
        }
        boolean isTransactional = AcidTables.isTransactionalTable(table.getParameters());
        if (isTransactional && retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, description + " Hive transactional tables is not supported with query retries enabled");
        }
        if (isTransactional && !this.autoCommit) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, description + " Hive transactional tables is not supported in explicit transactions (use autocommit mode)");
        }
        if (HiveUtil.isSparkBucketedTable(table)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, description + " Spark bucketed tables is not supported");
        }
        List handles = (List)HiveUtil.hiveColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableList.toImmutableList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table);
        Optional.ofNullable(table.getParameters().get(SKIP_HEADER_COUNT_KEY)).map(Integer::parseInt).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s Hive table with value of %s property greater than 1 is not supported", description, SKIP_HEADER_COUNT_KEY));
            }
        });
        if (table.getParameters().containsKey(SKIP_FOOTER_COUNT_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s Hive table with %s property not supported", description, SKIP_FOOTER_COUNT_KEY));
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        AcidTransaction transaction = AcidTransaction.NO_ACID_TRANSACTION;
        if (isForMerge) {
            Preconditions.checkArgument((boolean)isTransactional, (Object)"The target table in Hive MERGE must be a transactional table");
            transaction = this.metastore.beginMerge(session, table);
        } else if (isTransactional) {
            transaction = this.metastore.beginInsert(session, table);
        }
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, this.metastore.generatePageSinkMetadata(tableName), locationHandle, table.getStorage().getBucketProperty(), tableStorageFormat, HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session), transaction, retryMode != RetryMode.NO_RETRIES);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        if (HiveSessionProperties.getInsertExistingPartitionsBehavior(session) == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE && writeInfo.writeMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY) {
            if (isTransactional) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting existing partition in transactional tables doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
            }
            if (!this.autoCommit) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting existing partition in non auto commit context doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
            }
        }
        this.metastore.declareIntentionToWrite(session, writeInfo.writeMode(), writeInfo.writePath(), tableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List partitionUpdates = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        Table table = this.finishChangingTable(AcidOperation.INSERT, "insert", session, handle, partitionUpdates, computedStatistics);
        if (AcidTables.isFullAcidTable(table.getParameters())) {
            for (PartitionUpdate update : partitionUpdates) {
                String deltaSubdir = AcidTables.deltaSubdir(handle.getTransaction().getWriteId(), 0);
                String directory = "%s/%s/%s".formatted(table.getStorage().getLocation(), update.getName(), deltaSubdir);
                this.createOrcAcidVersionFile(session.getIdentity(), directory);
            }
        }
        return Optional.of(new HiveWrittenPartitions((List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList())));
    }

    private Table finishChangingTable(AcidOperation acidOperation, String changeDescription, ConnectorSession session, HiveInsertTableHandle handle, List<PartitionUpdate> partitionUpdates, Collection<ComputedStatistics> computedStatistics) {
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (!table.getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during " + changeDescription);
        }
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, false, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition;
                Optional<Partition> optional = partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                if (handle.isTransactional() && partition.isPresent()) {
                    PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(partitionUpdate.getStatistics()).build();
                    this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition.get(), partitionUpdate.getWritePath(), Optional.of(partitionUpdate.getFileNames()), statistics, handle.isRetriesEnabled());
                }
                Location writePath = Location.of((String)partitionUpdate.getWritePath().toString());
                this.createEmptyFiles(session, writePath, table, partition, partitionUpdate.getFileNames());
            }
        }
        List partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> this.typeManager.getType(column.getHiveType().getTypeSignature())));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionedBy, columnTypes);
        ImmutableList.Builder partitionUpdateInfosBuilder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            if (partitionUpdate.getName().isEmpty()) {
                if (!table.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during " + changeDescription);
                }
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos(this.metastore.listTablePrivileges(handle.getSchemaName(), handle.getTableName(), Optional.empty()));
                    this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
                    this.metastore.createTable(session, table, principalPrivileges, Optional.of(partitionUpdate.getWritePath()), Optional.of(partitionUpdate.getFileNames()), false, partitionStatistics, handle.isRetriesEnabled());
                    continue;
                }
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                    this.metastore.finishChangingExistingTable(acidOperation, session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics, handle.isRetriesEnabled());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported update mode: " + partitionUpdate.getUpdateMode());
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                String partitionName = partitionUpdate.getName();
                List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
                List partitionTypes = (List)partitionedBy.stream().map(columnTypes::get).collect(ImmutableList.toImmutableList());
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partitionName, partitionValues, partitionTypes));
                partitionUpdateInfosBuilder.add((Object)new SemiTransactionalHiveMetastore.PartitionUpdateInfo(partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics));
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                Partition partition = this.buildPartitionObject(session, table, partitionUpdate);
                if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
                }
                String partitionName = partitionUpdate.getName();
                List<String> partitionValues = partition.getValues();
                List partitionTypes = (List)partitionedBy.stream().map(columnTypes::get).collect(ImmutableList.toImmutableList());
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partitionName, partitionValues, partitionTypes));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    if (handle.getLocationHandle().getWriteMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY) {
                        this.removeNonCurrentQueryFiles(session, partitionUpdate.getTargetPath());
                        if (!handle.isRetriesEnabled()) continue;
                        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
                        SemiTransactionalHiveMetastore.cleanExtraOutputFiles(fileSystem, session.getQueryId(), partitionUpdate.getTargetPath(), (Set<String>)ImmutableSet.copyOf(partitionUpdate.getFileNames()));
                        continue;
                    }
                    this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), partition.getValues(), true);
                    this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), Optional.of(partitionUpdate.getFileNames()), partitionStatistics, handle.isRetriesEnabled());
                    continue;
                }
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), Optional.of(partitionUpdate.getFileNames()), partitionStatistics, handle.isRetriesEnabled());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported update mode: %s", new Object[]{partitionUpdate.getUpdateMode()}));
        }
        ImmutableList partitionUpdateInfos = partitionUpdateInfosBuilder.build();
        if (!partitionUpdateInfos.isEmpty()) {
            this.metastore.finishInsertIntoExistingPartitions(session, handle.getSchemaName(), handle.getTableName(), (List<SemiTransactionalHiveMetastore.PartitionUpdateInfo>)partitionUpdateInfos, handle.isRetriesEnabled());
        }
        return table;
    }

    private void removeNonCurrentQueryFiles(ConnectorSession session, Location partitionLocation) {
        String queryId = session.getQueryId();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            FileIterator iterator = fileSystem.listFiles(partitionLocation);
            while (iterator.hasNext()) {
                Location location = iterator.next().location();
                if (HiveWriteUtils.isFileCreatedByQuery(location.fileName(), queryId)) continue;
                fileSystem.deleteFile(location);
            }
        }
        catch (Exception ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to delete partition %s files during overwrite", partitionLocation), (Throwable)ex);
        }
    }

    private void createOrcAcidVersionFile(ConnectorIdentity identity, String deltaDirectory) {
        try {
            AcidTables.writeAcidVersionFile(this.fileSystemFactory.create(identity), Location.of((String)deltaDirectory));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Exception writing _orc_acid_version file for delta directory: " + deltaDirectory, (Throwable)e);
        }
    }

    private Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionUpdate.getName())).setParameters((Map<String, String>)ImmutableMap.builder().put((Object)TRINO_VERSION_NAME, (Object)this.trinoVersion).put((Object)TRINO_QUERY_ID_NAME, (Object)session.getQueryId()).buildOrThrow()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat(HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private PartitionStatistics createPartitionStatistics(Map<String, Type> columnTypes, ComputedStatistics computedStatistics) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = Optional.ofNullable((Block)computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return this.createPartitionStatistics(rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics);
    }

    private PartitionStatistics createPartitionStatistics(HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map<String, HiveColumnStatistics> columnStatistics = Statistics.fromComputedStatistics(computedColumnStatistics, columnTypes, rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, List<String> partitionValues) {
        return Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    private static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, String partitionName, List<String> partitionValues, List<Type> partitionTypes) {
        Optional<Map> columnStatistics = Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics);
        return columnStatistics.orElseGet(() -> HiveMetadata.getColumnStatistics(statistics, HiveMetadata.canonicalizePartitionValues(partitionName, partitionValues, partitionTypes)));
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle tableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        if (procedureName.equals("OPTIMIZE")) {
            return this.getTableHandleForOptimize(session, tableHandle, executeProperties, retryMode);
        }
        throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        if (!HiveSessionProperties.isNonTransactionalOptimizeEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "OPTIMIZE procedure must be explicitly enabled via non_transactional_optimize_enabled session property");
        }
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing Hive table %s with column type %s not supported", tableName, column.getType()));
        }
        if (AcidTables.isTransactionalTable(table.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing transactional Hive table %s is not supported", tableName));
        }
        if (table.getStorage().getBucketProperty().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing bucketed Hive table %s is not supported", tableName));
        }
        List columns = (List)HiveUtil.hiveColumnHandles(table, this.typeManager, HiveTimestampPrecision.NANOSECONDS).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableList.toImmutableList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table);
        Optional.ofNullable(table.getParameters().get(SKIP_HEADER_COUNT_KEY)).map(Integer::parseInt).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing Hive table %s with value of %s property greater than 1 is not supported", tableName, SKIP_HEADER_COUNT_KEY));
            }
        });
        if (table.getParameters().containsKey(SKIP_FOOTER_COUNT_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing Hive table %s with %s property not supported", tableName, SKIP_FOOTER_COUNT_KEY));
        }
        LocationHandle locationHandle = this.locationService.forOptimize(this.metastore, session, table);
        DataSize fileSizeThreshold = (DataSize)executeProperties.get("file_size_threshold");
        return Optional.of(new HiveTableExecuteHandle("OPTIMIZE", Optional.empty(), Optional.of(fileSizeThreshold.toBytes()), tableName.getSchemaName(), tableName.getTableName(), columns, this.metastore.generatePageSinkMetadata(tableName), locationHandle, table.getStorage().getBucketProperty(), tableStorageFormat, tableStorageFormat, AcidTransaction.NO_ACID_TRANSACTION, retryMode != RetryMode.NO_RETRIES));
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        String procedureName = ((HiveTableExecuteHandle)tableExecuteHandle).getProcedureName();
        if (procedureName.equals("OPTIMIZE")) {
            return this.beginOptimize(session, tableExecuteHandle, updatedSourceTableHandle);
        }
        throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle sourceTableHandle) {
        HiveTableExecuteHandle hiveExecuteHandle = (HiveTableExecuteHandle)tableExecuteHandle;
        HiveTableHandle hiveSourceTableHandle = (HiveTableHandle)sourceTableHandle;
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(hiveExecuteHandle.getLocationHandle());
        String writeDeclarationId = this.metastore.declareIntentionToWrite(session, writeInfo.writeMode(), writeInfo.writePath(), hiveExecuteHandle.getSchemaTableName());
        return new BeginTableExecuteResult((Object)hiveExecuteHandle.withWriteDeclarationId(writeDeclarationId), (Object)hiveSourceTableHandle.withMaxScannedFileSize(hiveExecuteHandle.getMaxScannedFileSize()).withRecordScannedFiles(true));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        String procedureName = ((HiveTableExecuteHandle)tableExecuteHandle).getProcedureName();
        if (procedureName.equals("OPTIMIZE")) {
            this.finishOptimize(session, tableExecuteHandle, fragments, splitSourceInfo);
            return;
        }
        throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
    }

    private void finishOptimize(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        HiveTableExecuteHandle handle = (HiveTableExecuteHandle)tableExecuteHandle;
        Preconditions.checkArgument((boolean)handle.getWriteDeclarationId().isPresent(), (Object)"no write declaration id present in tableExecuteHandle");
        List<PartitionUpdate> partitionUpdates = (List<PartitionUpdate>)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates((Iterable<PartitionUpdate>)partitionUpdates);
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (!table.getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during optimize");
        }
        Verify.verify((boolean)handle.getBucketProperty().isEmpty(), (String)"bucketed table not supported", (Object[])new Object[0]);
        ImmutableList.Builder partitionUpdateInfosBuilder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            Verify.verify((partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND ? 1 : 0) != 0, (String)"Expected partionUpdate mode to be APPEND but got %s", (Object)((Object)partitionUpdate.getUpdateMode()));
            if (partitionUpdate.getName().isEmpty()) {
                if (!table.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during optimize");
                }
                AcidOperation operation = handle.getTransaction().getOperation();
                if (operation == AcidOperation.NONE) {
                    operation = AcidOperation.INSERT;
                }
                this.metastore.finishChangingExistingTable(operation, session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), PartitionStatistics.empty(), handle.isRetriesEnabled());
                continue;
            }
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionUpdate.getName());
            partitionUpdateInfosBuilder.add((Object)new SemiTransactionalHiveMetastore.PartitionUpdateInfo(partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), PartitionStatistics.empty()));
        }
        ImmutableList partitionUpdateInfos = partitionUpdateInfosBuilder.build();
        if (!partitionUpdateInfos.isEmpty()) {
            this.metastore.finishInsertIntoExistingPartitions(session, handle.getSchemaName(), handle.getTableName(), (List<SemiTransactionalHiveMetastore.PartitionUpdateInfo>)partitionUpdateInfos, handle.isRetriesEnabled());
        }
        Set scannedPaths = (Set)splitSourceInfo.stream().map(file -> Location.of((String)((String)file))).collect(ImmutableSet.toImmutableSet());
        HashSet remainingFilesToDelete = new HashSet(scannedPaths);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        boolean someDeleted = false;
        Optional<Object> firstScannedPath = Optional.empty();
        try {
            for (Location scannedPath : scannedPaths) {
                if (firstScannedPath.isEmpty()) {
                    firstScannedPath = Optional.of(scannedPath);
                }
                RetryDriver.retry().run("delete " + scannedPath, () -> {
                    try {
                        fileSystem.deleteFile(scannedPath);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    return null;
                });
                someDeleted = true;
                remainingFilesToDelete.remove(scannedPath);
            }
        }
        catch (Exception e) {
            if (!someDeleted && (firstScannedPath.isEmpty() || HiveMetadata.exists(fileSystem, (Location)firstScannedPath.get()))) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Error while deleting original files", (Throwable)e);
            }
            this.metastore.dropDeclaredIntentionToWrite(handle.getWriteDeclarationId().get());
            String errorMessage = "Error while deleting data files in FINISH phase of OPTIMIZE for table " + table.getTableName() + "; remaining files need to be deleted manually:  " + remainingFilesToDelete;
            log.error((Throwable)e, "%s", new Object[]{errorMessage});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, errorMessage, (Throwable)e);
        }
    }

    private static boolean exists(TrinoFileSystem fs, Location location) {
        try {
            return fs.newInputFile(location).exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        if (this.accessControlMetadata.isUsingSystemSecurity()) {
            definition = definition.withoutOwner();
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)PRESTO_VIEW_COMMENT).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)"Trino Hive connector").put((Object)TRINO_VERSION_NAME, (Object)this.trinoVersion).put((Object)TRINO_QUERY_ID_NAME, (Object)session.getQueryId()).buildOrThrow();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty(), (Map<String, String>)ImmutableMap.of());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(this.accessControlMetadata.isUsingSystemSecurity() ? Optional.empty() : Optional.ofNullable(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters((Map<String, String>)properties).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData(definition))).setViewExpandedText(Optional.of(PRESTO_VIEW_EXPANDED_TEXT_MARKER));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = this.accessControlMetadata.isUsingSystemSecurity() ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isTrinoView(existing.get())) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), Optional.empty(), false, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of()), false);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.setTableAuthorization(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.getView(session, viewName).isEmpty()) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(session, viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> optionalSchemaName) {
        Optional<List<SchemaTableName>> allViews;
        ImmutableSet materializedViews = ImmutableSet.copyOf(this.listMaterializedViews(session, optionalSchemaName));
        if (optionalSchemaName.isEmpty() && (allViews = this.metastore.getAllViews()).isPresent()) {
            return (List)allViews.get().stream().filter(view -> !HiveUtil.isHiveSystemSchema(view.getSchemaName())).filter(arg_0 -> HiveMetadata.lambda$listViews$83((Set)materializedViews, arg_0)).collect(ImmutableList.toImmutableList());
        }
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllViews(schemaName)) {
                SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
                if (materializedViews.contains(schemaTableName)) continue;
                tableNames.add((Object)schemaTableName);
            }
        }
        return tableNames.build();
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, String schemaName) {
        if (HiveUtil.isHiveSystemSchema(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Schema properties are not supported for system schema: " + schemaName);
        }
        return this.metastore.getDatabase(schemaName).map(HiveSchemaProperties::fromDatabase).orElseThrow(() -> new SchemaNotFoundException(schemaName));
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, String schemaName) {
        if (HiveUtil.isHiveSystemSchema(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Schema owner is not supported for system schema: " + schemaName);
        }
        return this.accessControlMetadata.getSchemaOwner(session, schemaName).map(HivePrincipal::toTrinoPrincipal);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(session, schemaName)) {
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR.toErrorCode()) || e.getErrorCode().equals((Object)HiveErrorCode.HIVE_INVALID_VIEW_DATA.toErrorCode()) || e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || e instanceof TableNotFoundException || e instanceof ViewNotFoundException) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        if (HiveUtil.isHiveSystemSchema(viewName.getSchemaName())) {
            return Optional.empty();
        }
        return this.toConnectorViewDefinition(session, viewName, this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()));
    }

    private Optional<ConnectorViewDefinition> toConnectorViewDefinition(ConnectorSession session, SchemaTableName viewName, Optional<Table> table) {
        return table.flatMap(view -> {
            if (!ViewReaderUtil.isTrinoView(view)) {
                if (ViewReaderUtil.isHiveView(view)) {
                    if (!this.translateHiveViews) {
                        throw new HiveViewNotSupportedException(viewName);
                    }
                } else {
                    return Optional.empty();
                }
            }
            ConnectorViewDefinition definition = ViewReaderUtil.createViewReader(this.metastore, session, view, this.typeManager, this::redirectTable, this.metadataProvider, this.hiveViewsRunAsInvoker, this.hiveViewsTimestampPrecision).decodeViewData(view.getViewOriginalText().get(), (Table)view, this.catalogName);
            if (view.getOwner().isPresent() && !definition.isRunAsInvoker()) {
                definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), definition.getComment(), view.getOwner(), false, definition.getPath());
            }
            return Optional.of(definition);
        });
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.mergeRowIdColumnHandle();
    }

    public Optional<ConnectorPartitioningHandle> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getInsertLayout(session, tableHandle).flatMap(ConnectorTableLayout::getPartitioning).map(HivePartitioningHandle.class::cast).map(handle -> new HiveUpdateHandle(handle.getBucketingVersion(), handle.getBucketCount(), handle.getHiveTypes(), handle.getMaxCompatibleBucketCount(), handle.isUsePartitionedBucketing()));
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        Map<String, String> parameters = ((HiveTableHandle)handle).getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing from handle"));
        return AcidTables.isFullAcidTable(parameters) ? Optional.empty() : Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle deleteHandle) {
        HiveTableHandle handle = (HiveTableHandle)deleteHandle;
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            Iterator<HivePartition> partitions = this.partitionManager.getPartitions(this.metastore, handle);
            ArrayList<String> partitionIds = new ArrayList<String>();
            while (partitions.hasNext()) {
                partitionIds.add(partitions.next().getPartitionId());
                if ((long)partitionIds.size() <= this.maxPartitionDropsPerQuery) continue;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Failed to drop partitions. The number of partitions to be dropped is greater than the maximum allowed partitions (%s).", this.maxPartitionDropsPerQuery));
            }
            for (String partitionId : partitionIds) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(partitionId), true);
            }
        }
        return OptionalLong.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        Optional<List<HivePartition>> partitions;
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        ImmutableList partitionColumns = ImmutableList.copyOf(hiveTable.getPartitionColumns());
        TupleDomain<ColumnHandle> predicate = TupleDomain.all();
        Optional<Object> discretePredicates = Optional.empty();
        if (hiveTable.getPartitionNames().isEmpty() && (partitions = hiveTable.getPartitions().or(() -> {
            HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, table, new Constraint(hiveTable.getEnforcedConstraint()));
            return this.partitionManager.tryLoadPartitions(partitionResult);
        })).isPresent()) {
            List<HivePartition> hivePartitions = partitions.orElseThrow();
            predicate = HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, hivePartitions);
            if (!partitionColumns.isEmpty()) {
                Iterable partitionDomains = Iterables.transform(hivePartitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
                discretePredicates = Optional.of(new DiscretePredicates((List)partitionColumns, partitionDomains));
            }
        }
        Optional<Object> tablePartitioning = Optional.empty();
        Object sortingProperties = ImmutableList.of();
        if (hiveTable.getBucketHandle().isPresent()) {
            if (HiveSessionProperties.isPropagateTableScanSortingProperties(session) && !hiveTable.getBucketHandle().get().getSortedBy().isEmpty()) {
                Map<String, ColumnHandle> columnHandles = this.getColumnHandles(session, table);
                sortingProperties = (List)hiveTable.getBucketHandle().get().getSortedBy().stream().map(sortingColumn -> new SortingProperty((Object)((ColumnHandle)columnHandles.get(sortingColumn.getColumnName())), sortingColumn.getOrder().getSortOrder())).collect(ImmutableList.toImmutableList());
            }
            if (HiveSessionProperties.isBucketExecutionEnabled(session)) {
                tablePartitioning = hiveTable.getBucketHandle().map(bucketing -> new ConnectorTablePartitioning((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketing.getBucketingVersion(), bucketing.getReadBucketCount(), (List)bucketing.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), OptionalInt.empty(), false), (List)bucketing.getColumns().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList())));
            }
        }
        return new ConnectorTableProperties((TupleDomain)predicate, tablePartitioning, discretePredicates, (List)sortingProperties);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((handle.getAnalyzePartitionValues().isEmpty() || constraint.getSummary().isAll() ? 1 : 0) != 0, (Object)"Analyze should not have a constraint");
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, handle, constraint);
        HiveTableHandle newHandle = this.partitionManager.applyPartitionResult(handle, partitionResult, constraint);
        if (handle.getPartitions().equals(newHandle.getPartitions()) && handle.getPartitionNames().equals(newHandle.getPartitionNames()) && handle.getCompactEffectivePredicate().equals(newHandle.getCompactEffectivePredicate()) && handle.getBucketFilter().equals(newHandle.getBucketFilter()) && handle.getConstraintColumns().equals(newHandle.getConstraintColumns())) {
            return Optional.empty();
        }
        TupleDomain unenforcedConstraint = partitionResult.getEffectivePredicate();
        if (newHandle.getPartitions().isPresent()) {
            List<HiveColumnHandle> partitionColumns = partitionResult.getPartitionColumns();
            unenforcedConstraint = partitionResult.getEffectivePredicate().filter((column, domain) -> !partitionColumns.contains(column));
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, unenforcedConstraint, constraint.getExpression(), false));
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Set<ColumnHandle> referencedColumns;
        List<HiveColumnHandle> partitionColumns;
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (HiveMetadata.isQueryPartitionFilterRequiredForTable(session, handle.getSchemaTableName()) && handle.getAnalyzePartitionValues().isEmpty() && handle.getEnforcedConstraint().isAll() && !(partitionColumns = handle.getPartitionColumns()).isEmpty() && Collections.disjoint(referencedColumns = handle.getConstraintColumns(), partitionColumns)) {
            String partitionColumnNames = partitionColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(", "));
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Filter required on %s.%s for at least one partition column: %s", handle.getSchemaName(), handle.getTableName(), partitionColumnNames));
        }
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!HiveSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ApplyProjectionUtil::createProjectedColumnRepresentation));
        HiveTableHandle hiveTableHandle = (HiveTableHandle)handle;
        if (columnProjections.values().stream().allMatch(ApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            ImmutableSet projectedColumns = ImmutableSet.copyOf(assignments.values());
            if (hiveTableHandle.getProjectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((HiveColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)hiveTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ColumnHandle projectedColumnHandle;
            String projectedColumnName;
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (ApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            Optional<String> existingColumn = HiveApplyProjectionUtil.find(assignments, projectedColumn);
            if (existingColumn.isPresent()) {
                projectedColumnName = existingColumn.get();
                projectedColumnHandle = assignments.get(projectedColumnName);
            } else {
                HiveColumnHandle oldColumnHandle = (HiveColumnHandle)assignments.get(projectedColumn.getVariable().getName());
                projectedColumnHandle = this.createProjectedColumnHandle(oldColumnHandle, projectedColumn.getDereferenceIndices());
                projectedColumnName = ((HiveColumnHandle)projectedColumnHandle).getName();
            }
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, projectedColumnHandle, expression2.getType());
            newAssignments.put(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> HiveMetadata.lambda$applyProjection$97((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList outputAssignments = ImmutableList.copyOf(newAssignments.values());
        return Optional.of(new ProjectionApplicationResult((Object)hiveTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumnsBuilder.build()), newProjections, (List)outputAssignments, false));
    }

    private HiveColumnHandle createProjectedColumnHandle(HiveColumnHandle column, List<Integer> indices) {
        HiveType oldHiveType = column.getHiveType();
        HiveType newHiveType = oldHiveType.getHiveTypeForDereferences(indices).get();
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List<Integer>)ImmutableList.builder().addAll((Iterable)column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of())).addAll(indices).build(), (List<String>)ImmutableList.builder().addAll((Iterable)column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceNames).orElse((List)ImmutableList.of())).addAll(oldHiveType.getHiveDereferenceNames(indices)).build(), newHiveType, this.typeManager.getType(newHiveType.getTypeSignature()));
        return new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(columnProjectionInfo), column.getColumnType(), column.getComment());
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.hiveRedirectionsProvider.getTableScanRedirection(session, (HiveTableHandle)tableHandle);
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int smallerBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (leftHandle.isUsePartitionedBucketing() != rightHandle.isUsePartitionedBucketing()) {
            return Optional.empty();
        }
        if (!leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes())) {
            return Optional.empty();
        }
        if (leftHandle.getBucketingVersion() != rightHandle.getBucketingVersion()) {
            return Optional.empty();
        }
        if (leftHandle.getBucketCount() == rightHandle.getBucketCount()) {
            return Optional.of(leftHandle);
        }
        if (!HiveSessionProperties.isOptimizedMismatchedBucketCount(session)) {
            return Optional.empty();
        }
        int largerBucketCount = Math.max(leftHandle.getBucketCount(), rightHandle.getBucketCount());
        if (largerBucketCount % (smallerBucketCount = Math.min(leftHandle.getBucketCount(), rightHandle.getBucketCount())) != 0) {
            return Optional.empty();
        }
        if (Integer.bitCount(largerBucketCount / smallerBucketCount) != 1) {
            return Optional.empty();
        }
        OptionalInt maxCompatibleBucketCount = HiveMetadata.min(leftHandle.getMaxCompatibleBucketCount(), rightHandle.getMaxCompatibleBucketCount());
        if (maxCompatibleBucketCount.isPresent() && maxCompatibleBucketCount.getAsInt() < smallerBucketCount) {
            return Optional.empty();
        }
        return Optional.of(new HivePartitioningHandle(leftHandle.getBucketingVersion(), smallerBucketCount, leftHandle.getHiveTypes(), maxCompatibleBucketCount, false));
    }

    private static OptionalInt min(OptionalInt left, OptionalInt right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return OptionalInt.of(Math.min(left.getAsInt(), right.getAsInt()));
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HivePartitioningHandle hivePartitioningHandle = (HivePartitioningHandle)partitioningHandle;
        Preconditions.checkArgument((boolean)hiveTable.getBucketHandle().isPresent(), (Object)"Hive connector only provides alternative layout for bucketed table");
        HiveBucketHandle bucketHandle = hiveTable.getBucketHandle().get();
        ImmutableList bucketTypes = (ImmutableList)bucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)hivePartitioningHandle.getHiveTypes().equals(bucketTypes), (String)"Types from the new PartitioningHandle (%s) does not match the TableHandle (%s)", hivePartitioningHandle.getHiveTypes(), (Object)bucketTypes);
        int largerBucketCount = Math.max(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        int smallerBucketCount = Math.min(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        Preconditions.checkArgument((largerBucketCount % smallerBucketCount == 0 && Integer.bitCount(largerBucketCount / smallerBucketCount) == 1 ? 1 : 0) != 0, (Object)"The requested partitioning is not a valid alternative for the table layout");
        return new HiveTableHandle(hiveTable.getSchemaName(), hiveTable.getTableName(), hiveTable.getTableParameters(), hiveTable.getPartitionColumns(), hiveTable.getDataColumns(), hiveTable.getPartitionNames(), hiveTable.getPartitions(), hiveTable.getCompactEffectivePredicate(), hiveTable.getEnforcedConstraint(), Optional.of(new HiveBucketHandle(bucketHandle.getColumns(), bucketHandle.getBucketingVersion(), bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount(), bucketHandle.getSortedBy())), hiveTable.getBucketFilter(), hiveTable.getAnalyzePartitionValues(), (Set<ColumnHandle>)ImmutableSet.of(), (Set<ColumnHandle>)ImmutableSet.of(), hiveTable.getTransaction(), hiveTable.isRecordScannedFiles(), hiveTable.getMaxScannedFileSize());
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        boolean hasNaN = false;
        ArrayList<Object> nonNullValues = new ArrayList<Object>();
        Type type = ((HiveColumnHandle)column).getType();
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
                continue;
            }
            if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value.getValue())) {
                hasNaN = true;
            }
            nonNullValues.add(value.getValue());
        }
        Domain domain = nonNullValues.isEmpty() ? Domain.none((Type)type) : (hasNaN ? Domain.notNull((Type)type) : Domain.multipleValues((Type)type, nonNullValues));
        if (hasNull) {
            domain = domain.union(Domain.onlyNull((Type)type));
        }
        return domain;
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (table.getStorage().getBucketProperty().isPresent()) {
            if (!HiveBucketing.isSupportedBucketing(table)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to a table bucketed on an unsupported type");
            }
        } else if (AcidTables.isFullAcidTable(table.getParameters())) {
            table = Table.builder(table).withStorage(storage -> storage.setBucketProperty(Optional.of(new HiveBucketProperty((List<String>)ImmutableList.of(), HiveBucketing.BucketingVersion.BUCKETING_V2, 1, (List<SortingColumn>)ImmutableList.of())))).build();
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(session, table, this.typeManager);
        List<Column> partitionColumns = table.getPartitionColumns();
        if (hiveBucketHandle.isEmpty()) {
            if (partitionColumns.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorTableLayout((List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
        }
        HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        ImmutableList.Builder partitioningColumns = ImmutableList.builder();
        hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).forEach(arg_0 -> ((ImmutableList.Builder)partitioningColumns).add(arg_0));
        partitionColumns.stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)partitioningColumns).add(arg_0));
        boolean multipleWritersPerPartitionSupported = !AcidTables.isTransactionalTable(table.getParameters());
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(hiveBucketHandle.get().getBucketingVersion(), hiveBucketHandle.get().getTableBucketCount(), (List)hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), OptionalInt.of(hiveBucketHandle.get().getTableBucketCount()), !partitionColumns.isEmpty() && HiveSessionProperties.isParallelPartitionedBucketedWrites(session));
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, (List)partitioningColumns.build(), multipleWritersPerPartitionSupported));
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validateTimestampColumns(tableMetadata.getColumns(), HiveSessionProperties.getTimestampPrecision(session));
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (bucketProperty.isEmpty()) {
            if (partitionedBy.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorTableLayout(partitionedBy));
        }
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        boolean multipleWritersPerPartitionSupported = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false) == false;
        List<String> bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(column.getType())));
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketProperty.get().getBucketingVersion(), bucketProperty.get().getBucketCount(), (List)bucketedBy.stream().map(hiveTypeMap::get).collect(ImmutableList.toImmutableList()), OptionalInt.of(bucketProperty.get().getBucketCount()), !partitionedBy.isEmpty() && HiveSessionProperties.isParallelPartitionedBucketedWrites(session)), (List)ImmutableList.builder().addAll(bucketedBy).addAll(partitionedBy).build(), multipleWritersPerPartitionSupported));
    }

    public Optional<Type> getSupportedType(ConnectorSession session, Map<String, Object> tableProperties, Type type) {
        VarcharType varcharType;
        if (type instanceof VarcharType && !(varcharType = (VarcharType)type).isUnbounded() && varcharType.getBoundedLength() == 0) {
            return Optional.of(VarcharType.createVarcharType((int)1));
        }
        return Optional.empty();
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle executeHandle) {
        HiveTableExecuteHandle hiveExecuteHandle = (HiveTableExecuteHandle)executeHandle;
        SchemaTableName tableName = hiveExecuteHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (table.getStorage().getBucketProperty().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing bucketed Hive table %s is not supported", tableName));
        }
        if (AcidTables.isTransactionalTable(table.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimizing transactional Hive table %s is not supported", tableName));
        }
        List<Column> partitionColumns = table.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout((List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!HiveSessionProperties.isCollectColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table statistics must be enabled when column statistics collection on write is enabled");
        }
        if (HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false).booleanValue()) {
            return TableStatisticsMetadata.empty();
        }
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, Optional.empty(), false);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(List<ColumnMetadata> columns, List<String> partitionedBy, Optional<Set<String>> analyzeColumns, boolean includeRowCount) {
        Set columnStatistics = (Set)columns.stream().filter(column -> !partitionedBy.contains(column.getName())).filter(column -> !column.isHidden()).filter(column -> analyzeColumns.isEmpty() || ((Set)analyzeColumns.get()).contains(column.getName())).map(this::getColumnStatisticMetadata).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = includeRowCount ? ImmutableSet.of((Object)TableStatisticType.ROW_COUNT) : ImmutableSet.of();
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, partitionedBy);
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(ColumnMetadata columnMetadata) {
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.metastore.getSupportedColumnStatistics(columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(String columnName, Set<HiveColumnStatisticType> statisticTypes) {
        return (List)statisticTypes.stream().map(type -> type.createColumnStatisticMetadata(columnName)).collect(ImmutableList.toImmutableList());
    }

    public Collection<LanguageFunction> listLanguageFunctions(ConnectorSession session, String schemaName) {
        return this.metastore.getFunctions(schemaName);
    }

    public Collection<LanguageFunction> getLanguageFunctions(ConnectorSession session, SchemaFunctionName name) {
        return this.metastore.getFunctions(name);
    }

    public boolean languageFunctionExists(ConnectorSession session, SchemaFunctionName name, String signatureToken) {
        return this.metastore.functionExists(name, signatureToken);
    }

    public void createLanguageFunction(ConnectorSession session, SchemaFunctionName name, LanguageFunction function, boolean replace) {
        if (replace) {
            this.metastore.replaceFunction(name, function);
        } else {
            this.metastore.createFunction(name, function);
        }
    }

    public void dropLanguageFunction(ConnectorSession session, SchemaFunctionName name, String signatureToken) {
        this.metastore.dropFunction(name, signatureToken);
    }

    public boolean roleExists(ConnectorSession session, String role) {
        return this.accessControlMetadata.roleExists(session, role);
    }

    public void createRole(ConnectorSession session, String role, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
        return ImmutableSet.copyOf(this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from(principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), adminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOption, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from(principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantSchemaPrivileges(session, schemaName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeSchemaPrivileges(session, schemaName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        return HiveMetadata.extractHiveStorageFormat(table.getStorage().getStorageFormat());
    }

    public static HiveStorageFormat extractHiveStorageFormat(StorageFormat storageFormat) {
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerde();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerde().equals(serde)) continue;
            return format;
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    private static void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List<String> bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isEmpty()) {
            return;
        }
        Set allColumns = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(bucketedBy), (Set)allColumns)));
        }
        ImmutableSet partitionColumns = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        if (bucketedBy.stream().anyMatch(((Set)partitionColumns)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s are also used as partitioning columns", Sets.intersection((Set)ImmutableSet.copyOf(bucketedBy), (Set)partitionColumns)));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)allColumns)));
        }
        if (sortedBy.stream().anyMatch(((Set)partitionColumns)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s are also used as partitioning columns", Sets.intersection((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)partitionColumns)));
        }
        List dataColumns = (List)tableMetadata.getColumns().stream().map(columnMetadata -> new Column(columnMetadata.getName(), HiveType.toHiveType(columnMetadata.getType()), Optional.ofNullable(columnMetadata.getComment()), (Map<String, String>)ImmutableMap.of())).collect(ImmutableList.toImmutableList());
        if (!HiveBucketing.isSupportedBucketing(bucketProperty.get(), dataColumns, tableMetadata.getTable().getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create a table bucketed on an unsupported type");
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = (List)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf((Collection)allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    private static List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)HiveColumnHandle.createBaseColumn(column.getName(), ordinal, HiveType.toHiveType(column.getType()), column.getType(), columnType, Optional.ofNullable(column.getComment())));
            ++ordinal;
        }
        return columnHandles.build();
    }

    private static void validateColumns(ConnectorTableMetadata tableMetadata) {
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            String columnName = column.getName();
            if (columnName.startsWith(" ")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not start with a space: '%s'", columnName));
            }
            if (columnName.endsWith(" ")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not end with a space: '%s'", columnName));
            }
            if (columnName.contains(",")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not contain commas: '%s'", columnName));
            }
            HiveType.toHiveType(column.getType());
        }
        if (HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties()) != HiveStorageFormat.CSV) {
            return;
        }
        ImmutableSet partitionedBy = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        List unsupportedColumns = (List)tableMetadata.getColumns().stream().filter(arg_0 -> HiveMetadata.lambda$validateColumns$109((Set)partitionedBy, arg_0)).filter(columnMetadata -> !columnMetadata.getType().equals(VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        if (!unsupportedColumns.isEmpty()) {
            String joinedUnsupportedColumns = unsupportedColumns.stream().map(columnMetadata -> String.format("%s %s", columnMetadata.getName(), columnMetadata.getType())).collect(Collectors.joining(", "));
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: " + joinedUnsupportedColumns);
        }
    }

    private static void validateTimestampColumns(List<ColumnMetadata> columns, HiveTimestampPrecision precision) {
        for (ColumnMetadata column : columns) {
            HiveMetadata.validateTimestampTypes(column.getType(), precision, column);
        }
    }

    private static void validateTimestampTypes(Type type, HiveTimestampPrecision precision, ColumnMetadata column) {
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() != precision.getPrecision()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Incorrect timestamp precision for %s; the configured precision is %s; column name: %s", new Object[]{type, precision, column.getName()}));
            }
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            HiveMetadata.validateTimestampTypes(arrayType.getElementType(), precision, column);
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            HiveMetadata.validateTimestampTypes(mapType.getKeyType(), precision, column);
            HiveMetadata.validateTimestampTypes(mapType.getValueType(), precision, column);
        } else if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                HiveMetadata.validateTimestampTypes(fieldType, precision, column);
            }
        }
    }

    @Override
    public void rollback() {
        this.metastore.rollback();
    }

    @Override
    public void commit() {
        if (!this.metastore.isFinished()) {
            this.metastore.commit();
        }
    }

    public void beginQuery(ConnectorSession session) {
        this.metastore.beginQuery(session);
    }

    public void cleanupQuery(ConnectorSession session) {
        this.metastore.cleanupQuery(session);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        this.hiveMaterializedViewMetadata.createMaterializedView(session, viewName, definition, properties, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.hiveMaterializedViewMetadata.dropMaterializedView(session, viewName);
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.hiveMaterializedViewMetadata.listMaterializedViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.hiveMaterializedViewMetadata.getMaterializedViews(session, schemaName);
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.hiveMaterializedViewMetadata.getMaterializedView(session, viewName);
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName name) {
        return this.hiveMaterializedViewMetadata.getMaterializedViewFreshness(session, name);
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.hiveMaterializedViewMetadata.renameMaterializedView(session, source, target);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return this.hiveMaterializedViewMetadata.delegateMaterializedViewRefreshToConnector(session, viewName);
    }

    public CompletableFuture<?> refreshMaterializedView(ConnectorSession session, SchemaTableName name) {
        return this.hiveMaterializedViewMetadata.refreshMaterializedView(session, name);
    }

    public void setMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, Map<String, Optional<Object>> properties) {
        this.hiveMaterializedViewMetadata.setMaterializedViewProperties(session, viewName, properties);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> icebergCatalogName = HiveSessionProperties.getIcebergCatalogName(session);
        Optional<String> deltaLakeCatalogName = HiveSessionProperties.getDeltaLakeCatalogName(session);
        Optional<String> hudiCatalogName = HiveSessionProperties.getHudiCatalogName(session);
        if (icebergCatalogName.isEmpty() && deltaLakeCatalogName.isEmpty() && hudiCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema(tableName.getSchemaName())) {
            return Optional.empty();
        }
        TableNameSplitResult tableNameSplit = HiveMetadata.splitTableName(tableName.getTableName());
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableNameSplit.getBaseTableName());
        if (table.isEmpty() || ViewReaderUtil.isSomeKindOfAView(table.get())) {
            return Optional.empty();
        }
        Optional<CatalogSchemaTableName> catalogSchemaTableName = Optional.empty().or(() -> this.redirectTableToIceberg(icebergCatalogName, (Table)table.get())).or(() -> this.redirectTableToDeltaLake(deltaLakeCatalogName, (Table)table.get())).or(() -> this.redirectTableToHudi(hudiCatalogName, (Table)table.get()));
        return catalogSchemaTableName.map(name -> new CatalogSchemaTableName(name.getCatalogName(), new SchemaTableName(name.getSchemaTableName().getSchemaName(), name.getSchemaTableName().getTableName() + tableNameSplit.getSuffix().orElse(""))));
    }

    private Optional<CatalogSchemaTableName> redirectTableToIceberg(Optional<String> targetCatalogName, Table table) {
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isIcebergTable(table)) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, table.getSchemaTableName()));
        }
        return Optional.empty();
    }

    private Optional<CatalogSchemaTableName> redirectTableToDeltaLake(Optional<String> targetCatalogName, Table table) {
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isDeltaLakeTable(table)) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, table.getSchemaTableName()));
        }
        return Optional.empty();
    }

    private Optional<CatalogSchemaTableName> redirectTableToHudi(Optional<String> targetCatalogName, Table table) {
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHudiTable(table)) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, table.getSchemaTableName()));
        }
        return Optional.empty();
    }

    public WriterScalingOptions getNewTableWriterScalingOptions(ConnectorSession session, SchemaTableName tableName, Map<String, Object> tableProperties) {
        return WriterScalingOptions.ENABLED;
    }

    public WriterScalingOptions getInsertWriterScalingOptions(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return WriterScalingOptions.ENABLED;
    }

    private static TableNameSplitResult splitTableName(String tableName) {
        int metadataMarkerIndex = tableName.lastIndexOf(36);
        return metadataMarkerIndex <= 0 ? new TableNameSplitResult(tableName, Optional.empty()) : new TableNameSplitResult(tableName.substring(0, metadataMarkerIndex), Optional.of(tableName.substring(metadataMarkerIndex)));
    }

    @SafeVarargs
    private static <T> Optional<T> firstNonNullable(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean isQueryPartitionFilterRequiredForTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Set<String> requiredSchemas = HiveSessionProperties.getQueryPartitionFilterRequiredSchemas(session);
        return HiveSessionProperties.isQueryPartitionFilterRequired(session) && requiredSchemas.isEmpty() || requiredSchemas.contains(schemaTableName.getSchemaName());
    }

    private static /* synthetic */ boolean lambda$validateColumns$109(Set partitionedBy, ColumnMetadata columnMetadata) {
        return !partitionedBy.contains(columnMetadata.getName());
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$97(Map newVariables, ConnectorExpression expression) {
        return ApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private static /* synthetic */ boolean lambda$listViews$83(Set materializedViews, SchemaTableName view) {
        return !materializedViews.contains(view);
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$31(HiveStorageFormat hiveStorageFormat, Set allowsNullFormat, ImmutableMap.Builder tableProperties, String format) {
        HiveMetadata.checkFormatForProperty(hiveStorageFormat, allowsNullFormat, "null_format");
        tableProperties.put((Object)NULL_FORMAT_KEY, (Object)format);
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$30(HiveStorageFormat hiveStorageFormat, Set csvAndTextFile, ImmutableMap.Builder tableProperties, Integer footerSkipCount) {
        if (footerSkipCount > 0) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, csvAndTextFile, "skip_footer_line_count");
            tableProperties.put((Object)SKIP_FOOTER_COUNT_KEY, (Object)String.valueOf(footerSkipCount));
        }
        if (footerSkipCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "skip_footer_line_count", footerSkipCount));
        }
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$29(HiveStorageFormat hiveStorageFormat, Set csvAndTextFile, ImmutableMap.Builder tableProperties, Integer headerSkipCount) {
        if (headerSkipCount > 0) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, csvAndTextFile, "skip_header_line_count");
            tableProperties.put((Object)SKIP_HEADER_COUNT_KEY, (Object)String.valueOf(headerSkipCount));
        }
        if (headerSkipCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "skip_header_line_count", headerSkipCount));
        }
    }

    private static class TableNameSplitResult {
        private final String baseTableName;
        private final Optional<String> suffix;

        public TableNameSplitResult(String baseTableName, Optional<String> suffix) {
            this.baseTableName = Objects.requireNonNull(baseTableName, "baseTableName is null");
            this.suffix = Objects.requireNonNull(suffix, "suffix is null");
        }

        public String getBaseTableName() {
            return this.baseTableName;
        }

        public Optional<String> getSuffix() {
            return this.suffix;
        }
    }
}

