/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.VarcharType;

public final class BooleanCoercer {
    private static final Slice TRUE = Slices.utf8Slice((String)"TRUE");
    private static final Slice FALSE = Slices.utf8Slice((String)"FALSE");

    private BooleanCoercer() {
    }

    public static class BooleanToVarcharCoercer
    extends TypeCoercer<BooleanType, VarcharType> {
        public BooleanToVarcharCoercer(VarcharType toType) {
            super(BooleanType.BOOLEAN, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Slice converted;
            boolean value = BooleanType.BOOLEAN.getBoolean(block, position);
            Slice slice = converted = value ? TRUE : FALSE;
            if (!((VarcharType)this.toType).isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > ((VarcharType)this.toType).getBoundedLength()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", value, this.toType));
            }
            ((VarcharType)this.toType).writeSlice(blockBuilder, converted);
        }
    }
}

