/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;

public final class DecimalCoercers {
    private DecimalCoercers() {
    }

    public static TypeCoercer<DecimalType, DecimalType> createDecimalToDecimalCoercer(DecimalType fromType, DecimalType toType) {
        if (fromType.isShort()) {
            if (toType.isShort()) {
                return new ShortDecimalToShortDecimalCoercer(fromType, toType);
            }
            return new ShortDecimalToLongDecimalCoercer(fromType, toType);
        }
        if (toType.isShort()) {
            return new LongDecimalToShortDecimalCoercer(fromType, toType);
        }
        return new LongDecimalToLongDecimalCoercer(fromType, toType);
    }

    public static TypeCoercer<DecimalType, DoubleType> createDecimalToDoubleCoercer(DecimalType fromType) {
        if (fromType.isShort()) {
            return new ShortDecimalToDoubleCoercer(fromType);
        }
        return new LongDecimalToDoubleCoercer(fromType);
    }

    public static TypeCoercer<DecimalType, RealType> createDecimalToRealCoercer(DecimalType fromType) {
        if (fromType.isShort()) {
            return new ShortDecimalToRealCoercer(fromType);
        }
        return new LongDecimalToRealCoercer(fromType);
    }

    public static TypeCoercer<DecimalType, VarcharType> createDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
        if (fromType.isShort()) {
            return new ShortDecimalToVarcharCoercer(fromType, toType);
        }
        return new LongDecimalToVarcharCoercer(fromType, toType);
    }

    public static <T extends Type> TypeCoercer<DecimalType, T> createDecimalToInteger(DecimalType fromType, T toType) {
        if (fromType.isShort()) {
            return new ShortDecimalToIntegerCoercer<T>(fromType, toType);
        }
        return new LongDecimalToIntegerCoercer<T>(fromType, toType);
    }

    public static TypeCoercer<DoubleType, DecimalType> createDoubleToDecimalCoercer(DecimalType toType) {
        if (toType.isShort()) {
            return new DoubleToShortDecimalCoercer(toType);
        }
        return new DoubleToLongDecimalCoercer(toType);
    }

    public static TypeCoercer<RealType, DecimalType> createRealToDecimalCoercer(DecimalType toType) {
        if (toType.isShort()) {
            return new RealToShortDecimalCoercer(toType);
        }
        return new RealToLongDecimalCoercer(toType);
    }

    public static <F extends Type> TypeCoercer<F, DecimalType> createIntegerNumberToDecimalCoercer(F fromType, DecimalType toType) {
        if (toType.isShort()) {
            return new IntegerNumberToShortDecimalCoercer<F>(fromType, toType);
        }
        return new IntegerNumberToLongDecimalCoercer<F>(fromType, toType);
    }

    private static class ShortDecimalToShortDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        private final long rescale;

        public ShortDecimalToShortDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
            this.rescale = Decimals.longTenToNth((int)Math.abs(toType.getScale() - fromType.getScale()));
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long returnValue = DecimalConversions.shortToShortCast((long)((DecimalType)this.fromType).getLong(block, position), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale(), (long)this.rescale, (long)(this.rescale / 2L));
            ((DecimalType)this.toType).writeLong(blockBuilder, returnValue);
        }
    }

    private static class ShortDecimalToLongDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public ShortDecimalToLongDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Int128 coercedValue = DecimalConversions.shortToLongCast((long)((DecimalType)this.fromType).getLong(block, position), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)coercedValue);
        }
    }

    private static class LongDecimalToShortDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public LongDecimalToShortDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long returnValue = DecimalConversions.longToShortCast((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeLong(blockBuilder, returnValue);
        }
    }

    private static class LongDecimalToLongDecimalCoercer
    extends TypeCoercer<DecimalType, DecimalType> {
        public LongDecimalToLongDecimalCoercer(DecimalType fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Int128 coercedValue = DecimalConversions.longToLongCast((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getPrecision(), (long)((DecimalType)this.fromType).getScale(), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale());
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)coercedValue);
        }
    }

    private static class ShortDecimalToDoubleCoercer
    extends TypeCoercer<DecimalType, DoubleType> {
        private final long rescale;

        public ShortDecimalToDoubleCoercer(DecimalType fromType) {
            super(fromType, DoubleType.DOUBLE);
            this.rescale = Decimals.longTenToNth((int)fromType.getScale());
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DoubleType)this.toType).writeDouble(blockBuilder, DecimalConversions.shortDecimalToDouble((long)((DecimalType)this.fromType).getLong(block, position), (long)this.rescale));
        }
    }

    private static class LongDecimalToDoubleCoercer
    extends TypeCoercer<DecimalType, DoubleType> {
        public LongDecimalToDoubleCoercer(DecimalType fromType) {
            super(fromType, DoubleType.DOUBLE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DoubleType)this.toType).writeDouble(blockBuilder, DecimalConversions.longDecimalToDouble((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getScale()));
        }
    }

    private static class ShortDecimalToRealCoercer
    extends TypeCoercer<DecimalType, RealType> {
        private final long rescale;

        public ShortDecimalToRealCoercer(DecimalType fromType) {
            super(fromType, RealType.REAL);
            this.rescale = Decimals.longTenToNth((int)fromType.getScale());
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((RealType)this.toType).writeLong(blockBuilder, DecimalConversions.shortDecimalToReal((long)((DecimalType)this.fromType).getLong(block, position), (long)this.rescale));
        }
    }

    private static class LongDecimalToRealCoercer
    extends TypeCoercer<DecimalType, RealType> {
        public LongDecimalToRealCoercer(DecimalType fromType) {
            super(fromType, RealType.REAL);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((RealType)this.toType).writeLong(blockBuilder, DecimalConversions.longDecimalToReal((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (long)((DecimalType)this.fromType).getScale()));
        }
    }

    private static class ShortDecimalToVarcharCoercer
    extends TypeCoercer<DecimalType, VarcharType> {
        private final int lengthLimit;

        protected ShortDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
            super(fromType, toType);
            this.lengthLimit = toType.getLength().orElse(Integer.MAX_VALUE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String stringValue = Decimals.toString((long)((DecimalType)this.fromType).getLong(block, position), (int)((DecimalType)this.fromType).getScale());
            if (stringValue.length() > this.lengthLimit) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Decimal value %s representation exceeds varchar(%s) bounds", stringValue, this.lengthLimit));
            }
            ((VarcharType)this.toType).writeString(blockBuilder, stringValue.substring(0, Math.min(this.lengthLimit, stringValue.length())));
        }
    }

    private static class LongDecimalToVarcharCoercer
    extends TypeCoercer<DecimalType, VarcharType> {
        private final int lengthLimit;

        protected LongDecimalToVarcharCoercer(DecimalType fromType, VarcharType toType) {
            super(fromType, toType);
            this.lengthLimit = toType.getLength().orElse(Integer.MAX_VALUE);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String stringValue = Decimals.toString((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (int)((DecimalType)this.fromType).getScale());
            if (stringValue.length() > this.lengthLimit) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Decimal value %s representation exceeds varchar(%s) bounds", stringValue, this.lengthLimit));
            }
            ((VarcharType)this.toType).writeString(blockBuilder, stringValue.substring(0, Math.min(this.lengthLimit, stringValue.length())));
        }
    }

    private static class ShortDecimalToIntegerCoercer<T extends Type>
    extends AbstractDecimalToIntegerNumberCoercer<T> {
        public ShortDecimalToIntegerCoercer(DecimalType fromType, T toType) {
            super(fromType, toType);
        }

        @Override
        protected String getStringValue(Block block, int position) {
            return Decimals.toString((long)((DecimalType)this.fromType).getLong(block, position), (int)((DecimalType)this.fromType).getScale());
        }
    }

    private static class LongDecimalToIntegerCoercer<T extends Type>
    extends AbstractDecimalToIntegerNumberCoercer<T> {
        public LongDecimalToIntegerCoercer(DecimalType fromType, T toType) {
            super(fromType, toType);
        }

        @Override
        protected String getStringValue(Block block, int position) {
            return Decimals.toString((Int128)((Int128)((DecimalType)this.fromType).getObject(block, position)), (int)((DecimalType)this.fromType).getScale());
        }
    }

    private static class DoubleToShortDecimalCoercer
    extends TypeCoercer<DoubleType, DecimalType> {
        public DoubleToShortDecimalCoercer(DecimalType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeLong(blockBuilder, DecimalConversions.doubleToShortDecimal((double)((DoubleType)this.fromType).getDouble(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class DoubleToLongDecimalCoercer
    extends TypeCoercer<DoubleType, DecimalType> {
        public DoubleToLongDecimalCoercer(DecimalType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)DecimalConversions.doubleToLongDecimal((double)((DoubleType)this.fromType).getDouble(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class RealToShortDecimalCoercer
    extends TypeCoercer<RealType, DecimalType> {
        public RealToShortDecimalCoercer(DecimalType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeLong(blockBuilder, DecimalConversions.realToShortDecimal((float)((RealType)this.fromType).getFloat(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class RealToLongDecimalCoercer
    extends TypeCoercer<RealType, DecimalType> {
        public RealToLongDecimalCoercer(DecimalType toType) {
            super(RealType.REAL, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((DecimalType)this.toType).writeObject(blockBuilder, (Object)DecimalConversions.realToLongDecimal((float)((RealType)this.fromType).getFloat(block, position), (long)((DecimalType)this.toType).getPrecision(), (long)((DecimalType)this.toType).getScale()));
        }
    }

    private static class IntegerNumberToShortDecimalCoercer<F extends Type>
    extends TypeCoercer<F, DecimalType> {
        public IntegerNumberToShortDecimalCoercer(F fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.fromType.getLong(block, position)).setScale(((DecimalType)this.toType).getScale());
            if (Decimals.overflows((BigDecimal)bigDecimal, (long)((DecimalType)this.toType).getPrecision())) {
                blockBuilder.appendNull();
            } else {
                Decimals.writeShortDecimal((BlockBuilder)blockBuilder, (long)bigDecimal.unscaledValue().longValueExact());
            }
        }
    }

    private static class IntegerNumberToLongDecimalCoercer<F extends Type>
    extends TypeCoercer<F, DecimalType> {
        public IntegerNumberToLongDecimalCoercer(F fromType, DecimalType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.fromType.getLong(block, position)).setScale(((DecimalType)this.toType).getScale());
            if (Decimals.overflows((BigDecimal)bigDecimal, (long)((DecimalType)this.toType).getPrecision())) {
                blockBuilder.appendNull();
            } else {
                Decimals.writeBigDecimal((DecimalType)((DecimalType)this.toType), (BlockBuilder)blockBuilder, (BigDecimal)bigDecimal);
            }
        }
    }

    private static abstract class AbstractDecimalToIntegerNumberCoercer<T extends Type>
    extends TypeCoercer<DecimalType, T> {
        protected final long minValue;
        protected final long maxValue;

        public AbstractDecimalToIntegerNumberCoercer(DecimalType fromType, T toType) {
            super(fromType, toType);
            if (toType.equals(TinyintType.TINYINT)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (toType.equals(SmallintType.SMALLINT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (toType.equals(IntegerType.INTEGER)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (toType.equals(BigintType.BIGINT)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from Decimal to %s", toType));
            }
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            long longValue;
            String stringValue = this.getStringValue(block, position);
            int dotPosition = stringValue.indexOf(".");
            try {
                longValue = Long.parseLong(stringValue.substring(0, dotPosition > 0 ? dotPosition : stringValue.length()));
            }
            catch (NumberFormatException e) {
                blockBuilder.appendNull();
                return;
            }
            if (longValue < this.minValue || longValue > this.maxValue) {
                blockBuilder.appendNull();
            } else {
                this.toType.writeLong(blockBuilder, longValue);
            }
        }

        protected abstract String getStringValue(Block var1, int var2);
    }
}

