/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.hive.metastore.tracing.TracingHiveMetastore;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;

public class BridgingHiveMetastoreFactory
implements HiveMetastoreFactory {
    private final ThriftMetastoreFactory thriftMetastoreFactory;
    private final Tracer tracer;

    @Inject
    public BridgingHiveMetastoreFactory(ThriftMetastoreFactory thriftMetastoreFactory, Tracer tracer) {
        this.thriftMetastoreFactory = Objects.requireNonNull(thriftMetastoreFactory, "thriftMetastore is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.thriftMetastoreFactory.isImpersonationEnabled();
    }

    @Override
    public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return new TracingHiveMetastore(this.tracer, new BridgingHiveMetastore(this.thriftMetastoreFactory.createMetastore(identity)));
    }
}

