/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class OrcFileWriterFactory
implements HiveFileWriterFactory {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats readStats;
    private final OrcWriterStats stats = new OrcWriterStats();
    private final OrcWriterOptions orcWriterOptions;

    @Inject
    public OrcFileWriterFactory(TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, NodeVersion nodeVersion, FileFormatDataSourceStats readStats, OrcWriterConfig config) {
        this(typeManager, nodeVersion, readStats, config.toOrcWriterOptions(), fileSystemFactory);
    }

    public OrcFileWriterFactory(TypeManager typeManager, NodeVersion nodeVersion, FileFormatDataSourceStats readStats, OrcWriterOptions orcWriterOptions, TrinoFileSystemFactory fileSystemFactory) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.readStats = Objects.requireNonNull(readStats, "readStats is null");
        this.orcWriterOptions = Objects.requireNonNull(orcWriterOptions, "orcWriterOptions is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Managed
    @Flatten
    public OrcWriterStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<FileWriter> createFileWriter(Location location, List<String> inputColumnNames, StorageFormat storageFormat, HiveCompressionCodec compressionCodec, Map<String, String> schema, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        if (!"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat".equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(session))).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            OrcDataSink orcDataSink = OrcFileWriterFactory.createOrcDataSink(fileSystem, location);
            Optional<Supplier<OrcDataSource>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isOrcOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        TrinoInputFile inputFile = fileSystem.newInputFile(location);
                        return new HdfsOrcDataSource(new OrcDataSourceId(location.toString()), inputFile.length(), new OrcReaderOptions(), inputFile, this.readStats);
                    }
                    catch (IOException e) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            Closeable rollbackAction = () -> fileSystem.deleteFile(location);
            if (transaction.isInsert() && useAcidSchema) {
                Type rowType = AcidSchema.createRowType(fileColumnNames, fileColumnTypes);
                fileColumnNames = AcidSchema.ACID_COLUMN_NAMES;
                fileColumnTypes = AcidSchema.createAcidColumnTrinoTypes(rowType);
            }
            return Optional.of(new OrcFileWriter(orcDataSink, writerKind, transaction, useAcidSchema, bucketNumber, rollbackAction, fileColumnNames, fileColumnTypes, (ColumnMetadata<OrcType>)OrcType.createRootOrcType(fileColumnNames, fileColumnTypes), compressionCodec.getOrcCompressionKind(), HiveUtil.getOrcWriterOptions(schema, this.orcWriterOptions).withStripeMinSize(HiveSessionProperties.getOrcOptimizedWriterMinStripeSize(session)).withStripeMaxSize(HiveSessionProperties.getOrcOptimizedWriterMaxStripeSize(session)).withStripeMaxRowCount(HiveSessionProperties.getOrcOptimizedWriterMaxStripeRows(session)).withDictionaryMaxMemory(HiveSessionProperties.getOrcOptimizedWriterMaxDictionaryMemory(session)).withMaxStringStatisticsLimit(HiveSessionProperties.getOrcStringStatisticsLimit(session)), fileInputColumnIndexes, (Map<String, String>)ImmutableMap.builder().put((Object)"trino_version", (Object)this.nodeVersion.toString()).put((Object)"trino_query_id", (Object)session.getQueryId()).buildOrThrow(), validationInputFactory, HiveSessionProperties.getOrcOptimizedWriterValidateMode(session), this.stats));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
        }
    }

    public static OrcDataSink createOrcDataSink(TrinoFileSystem fileSystem, Location location) throws IOException {
        return OutputStreamOrcDataSink.create((TrinoOutputFile)fileSystem.newOutputFile(location));
    }
}

