/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import java.util.Objects;

record GcsLocation(Location location) {
    GcsLocation {
        Objects.requireNonNull(location, "location");
        Preconditions.checkArgument((boolean)location.scheme().isPresent(), (String)"No scheme for GCS location: %s", (Object)location);
        Preconditions.checkArgument((boolean)((String)location.scheme().get()).equals("gs"), (String)"Wrong scheme for S3 location: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.host().isPresent(), (String)"No bucket for GCS location: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.userInfo().isEmpty(), (String)"GCS location contains user info: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.port().isEmpty(), (String)"GCS location contains port: %s", (Object)location);
        Preconditions.checkArgument((!location.path().contains("#") ? 1 : 0) != 0, (String)"GCS generation numbers are not supported: %s", (Object)location);
        Preconditions.checkArgument((!location.path().contains("?") ? 1 : 0) != 0, (String)"Invalid character '?': %s", (Object)location);
    }

    public String scheme() {
        return (String)this.location.scheme().orElseThrow();
    }

    public String bucket() {
        return (String)this.location.host().orElseThrow();
    }

    public String path() {
        return this.location.path();
    }

    public String getBase() {
        return "%s://%s/".formatted(this.scheme(), this.bucket());
    }

    @Override
    public String toString() {
        return this.location.toString();
    }
}

