/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Boundary;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope3D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Geometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.NumberUtils;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Transformation2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Transformation3D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.VertexDescription;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

public class Envelope
extends Geometry
implements Serializable {
    Envelope2D m_envelope = new Envelope2D();
    double[] m_attributes;

    public Envelope(Point center, double width, double height) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setEmpty();
        if (center.isEmpty()) {
            return;
        }
        this._setFromPoint(center, width, height);
    }

    public Envelope(Envelope2D env2D) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setCoords(env2D);
        this.m_envelope.normalize();
    }

    public Envelope(VertexDescription vd) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this.m_envelope.setEmpty();
    }

    public Envelope(VertexDescription vd, Envelope2D env2D) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this.m_envelope.setCoords(env2D);
        this.m_envelope.normalize();
    }

    public Envelope() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setEmpty();
    }

    public Envelope(Point point) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_envelope.setEmpty();
        if (point.isEmpty()) {
            return;
        }
        this._setFromPoint(point);
    }

    public Envelope(double xmin, double ymin, double xmax, double ymax) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setCoords(xmin, ymin, xmax, ymax);
    }

    public void setCoords(double xmin, double ymin, double xmax, double ymax) {
        this._touch();
        this.m_envelope.setCoords(xmin, ymin, xmax, ymax);
    }

    void setCoords(Point[] points) {
        this._touch();
        this.setEmpty();
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            this.merge(points[i]);
        }
    }

    void setEnvelope2D(Envelope2D e2d) {
        this._touch();
        if (!e2d.isValid()) {
            throw new IllegalArgumentException();
        }
        this.m_envelope.setCoords(e2d);
    }

    @Override
    public void setEmpty() {
        this._touch();
        this.m_envelope.setEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.m_envelope.isEmpty();
    }

    public double getWidth() {
        return this.m_envelope.getWidth();
    }

    public double getHeight() {
        return this.m_envelope.getHeight();
    }

    public double getCenterX() {
        return this.m_envelope.getCenterX();
    }

    public double getCenterY() {
        return this.m_envelope.getCenterY();
    }

    public Point2D getCenterXY() {
        return this.m_envelope.getCenter();
    }

    public void getCenter(Point point_out) {
        point_out.assignVertexDescription(this.m_description);
        if (this.isEmpty()) {
            point_out.setEmpty();
            return;
        }
        int nattrib = this.m_description.getAttributeCount();
        for (int i = 1; i < nattrib; ++i) {
            int semantics = this.m_description.getSemantics(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double v = 0.5 * (this.getAttributeAsDblImpl_(0, semantics, iord) + this.getAttributeAsDblImpl_(1, semantics, iord));
                point_out.setAttribute(semantics, iord, v);
            }
        }
        point_out.setXY(this.m_envelope.getCenter());
    }

    public void merge(Point2D pt) {
        this._touch();
        this.m_envelope.merge(pt);
    }

    public void merge(Envelope other) {
        this._touch();
        if (other.isEmpty()) {
            return;
        }
        VertexDescription otherVD = other.m_description;
        if (otherVD != this.m_description) {
            this.mergeVertexDescription(otherVD);
        }
        this.m_envelope.merge(other.m_envelope);
        int nattrib = otherVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = otherVD.getSemantics(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                Envelope1D intervalOther = other.queryInterval(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.merge(intervalOther);
                this.setInterval(semantics, iord, interval);
            }
        }
    }

    public void merge(Point point) {
        this._touch();
        if (point.isEmptyImpl()) {
            return;
        }
        VertexDescription pointVD = point.m_description;
        if (this.m_description != pointVD) {
            this.mergeVertexDescription(pointVD);
        }
        if (this.isEmpty()) {
            this._setFromPoint(point);
            return;
        }
        this.m_envelope.merge(point.getXY());
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD._getSemanticsImpl(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = point.getAttributeAsDbl(semantics, iord);
                Envelope1D interval = this.queryInterval(semantics, iord);
                interval.merge(v);
                this.setInterval(semantics, iord, interval);
            }
        }
    }

    void _setFromPoint(Point centerPoint, double width, double height) {
        this.m_envelope.setCoords(centerPoint.getXY(), width, height);
        VertexDescription pointVD = centerPoint.m_description;
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD._getSemanticsImpl(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = centerPoint.getAttributeAsDbl(semantics, iord);
                this.setInterval(semantics, iord, v, v);
            }
        }
    }

    void _setFromPoint(Point centerPoint) {
        this.m_envelope.setCoords(centerPoint.m_attributes[0], centerPoint.m_attributes[1]);
        VertexDescription pointVD = centerPoint.m_description;
        int nattrib = pointVD.getAttributeCount();
        for (int iattrib = 1; iattrib < nattrib; ++iattrib) {
            int semantics = pointVD._getSemanticsImpl(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomps; ++iord) {
                double v = centerPoint.getAttributeAsDbl(semantics, iord);
                this.setInterval(semantics, iord, v, v);
            }
        }
    }

    public void merge(Envelope2D other) {
        this._touch();
        this.m_envelope.merge(other);
    }

    public void setInterval(int semantics, int ordinate, double vmin, double vmax) {
        this.setInterval(semantics, ordinate, new Envelope1D(vmin, vmax));
    }

    public void reaspect(double arWidth, double arHeight) {
        this._touch();
        this.m_envelope.reaspect(arWidth, arHeight);
    }

    public void inflate(double dx, double dy) {
        this._touch();
        this.m_envelope.inflate(dx, dy);
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        this._touch();
        transform.transform(this.m_envelope);
    }

    @Override
    void applyTransformation(Transformation3D transform) {
        this._touch();
        if (!this.m_envelope.isEmpty()) {
            Envelope3D env = new Envelope3D();
            this.queryEnvelope3D(env);
            if (env.isEmptyZ()) {
                env.setEmpty();
            } else {
                transform.transform(env);
            }
        }
    }

    @Override
    public void copyTo(Geometry dst) {
        if (dst.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        Envelope envDst = (Envelope)dst;
        dst._touch();
        envDst.m_description = this.m_description;
        envDst.m_envelope.setCoords(this.m_envelope);
        envDst.m_attributes = null;
        if (this.m_attributes != null) {
            envDst._ensureAttributes();
            System.arraycopy(this.m_attributes, 0, envDst.m_attributes, 0, (this.m_description.getTotalComponentCount() - 2) * 2);
        }
    }

    @Override
    public Geometry createInstance() {
        return new Envelope(this.m_description);
    }

    @Override
    public double calculateArea2D() {
        return this.m_envelope.getArea();
    }

    @Override
    public double calculateLength2D() {
        return this.m_envelope.getLength();
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.Envelope;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public long estimateMemorySize() {
        return (long)(32 + this.m_envelope.estimateMemorySize()) + Envelope.estimateMemorySize(this.m_attributes);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        this.copyTo(env);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        env.xmin = this.m_envelope.xmin;
        env.ymin = this.m_envelope.ymin;
        env.xmax = this.m_envelope.xmax;
        env.ymax = this.m_envelope.ymax;
    }

    @Override
    void queryEnvelope3D(Envelope3D env) {
        env.xmin = this.m_envelope.xmin;
        env.ymin = this.m_envelope.ymin;
        env.xmax = this.m_envelope.xmax;
        env.ymax = this.m_envelope.ymax;
        env.setCoords(this.m_envelope.xmin, this.m_envelope.ymin, this._getAttributeAsDbl(0, 1, 0), this.m_envelope.xmax, this.m_envelope.ymax, this._getAttributeAsDbl(1, 1, 0));
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        Envelope1D env = new Envelope1D();
        env.setCoords(this._getAttributeAsDbl(0, semantics, ordinate), this._getAttributeAsDbl(1, semantics, ordinate));
        return env;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInterval(int semantics, int ordinate, Envelope1D env) {
        this._touch();
        if (semantics == 0) {
            if (ordinate == 0) {
                this.m_envelope.xmin = env.vmin;
                this.m_envelope.xmax = env.vmax;
                return;
            } else {
                if (ordinate != 1) throw new IndexOutOfBoundsException();
                this.m_envelope.ymin = env.vmin;
                this.m_envelope.ymax = env.vmax;
            }
            return;
        } else {
            this._setAttributeAsDbl(0, semantics, ordinate, env.vmin);
            this._setAttributeAsDbl(1, semantics, ordinate, env.vmax);
        }
    }

    public void queryCoordinates(Point2D[] dst) {
        if (dst == null || dst.length < 4 || this.m_envelope.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.m_envelope.queryCorners(dst);
    }

    public void queryCornerByVal(int index, Point ptDst) {
        ptDst.assignVertexDescription(this.m_description);
        int nattrib = this.getDescription().getAttributeCount() - 1;
        switch (index) {
            case 0: {
                for (int i = 0; i < nattrib; ++i) {
                    int semantics = this.m_description.getSemantics(i);
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    for (int iord = 0; iord < ncomp; ++iord) {
                        ptDst.setAttribute(semantics, iord, this._getAttributeAsDbl(0, semantics, iord));
                    }
                }
                ptDst.setXY(this.m_envelope.xmin, this.m_envelope.ymin);
                return;
            }
            case 1: {
                for (int i = 0; i < nattrib; ++i) {
                    int semantics = this.m_description.getSemantics(i);
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    for (int iord = 0; iord < ncomp; ++iord) {
                        ptDst.setAttribute(semantics, iord, this._getAttributeAsDbl(1, semantics, iord));
                    }
                }
                ptDst.setXY(this.m_envelope.xmin, this.m_envelope.ymax);
                return;
            }
            case 2: {
                for (int i = 0; i < nattrib; ++i) {
                    int semantics = this.m_description.getSemantics(i);
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    for (int iord = 0; iord < ncomp; ++iord) {
                        ptDst.setAttribute(semantics, iord, this._getAttributeAsDbl(0, semantics, iord));
                    }
                }
                ptDst.setXY(this.m_envelope.xmax, this.m_envelope.ymax);
                return;
            }
            case 3: {
                for (int i = 0; i < nattrib; ++i) {
                    int semantics = this.m_description.getSemantics(i);
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    for (int iord = 0; iord < ncomp; ++iord) {
                        ptDst.setAttribute(semantics, iord, this._getAttributeAsDbl(1, semantics, iord));
                    }
                }
                ptDst.setXY(this.m_envelope.xmax, this.m_envelope.ymin);
                return;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void queryCorner(int index, Point2D ptDst) {
        Point2D p = this.m_envelope.queryCorner(index);
        ptDst.setCoords(p.x, p.y);
    }

    int getEndPointOffset(VertexDescription descr, int end_point) {
        return end_point * (descr.getTotalComponentCount() - 2);
    }

    double getAttributeAsDblImpl_(int end_point, int semantics, int ordinate) {
        if (this.m_envelope.isEmpty()) {
            throw new GeometryException("empty geometry");
        }
        assert (end_point == 0 || end_point == 1);
        if (semantics == 0) {
            if (end_point != 0) {
                return ordinate != 0 ? this.m_envelope.ymax : this.m_envelope.xmax;
            }
            return ordinate != 0 ? this.m_envelope.ymin : this.m_envelope.xmin;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IllegalArgumentException();
        }
        int attribute_index = this.m_description.getAttributeIndex(semantics);
        this._ensureAttributes();
        if (attribute_index >= 0) {
            return this.m_attributes[this.getEndPointOffset(this.m_description, end_point) + this.m_description.getPointAttributeOffset_(attribute_index) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    void setAttributeAsDblImpl_(int end_point, int semantics, int ordinate, double value) {
        assert (end_point == 0 || end_point == 1);
        if (semantics == 0) {
            if (end_point != 0) {
                if (ordinate != 0) {
                    this.m_envelope.ymax = value;
                } else {
                    this.m_envelope.xmax = value;
                }
            } else if (ordinate != 0) {
                this.m_envelope.ymin = value;
            } else {
                this.m_envelope.xmin = value;
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IllegalArgumentException();
        }
        this.addAttribute(semantics);
        this._ensureAttributes();
        int attribute_index = this.m_description.getAttributeIndex(semantics);
        this.m_attributes[this.getEndPointOffset((VertexDescription)this.m_description, (int)end_point) + this.m_description.getPointAttributeOffset_((int)attribute_index) - 2 + ordinate] = value;
    }

    void _ensureAttributes() {
        this._touch();
        if (this.m_attributes == null && this.m_description.getTotalComponentCount() > 2) {
            this.m_attributes = new double[(this.m_description.getTotalComponentCount() - 2) * 2];
            int offset0 = Envelope._getEndPointOffset(this.m_description, 0);
            int offset1 = Envelope._getEndPointOffset(this.m_description, 1);
            int j = 0;
            int n = this.m_description.getAttributeCount();
            for (int i = 1; i < n; ++i) {
                int semantics = this.m_description.getSemantics(i);
                int nords = VertexDescription.getComponentCount(semantics);
                double d = VertexDescription.getDefaultValue(semantics);
                for (int ord = 0; ord < nords; ++ord) {
                    this.m_attributes[offset0 + j] = d;
                    this.m_attributes[offset1 + j] = d;
                    ++j;
                }
            }
        }
    }

    @Override
    protected void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        if (this.m_attributes == null) {
            this.m_description = newDescription;
            return;
        }
        if (newDescription.getTotalComponentCount() > 2) {
            int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
            double[] newAttributes = new double[(newDescription.getTotalComponentCount() - 2) * 2];
            int old_offset0 = Envelope._getEndPointOffset(this.m_description, 0);
            int old_offset1 = Envelope._getEndPointOffset(this.m_description, 1);
            int new_offset0 = Envelope._getEndPointOffset(newDescription, 0);
            int new_offset1 = Envelope._getEndPointOffset(newDescription, 1);
            int j = 0;
            int n = newDescription.getAttributeCount();
            for (int i = 1; i < n; ++i) {
                int ord;
                int semantics = newDescription.getSemantics(i);
                int nords = VertexDescription.getComponentCount(semantics);
                if (mapping[i] == -1) {
                    double d = VertexDescription.getDefaultValue(semantics);
                    for (ord = 0; ord < nords; ++ord) {
                        newAttributes[new_offset0 + j] = d;
                        newAttributes[new_offset1 + j] = d;
                        ++j;
                    }
                    continue;
                }
                int m3 = mapping[i];
                int offset = this.m_description._getPointAttributeOffset(m3) - 2;
                for (ord = 0; ord < nords; ++ord) {
                    newAttributes[new_offset0 + j] = this.m_attributes[old_offset0 + offset];
                    newAttributes[new_offset1 + j] = this.m_attributes[old_offset1 + offset];
                    ++j;
                    ++offset;
                }
            }
            this.m_attributes = newAttributes;
        } else {
            this.m_attributes = null;
        }
        this.m_description = newDescription;
    }

    double _getAttributeAsDbl(int endPoint, int semantics, int ordinate) {
        if (this.m_envelope.isEmpty()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
        if (semantics == 0) {
            if (endPoint != 0) {
                return ordinate != 0 ? this.m_envelope.ymax : this.m_envelope.xmax;
            }
            return ordinate != 0 ? this.m_envelope.ymin : this.m_envelope.xmin;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            this._ensureAttributes();
            return this.m_attributes[Envelope._getEndPointOffset(this.m_description, endPoint) + this.m_description._getPointAttributeOffset(attributeIndex) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    void _setAttributeAsDbl(int endPoint, int semantics, int ordinate, double value) {
        this._touch();
        if (semantics == 0) {
            if (endPoint != 0) {
                if (ordinate != 0) {
                    this.m_envelope.ymax = value;
                } else {
                    this.m_envelope.xmax = value;
                }
            } else if (ordinate != 0) {
                this.m_envelope.ymin = value;
            } else {
                this.m_envelope.xmin = value;
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.hasAttribute(semantics)) {
            if (VertexDescription.isDefaultValue(semantics, value)) {
                return;
            }
            this.addAttribute(semantics);
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        this._ensureAttributes();
        this.m_attributes[Envelope._getEndPointOffset((VertexDescription)this.m_description, (int)endPoint) + this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value;
    }

    int _getAttributeAsInt(int endPoint, int semantics, int ordinate) {
        return (int)this._getAttributeAsDbl(endPoint, semantics, ordinate);
    }

    static int _getEndPointOffset(VertexDescription vd, int endPoint) {
        return endPoint * (vd.getTotalComponentCount() - 2);
    }

    public boolean isIntersecting(Envelope2D other) {
        return this.m_envelope.isIntersecting(other);
    }

    public boolean intersect(Envelope other) {
        this._touch();
        Envelope2D e2d = new Envelope2D();
        other.queryEnvelope2D(e2d);
        return this.m_envelope.intersect(e2d);
    }

    public boolean isIntersecting(Envelope other) {
        return this.m_envelope.isIntersecting(other.m_envelope);
    }

    public void centerAt(Point c, double w, double h2) {
        this._touch();
        if (c.isEmpty()) {
            this.setEmpty();
            return;
        }
        this._setFromPoint(c, w, h2);
    }

    public void offset(double dx, double dy) {
        this._touch();
        this.m_envelope.offset(dx, dy);
    }

    public void normalize() {
        this._touch();
        this.m_envelope.normalize();
    }

    public Point2D getCenter2D() {
        return this.m_envelope.getCenter();
    }

    public Point getCenter() {
        Point pointOut = new Point(this.m_description);
        if (this.isEmpty()) {
            return pointOut;
        }
        int nattrib = this.m_description.getAttributeCount();
        for (int i = 1; i < nattrib; ++i) {
            int semantics = this.m_description._getSemanticsImpl(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int iord = 0; iord < ncomp; ++iord) {
                double v = 0.5 * (this._getAttributeAsDbl(0, semantics, iord) + this._getAttributeAsDbl(1, semantics, iord));
                pointOut.setAttribute(semantics, iord, v);
            }
        }
        pointOut.setXY(this.m_envelope.getCenterX(), this.m_envelope.getCenterY());
        return pointOut;
    }

    public void centerAt(Point c) {
        this._touch();
        if (c.isEmpty()) {
            this.setEmpty();
            return;
        }
        this.m_envelope.centerAt(c.getX(), c.getY());
    }

    public Point getLowerLeft() {
        return new Point(this.m_envelope.getLowerLeft());
    }

    public Point getUpperRight() {
        return new Point(this.m_envelope.getUpperRight());
    }

    public Point getLowerRight() {
        return new Point(this.m_envelope.getLowerRight());
    }

    public Point getUpperLeft() {
        return new Point(this.m_envelope.getUpperLeft());
    }

    public boolean contains(Point p) {
        if (p.isEmpty()) {
            return false;
        }
        return this.m_envelope.contains(p.getX(), p.getY());
    }

    public boolean contains(Envelope env) {
        return this.m_envelope.contains(env.m_envelope);
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)_other;
        if (this.m_description != other.m_description) {
            return false;
        }
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (!this.m_envelope.equals(other.m_envelope)) {
            return false;
        }
        int n = (this.m_description.getTotalComponentCount() - 2) * 2;
        for (int i = 0; i < n; ++i) {
            if (this.m_attributes[i] == other.m_attributes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        hashCode = NumberUtils.hash(hashCode, this.m_envelope.hashCode());
        if (!this.isEmpty() && this.m_attributes != null) {
            int n = (this.m_description.getTotalComponentCount() - 2) * 2;
            for (int i = 0; i < n; ++i) {
                hashCode = NumberUtils.hash(hashCode, this.m_attributes[i]);
            }
        }
        return hashCode;
    }

    public final double getXMin() {
        return this.m_envelope.xmin;
    }

    public final double getYMin() {
        return this.m_envelope.ymin;
    }

    public final double getXMax() {
        return this.m_envelope.xmax;
    }

    public final double getYMax() {
        return this.m_envelope.ymax;
    }

    public void setXMin(double x) {
        this._touch();
        this.m_envelope.xmin = x;
    }

    public void setXMax(double x) {
        this._touch();
        this.m_envelope.xmax = x;
    }

    public void setYMin(double y) {
        this._touch();
        this.m_envelope.ymin = y;
    }

    public void setYMax(double y) {
        this._touch();
        this.m_envelope.ymax = y;
    }

    @Override
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            Envelope1D interval = this.queryInterval(semantics, i);
            if (!interval.isEmpty()) continue;
            interval.vmin = value;
            interval.vmax = value;
            this.setInterval(semantics, i, interval);
        }
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "Envelope: []";
        }
        String s2 = "Envelope: [" + this.m_envelope.xmin + ", " + this.m_envelope.ymin + ", " + this.m_envelope.xmax + ", " + this.m_envelope.ymax + "]";
        return s2;
    }
}

