/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesArrayAccessor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesBufferAccessor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesUpdateImpl;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.UpdateDoublesSketch;

final class DoublesMergeImpl {
    private DoublesMergeImpl() {
    }

    static void mergeInto(DoublesSketch src, UpdateDoublesSketch tgt) {
        long srcBitPattern;
        int tgtCombBufItemCap;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long srcN = src.getN();
        long tgtN = tgt.getN();
        if (srcK != tgtK) {
            DoublesMergeImpl.downSamplingMergeInto(src, tgt);
            return;
        }
        DoublesSketchAccessor srcSketchBuf = DoublesSketchAccessor.wrap(src);
        long nFinal = tgtN + srcN;
        for (int i = 0; i < srcSketchBuf.numItems(); ++i) {
            tgt.update(srcSketchBuf.get(i));
        }
        int spaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(tgtK, nFinal);
        if (spaceNeeded > (tgtCombBufItemCap = tgt.getCombinedBufferItemCapacity())) {
            tgt.growCombinedBuffer(tgtCombBufItemCap, spaceNeeded);
        }
        DoublesArrayAccessor scratch2KAcc = DoublesArrayAccessor.initialize(2 * tgtK);
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        DoublesSketchAccessor tgtSketchBuf = DoublesSketchAccessor.wrap(tgt, true);
        int srcLvl = 0;
        for (srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                long newTgtBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(srcLvl, srcSketchBuf.setLevel(srcLvl), scratch2KAcc, false, tgtK, tgtSketchBuf, tgt.getBitPattern());
                tgt.putBitPattern(newTgtBitPattern);
            }
            ++srcLvl;
        }
        if (tgt.isDirect() && nFinal > 0L) {
            Memory mem = tgt.getMemory();
            mem.clearBits(3L, (byte)4);
        }
        tgt.putN(nFinal);
        assert (tgt.getN() / (long)(2 * tgtK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        tgt.putMaxValue(Math.max(srcMax, tgtMax));
        tgt.putMinValue(Math.min(srcMin, tgtMin));
    }

    static void downSamplingMergeInto(DoublesSketch src, UpdateDoublesSketch tgt) {
        int curCombBufCap;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long tgtN = tgt.getN();
        if (srcK % tgtK != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = srcK / tgtK;
        Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        DoublesSketchAccessor srcSketchBuf = DoublesSketchAccessor.wrap(src);
        long nFinal = tgtN + src.getN();
        for (int i = 0; i < srcSketchBuf.numItems(); ++i) {
            tgt.update(srcSketchBuf.get(i));
        }
        int spaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(tgtK, nFinal);
        if (spaceNeeded > (curCombBufCap = tgt.getCombinedBufferItemCapacity())) {
            tgt.growCombinedBuffer(curCombBufCap, spaceNeeded);
        }
        DoublesArrayAccessor scratch2KAcc = DoublesArrayAccessor.initialize(2 * tgtK);
        DoublesArrayAccessor downScratchKAcc = DoublesArrayAccessor.initialize(tgtK);
        DoublesSketchAccessor tgtSketchBuf = DoublesSketchAccessor.wrap(tgt, true);
        long newTgtBitPattern = tgt.getBitPattern();
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                DoublesMergeImpl.justZipWithStride(srcSketchBuf.setLevel(srcLvl), downScratchKAcc, tgtK, downFactor);
                newTgtBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(srcLvl + lgDownFactor, downScratchKAcc, scratch2KAcc, false, tgtK, tgtSketchBuf, newTgtBitPattern);
                tgt.putBitPattern(newTgtBitPattern);
            }
            ++srcLvl;
        }
        if (tgt.isDirect() && nFinal > 0L) {
            Memory mem = tgt.getMemory();
            mem.clearBits(3L, (byte)4);
        }
        tgt.putN(nFinal);
        assert (tgt.getN() / (long)(2 * tgtK) == newTgtBitPattern);
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.putMaxValue(srcMax);
        }
        if (srcMin < tgtMin) {
            tgt.putMinValue(srcMin);
        }
    }

    private static void justZipWithStride(DoublesBufferAccessor bufA, DoublesBufferAccessor bufC, int kC, int stride) {
        int randomOffset;
        int a = randomOffset = DoublesSketch.rand.nextInt(stride);
        for (int c = 0; c < kC; ++c) {
            bufC.set(c, bufA.get(a));
            a += stride;
        }
    }
}

