/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linkedin.coral.common.LocalMetastoreHiveTable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;

public class LocalMetastoreHiveDbSchema
implements Schema {
    private final Map<String, Map<String, List<String>>> localMetastore;
    private final String dbName;

    public LocalMetastoreHiveDbSchema(Map<String, Map<String, List<String>>> localMetastore, String dbName) {
        Preconditions.checkNotNull(localMetastore);
        Preconditions.checkNotNull((Object)dbName);
        this.localMetastore = localMetastore;
        this.dbName = dbName;
    }

    @Override
    public Table getTable(String tableName) {
        if (this.localMetastore.containsKey(this.dbName) && this.localMetastore.get(this.dbName).containsKey(tableName)) {
            return new LocalMetastoreHiveTable(tableName, this.localMetastore.get(this.dbName).get(tableName));
        }
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.localMetastore.get(this.dbName).keySet());
    }

    @Override
    public RelProtoDataType getType(String s2) {
        return null;
    }

    @Override
    public Set<String> getTypeNames() {
        return null;
    }

    @Override
    public Collection<Function> getFunctions(String name) {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getFunctionNames() {
        return ImmutableSet.of();
    }

    @Override
    public Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

