/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.plugin.hive;

import com.google.errorprone.annotations.concurrent.GuardedBy;

import java.util.Iterator;

import static java.util.Objects.requireNonNull;

public class ConcurrentLazyQueue<E>
{
    @GuardedBy("this")
    private final Iterator<E> iterator;

    public ConcurrentLazyQueue(Iterator<E> iterator)
    {
        this.iterator = requireNonNull(iterator, "iterator is null");
    }

    public synchronized boolean isEmpty()
    {
        return !iterator.hasNext();
    }

    public synchronized E poll()
    {
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }
}
