/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class HivePageSource
implements ConnectorPageSource {
    public static final int ORIGINAL_TRANSACTION_CHANNEL = 0;
    public static final int BUCKET_CHANNEL = 1;
    public static final int ROW_ID_CHANNEL = 2;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Optional<BucketValidator> bucketValidator;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final List<Optional<TypeCoercer<? extends Type, ? extends Type>>> coercers;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<HivePageSourceProvider.BucketAdaptation> bucketAdaptation, Optional<BucketValidator> bucketValidator, Optional<ReaderProjectionsAdapter> projectionsAdapter, TypeManager typeManager, CoercionUtils.CoercionContext coercionContext, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(coercionContext, "coercionContext is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        this.bucketValidator = Objects.requireNonNull(bucketValidator, "bucketValidator is null");
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        ImmutableList.Builder coercers = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            this.types[columnIndex] = type = column.getType();
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.EMPTY && columnMapping.getBaseTypeCoercionFrom().isPresent()) {
                List dereferenceIndices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
                HiveType fromType = columnMapping.getBaseTypeCoercionFrom().get().getHiveTypeForDereferences(dereferenceIndices).get();
                HiveType toType = columnMapping.getHiveColumnHandle().getHiveType();
                coercers.add(CoercionUtils.createCoercer(typeManager, fromType, toType, coercionContext));
            } else {
                coercers.add(Optional.empty());
            }
            if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.EMPTY || HiveColumnHandle.isRowIdColumnHandle(column)) {
                this.prefilledValues[columnIndex] = null;
                continue;
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            this.prefilledValues[columnIndex] = columnMapping.getPrefilledValue().getValue();
        }
        this.coercers = coercers.build();
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public CompletableFuture<?> isBlocked() {
        return this.delegate.isBlocked();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            if (this.bucketAdapter.isPresent() && (dataPage = this.bucketAdapter.get().filterPageToEligibleRowsOrDiscard(dataPage)) == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Block> blocks = new ArrayList<Block>();
            block8: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: 
                    case EMPTY: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block8;
                    }
                    case REGULAR: 
                    case SYNTHESIZED: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = this.coercers.get(fieldId);
                        if (coercer.isPresent()) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, coercer.get()));
                        }
                        blocks.add(block);
                        continue block8;
                    }
                    case INTERIM: {
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            Page page = new Page(batchSize, blocks.toArray(new Block[0]));
            if (this.bucketAdapter.isEmpty()) {
                this.bucketValidator.ifPresent(validator -> validator.validate(page));
            }
            return page;
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    public static class BucketAdapter {
        private final int[] bucketColumns;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketToKeep;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketingVersion = bucketAdaptation.getBucketingVersion();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        @Nullable
        public Page filterPageToEligibleRowsOrDiscard(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = page.getColumns(this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            int retainedRowCount = ids.size();
            if (retainedRowCount == 0) {
                return null;
            }
            if (retainedRowCount == page.getPositionCount()) {
                return page;
            }
            return page.getPositions(ids.elements(), 0, retainedRowCount);
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public Block load() {
            Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"Already loaded");
            Block loaded = this.coercer.apply(this.block.getLoadedBlock());
            this.block = null;
            return loaded;
        }
    }

    public static class BucketValidator {
        public static final int VALIDATION_STRIDE = 97;
        private final Location path;
        private final int[] bucketColumnIndices;
        private final List<TypeInfo> bucketColumnTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketCount;
        private final int expectedBucket;

        public BucketValidator(Location path, int[] bucketColumnIndices, List<TypeInfo> bucketColumnTypes, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, int expectedBucket) {
            this.path = Objects.requireNonNull(path, "path is null");
            this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
            this.bucketColumnTypes = Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.bucketCount = bucketCount;
            this.expectedBucket = expectedBucket;
            Preconditions.checkArgument((bucketColumnIndices.length == bucketColumnTypes.size() ? 1 : 0) != 0, (Object)"indices and types counts mismatch");
        }

        public void validate(Page page) {
            Page bucketColumnsPage = page.getColumns(this.bucketColumnIndices);
            for (int position = 0; position < page.getPositionCount(); position += 97) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.bucketColumnTypes, bucketColumnsPage, position);
                if (bucket == this.expectedBucket) continue;
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table is corrupt. File '%s' is for bucket %s, but contains a row for bucket %s.", this.path, this.expectedBucket, bucket));
            }
        }
    }
}

