/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.StructTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoFactory;
import io.trino.plugin.hive.type.TypeInfoUtils;
import io.trino.plugin.hive.type.UnionTypeInfo;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class HiveType {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(HiveType.class);
    public static final HiveType HIVE_BOOLEAN = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("boolean"));
    public static final HiveType HIVE_BYTE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("tinyint"));
    public static final HiveType HIVE_SHORT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("smallint"));
    public static final HiveType HIVE_INT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("int"));
    public static final HiveType HIVE_LONG = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("bigint"));
    public static final HiveType HIVE_FLOAT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("float"));
    public static final HiveType HIVE_DOUBLE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("double"));
    public static final HiveType HIVE_STRING = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("string"));
    public static final HiveType HIVE_TIMESTAMP = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("timestamp"));
    public static final HiveType HIVE_TIMESTAMPLOCALTZ = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("timestamp with local time zone"));
    public static final HiveType HIVE_DATE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("date"));
    public static final HiveType HIVE_BINARY = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("binary"));
    private final HiveTypeName hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = new HiveTypeName(typeInfo.getTypeName());
        this.typeInfo = typeInfo;
    }

    public HiveTypeName getHiveTypeName() {
        return this.hiveTypeName;
    }

    public Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Deprecated
    public TypeSignature getTypeSignature() {
        return this.getTypeSignature(HiveTimestampPrecision.DEFAULT_PRECISION);
    }

    public TypeSignature getTypeSignature(HiveTimestampPrecision timestampPrecision) {
        return HiveTypeTranslator.toTypeSignature(this.typeInfo, timestampPrecision);
    }

    public Type getType(TypeManager typeManager, HiveTimestampPrecision timestampPrecision) {
        return typeManager.getType(this.getTypeSignature(timestampPrecision));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.hiveTypeName.toString();
    }

    public boolean isSupportedType(StorageFormat storageFormat) {
        return HiveType.isSupportedType(this.getTypeInfo(), storageFormat);
    }

    private static boolean isSupportedType(TypeInfo typeInfo, StorageFormat storageFormat) {
        return switch (typeInfo.getCategory()) {
            default -> throw new MatchException(null, null);
            case Category.PRIMITIVE -> HiveType.isSupported((PrimitiveTypeInfo)typeInfo);
            case Category.MAP -> {
                if (HiveType.isSupportedType(((MapTypeInfo)typeInfo).getMapKeyTypeInfo(), storageFormat) && HiveType.isSupportedType(((MapTypeInfo)typeInfo).getMapValueTypeInfo(), storageFormat)) {
                    yield true;
                }
                yield false;
            }
            case Category.LIST -> HiveType.isSupportedType(((ListTypeInfo)typeInfo).getListElementTypeInfo(), storageFormat);
            case Category.STRUCT -> ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
            case Category.UNION -> storageFormat.getSerde().equalsIgnoreCase(HiveStorageFormat.AVRO.getSerde()) || storageFormat.getSerde().equalsIgnoreCase(HiveStorageFormat.ORC.getSerde()) || ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
        };
    }

    private static boolean isSupported(PrimitiveTypeInfo typeInfo) {
        return switch (typeInfo.getPrimitiveCategory()) {
            default -> throw new MatchException(null, null);
            case PrimitiveCategory.BOOLEAN, PrimitiveCategory.BYTE, PrimitiveCategory.SHORT, PrimitiveCategory.INT, PrimitiveCategory.LONG, PrimitiveCategory.FLOAT, PrimitiveCategory.DOUBLE, PrimitiveCategory.STRING, PrimitiveCategory.VARCHAR, PrimitiveCategory.CHAR, PrimitiveCategory.DATE, PrimitiveCategory.TIMESTAMP, PrimitiveCategory.TIMESTAMPLOCALTZ, PrimitiveCategory.BINARY, PrimitiveCategory.DECIMAL -> true;
            case PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveCategory.VOID, PrimitiveCategory.UNKNOWN -> false;
        };
    }

    @JsonCreator
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.toHiveType(TypeInfoUtils.getTypeInfoFromTypeString(hiveTypeName));
    }

    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return (List)TypeInfoUtils.getTypeInfosFromTypeString(hiveTypes).stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList());
    }

    public static HiveType toHiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        return new HiveType(typeInfo);
    }

    public static HiveType toHiveType(Type type) {
        return new HiveType(HiveTypeTranslator.toTypeInfo(type));
    }

    public Optional<HiveType> getHiveTypeForDereferences(List<Integer> dereferences) {
        TypeInfo typeInfo = this.getTypeInfo();
        for (int fieldIndex : dereferences) {
            if (typeInfo instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                try {
                    typeInfo = structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
                    continue;
                }
                catch (RuntimeException e) {
                    return Optional.empty();
                }
            }
            if (typeInfo instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                try {
                    if (fieldIndex == 0) {
                        return Optional.of(HiveType.toHiveType(UnionToRowCoercionUtils.UNION_FIELD_TAG_TYPE));
                    }
                    typeInfo = unionTypeInfo.getAllUnionObjectTypeInfos().get(fieldIndex - 1);
                    continue;
                }
                catch (RuntimeException e) {
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException(Strings.lenientFormat((String)"typeInfo: %s should be struct or union type", (Object[])new Object[]{typeInfo}));
        }
        return Optional.of(HiveType.toHiveType(typeInfo));
    }

    public List<String> getHiveDereferenceNames(List<Integer> dereferences) {
        ImmutableList.Builder dereferenceNames = ImmutableList.builder();
        TypeInfo typeInfo = this.getTypeInfo();
        for (int i = 0; i < dereferences.size(); ++i) {
            int fieldIndex = dereferences.get(i);
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex cannot be negative");
            if (typeInfo instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                Preconditions.checkArgument((fieldIndex < structTypeInfo.getAllStructFieldNames().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the struct");
                String fieldName = structTypeInfo.getAllStructFieldNames().get(fieldIndex);
                dereferenceNames.add((Object)fieldName);
                typeInfo = structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
                continue;
            }
            if (typeInfo instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                Preconditions.checkArgument((fieldIndex - 1 < unionTypeInfo.getAllUnionObjectTypeInfos().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the union plus tag field");
                if (fieldIndex == 0) {
                    Preconditions.checkArgument((i == dereferences.size() - 1 ? 1 : 0) != 0, (Object)"Union's tag field should not have more subfields");
                    dereferenceNames.add((Object)"tag");
                    break;
                }
                typeInfo = unionTypeInfo.getAllUnionObjectTypeInfos().get(fieldIndex - 1);
                dereferenceNames.add((Object)("field" + (fieldIndex - 1)));
                continue;
            }
            throw new IllegalArgumentException(Strings.lenientFormat((String)"typeInfo: %s should be struct or union type", (Object[])new Object[]{typeInfo}));
        }
        return dereferenceNames.build();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.hiveTypeName.getEstimatedSizeInBytes() + this.typeInfo.getRetainedSizeInBytes();
    }
}

