/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.hive.formats.avro.AvroCompressionKind;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.avro.AvroHiveFileUtils;
import io.trino.plugin.hive.avro.AvroHiveFileWriter;
import io.trino.plugin.hive.avro.HiveAvroTypeManager;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.avro.Schema;

public class AvroFileWriterFactory
implements HiveFileWriterFactory {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;

    @Inject
    public AvroFileWriterFactory(TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, NodeVersion nodeVersion) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion");
    }

    @Override
    public Optional<FileWriter> createFileWriter(Location location, List<String> inputColumnNames, StorageFormat storageFormat, HiveCompressionCodec compressionCodec, Map<String, String> schema, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        if (!"org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat".equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        AvroCompressionKind compressionKind = compressionCodec.getAvroCompressionKind().orElse(AvroCompressionKind.NULL);
        if (!compressionKind.isSupportedLocally()) {
            throw new VerifyException("Avro Compression codec %s is not supported in the environment".formatted(compressionKind));
        }
        HiveTimestampPrecision hiveTimestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List fileColumnTypes = (List)HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, hiveTimestampPrecision)).collect(ImmutableList.toImmutableList());
        List inputColumnTypes = (List)inputColumnNames.stream().map(inputColumnName -> {
            int index = fileColumnNames.indexOf(inputColumnName);
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"Input column name [%s] not preset in file columns names %s", (Object)inputColumnName, (Object)fileColumnNames);
            return (Type)fileColumnTypes.get(index);
        }).collect(ImmutableList.toImmutableList());
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            Schema fileSchema = AvroHiveFileUtils.determineSchemaOrThrowException(fileSystem, schema);
            TrinoOutputFile outputFile = fileSystem.newOutputFile(location);
            AggregatedMemoryContext outputStreamMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            Closeable rollbackAction = () -> fileSystem.deleteFile(location);
            return Optional.of(new AvroHiveFileWriter(outputFile.create(outputStreamMemoryContext), outputStreamMemoryContext, fileSchema, (AvroTypeManager)new HiveAvroTypeManager(hiveTimestampPrecision), rollbackAction, inputColumnNames, inputColumnTypes, compressionKind, (Map<String, String>)ImmutableMap.builder().put((Object)"trino_version", (Object)this.nodeVersion.toString()).put((Object)"trino_query_id", (Object)session.getQueryId()).buildOrThrow()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating Avro Container file", (Throwable)e);
        }
    }
}

