/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.VarcharType;

public class VarcharToDoubleCoercer
extends TypeCoercer<VarcharType, DoubleType> {
    private final boolean treatNaNAsNull;

    public VarcharToDoubleCoercer(VarcharType fromType, boolean treatNaNAsNull) {
        super(fromType, DoubleType.DOUBLE);
        this.treatNaNAsNull = treatNaNAsNull;
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        double doubleValue;
        try {
            doubleValue = Double.parseDouble(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8());
        }
        catch (NumberFormatException e) {
            blockBuilder.appendNull();
            return;
        }
        if (Double.isNaN(doubleValue) && this.treatNaNAsNull) {
            blockBuilder.appendNull();
            return;
        }
        DoubleType.DOUBLE.writeDouble(blockBuilder, doubleValue);
    }
}

