/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.ForHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.StaticTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveWriteStatisticsExecutor;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationModule;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, ThriftMetastoreClientFactory.class).setDefault().to(DefaultThriftMetastoreClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(TokenAwareMetastoreClientFactory.class).to(StaticTokenAwareMetastoreClientFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftMetastoreConfig.class);
        binder.bind(ThriftMetastoreFactory.class).to(ThriftHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftMetastoreFactory.class).as(generator -> generator.generatedNameOf(ThriftHiveMetastore.class));
        binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).to(BridgingHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHiveMetastore.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
        binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)true);
        this.install((Module)new ThriftMetastoreAuthenticationModule());
    }

    @Provides
    @Singleton
    @ThriftHiveWriteStatisticsExecutor
    public ExecutorService createWriteStatisticsExecutor(ThriftMetastoreConfig hiveConfig) {
        return Executors.newFixedThreadPool(hiveConfig.getWriteStatisticsThreads(), Threads.threadsNamed((String)"hive-thrift-statistics-write-%s"));
    }

    @PreDestroy
    public void shutdownsWriteStatisticExecutor(@ThriftHiveWriteStatisticsExecutor ExecutorService executor) {
        executor.shutdownNow();
    }
}

