/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.security.AllowAllSecurityModule;
import io.trino.plugin.hive.security.LegacySecurityModule;
import io.trino.plugin.hive.security.SecurityConfig;
import io.trino.plugin.hive.security.SqlStandardSecurityModule;
import io.trino.plugin.hive.security.SystemSecurityModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    public static final String LEGACY = "legacy";
    public static final String FILE = "file";
    public static final String READ_ONLY = "read-only";
    public static final String SQL_STANDARD = "sql-standard";
    public static final String ALLOW_ALL = "allow-all";
    public static final String SYSTEM = "system";

    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.bindSecurityModule(LEGACY, ConfigurationAwareModule.combine((Module[])new Module[]{new LegacySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule(FILE, ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule(READ_ONLY, ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule(SQL_STANDARD, new SqlStandardSecurityModule());
        this.bindSecurityModule(ALLOW_ALL, new AllowAllSecurityModule());
        this.bindSecurityModule(SYSTEM, new SystemSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AccessControlMetadataFactory.class).toInstance(metastore -> new AccessControlMetadata(this){});
        }
    }
}

