/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.type.BaseCharTypeInfo;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.DecimalTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoUtils;
import java.util.Objects;

public sealed class PrimitiveTypeInfo
extends TypeInfo
permits BaseCharTypeInfo, DecimalTypeInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(PrimitiveTypeInfo.class);
    protected final String typeName;
    private final PrimitiveCategory primitiveCategory;

    PrimitiveTypeInfo(String typeName) {
        this.typeName = Objects.requireNonNull(typeName, "typeName is null");
        this.primitiveCategory = TypeInfoUtils.getTypeEntryFromTypeName(typeName).primitiveCategory();
    }

    @Override
    public Category getCategory() {
        return Category.PRIMITIVE;
    }

    public PrimitiveCategory getPrimitiveCategory() {
        return this.primitiveCategory;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PrimitiveTypeInfo)) return false;
        PrimitiveTypeInfo o = (PrimitiveTypeInfo)other;
        if (!this.typeName.equals(o.typeName)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public long getRetainedSizeInBytes() {
        Verify.verify((this.getClass() == PrimitiveTypeInfo.class ? 1 : 0) != 0, (String)"Method must be overridden in %s", this.getClass());
        return (long)INSTANCE_SIZE + this.getDeclaredFieldsRetainedSizeInBytes();
    }

    protected long getDeclaredFieldsRetainedSizeInBytes() {
        return SizeOf.estimatedSizeOf((String)this.typeName);
    }
}

