/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.fs.BlockLocation;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.spi.HostAddress;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;

public class InternalHiveSplitFactory {
    private final String partitionName;
    private final HiveStorageFormat storageFormat;
    private final Map<String, String> strippedSchema;
    private final List<HivePartitionKey> partitionKeys;
    private final Optional<Domain> pathDomain;
    private final Map<Integer, HiveTypeName> hiveColumnCoercions;
    private final BooleanSupplier partitionMatchSupplier;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final Optional<HiveSplit.BucketValidation> bucketValidation;
    private final long minimumTargetSplitSizeInBytes;
    private final Optional<Long> maxSplitFileSize;
    private final boolean forceLocalScheduling;

    public InternalHiveSplitFactory(String partitionName, HiveStorageFormat storageFormat, Map<String, String> schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, BooleanSupplier partitionMatchSupplier, Map<Integer, HiveTypeName> hiveColumnCoercions, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<HiveSplit.BucketValidation> bucketValidation, DataSize minimumTargetSplitSize, boolean forceLocalScheduling, Optional<Long> maxSplitFileSize) {
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.strippedSchema = InternalHiveSplitFactory.stripUnnecessaryProperties(Objects.requireNonNull(schema, "schema is null"));
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.pathDomain = InternalHiveSplitFactory.getPathDomain(Objects.requireNonNull(effectivePredicate, "effectivePredicate is null"));
        this.partitionMatchSupplier = Objects.requireNonNull(partitionMatchSupplier, "partitionMatchSupplier is null");
        this.hiveColumnCoercions = ImmutableMap.copyOf(Objects.requireNonNull(hiveColumnCoercions, "hiveColumnCoercions is null"));
        this.bucketConversion = Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        this.bucketValidation = Objects.requireNonNull(bucketValidation, "bucketValidation is null");
        this.forceLocalScheduling = forceLocalScheduling;
        this.minimumTargetSplitSizeInBytes = minimumTargetSplitSize.toBytes();
        this.maxSplitFileSize = Objects.requireNonNull(maxSplitFileSize, "maxSplitFileSize is null");
        Preconditions.checkArgument((this.minimumTargetSplitSizeInBytes > 0L ? 1 : 0) != 0, (String)"minimumTargetSplitSize must be > 0, found: %s", (Object)minimumTargetSplitSize);
    }

    private static Map<String, String> stripUnnecessaryProperties(Map<String, String> schema) {
        schema = OrcPageSourceFactory.stripUnnecessaryProperties(schema);
        schema = ParquetPageSourceFactory.stripUnnecessaryProperties(schema);
        schema = RcFilePageSourceFactory.stripUnnecessaryProperties(schema);
        return schema;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(TrinoFileStatus status, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        splittable = splittable && status.getLength() > this.minimumTargetSplitSizeInBytes && this.storageFormat.isSplittable(status.getPath());
        return this.createInternalHiveSplit(status.getPath(), status.getBlockLocations(), 0L, status.getLength(), status.getLength(), status.getModificationTime(), readBucketNumber, tableBucketNumber, splittable, acidInfo);
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(String path, List<BlockLocation> blockLocations, long start, long length, long estimatedFileSize, long fileModificationTime, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        if (!InternalHiveSplitFactory.pathMatchesPredicate(this.pathDomain, path)) {
            return Optional.empty();
        }
        if (estimatedFileSize == 0L) {
            return Optional.empty();
        }
        if (!this.partitionMatchSupplier.getAsBoolean()) {
            return Optional.empty();
        }
        if (this.maxSplitFileSize.isPresent() && estimatedFileSize > this.maxSplitFileSize.get()) {
            return Optional.empty();
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockStart, blockEnd, InternalHiveSplitFactory.getHostAddresses(blockLocation)));
        }
        ImmutableList blocks = blockBuilder.build();
        InternalHiveSplitFactory.checkBlocks(path, (List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start, start + length, ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses()));
        }
        return Optional.of(new InternalHiveSplit(this.partitionName, path, start, start + length, estimatedFileSize, fileModificationTime, this.strippedSchema, this.partitionKeys, (List<InternalHiveSplit.InternalHiveBlock>)blocks, readBucketNumber, tableBucketNumber, splittable, this.forceLocalScheduling && InternalHiveSplitFactory.allBlocksHaveAddress((Collection<InternalHiveSplit.InternalHiveBlock>)blocks), this.hiveColumnCoercions, this.bucketConversion, this.bucketValidation, acidInfo, this.partitionMatchSupplier));
    }

    private static void checkBlocks(String path, List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (String)"Split (%s) has negative start (%s)", (Object)path, (long)start);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (String)"Split (%s) has negative length (%s)", (Object)path, (long)length);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (String)"Split (%s) has no blocks", (Object)path);
        Preconditions.checkArgument((start == blocks.get(0).getStart() ? 1 : 0) != 0, (String)"Split (%s) start (%s) does not match first block start (%s)", (Object)path, (Object)start, (Object)blocks.get(0).getStart());
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0, (String)"Split (%s) end (%s) does not match last block end (%s)", (Object)path, (Object)(start + length), (Object)blocks.get(blocks.size() - 1).getEnd());
        for (int i = 1; i < blocks.size(); ++i) {
            Preconditions.checkArgument((blocks.get(i - 1).getEnd() == blocks.get(i).getStart() ? 1 : 0) != 0, (String)"Split (%s) block end (%s) does not match next block start (%s)", (Object)path, (Object)blocks.get(i - 1).getEnd(), (Object)blocks.get(i).getStart());
        }
    }

    private static boolean allBlocksHaveAddress(Collection<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).noneMatch(List::isEmpty);
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        return (List)blockLocation.getHosts().stream().map(HostAddress::fromString).filter(address -> !address.getHostText().equals("localhost")).collect(ImmutableList.toImmutableList());
    }

    private static Optional<Domain> getPathDomain(TupleDomain<HiveColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> domains.entrySet().stream().filter(entry -> HiveColumnHandle.isPathColumnHandle((HiveColumnHandle)entry.getKey())).map(Map.Entry::getValue).findFirst());
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        return pathDomain.map(domain -> domain.includesNullableValue((Object)Slices.utf8Slice((String)path))).orElse(true);
    }
}

