/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.SortingColumn;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.util.HiveBucketing;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record HiveBucketHandle(List<HiveColumnHandle> columns, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int readBucketCount, List<SortingColumn> sortedBy) {
    public HiveBucketHandle {
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        columns.forEach(column -> Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)String.format("projected column %s is not allowed for bucketing", column)));
        Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
    }

    public HiveBucketProperty toTableBucketProperty() {
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.tableBucketCount, this.sortedBy);
    }
}

