/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Modules;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorAccessControl;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveAnalyzeProperties;
import io.trino.plugin.hive.HiveColumnProperties;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveConnector;
import io.trino.plugin.hive.HiveMaterializedViewPropertiesProvider;
import io.trino.plugin.hive.HiveModule;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.HiveViewProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.metastore.HiveMetastoreModule;
import io.trino.plugin.hive.procedure.HiveProcedureModule;
import io.trino.plugin.hive.security.HiveSecurityModule;
import io.trino.plugin.hive.security.SystemTableAwareAccessControl;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class HiveConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "hive";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        return HiveConnectorFactory.createConnector(catalogName, config, context, Modules.EMPTY_MODULE, Optional.empty(), Optional.empty());
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module, Optional<HiveMetastore> metastore, Optional<TrinoFileSystemFactory> fileSystemFactory) {
        ClassLoader classLoader = HiveConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new CatalogNameModule(catalogName), new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule("io.trino.plugin.hive", "trino.plugin.hive"), new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new HiveModule(), new HiveMetastoreModule(metastore), new HiveSecurityModule(), fileSystemFactory.map(factory -> binder -> binder.bind(TrinoFileSystemFactory.class).toInstance(factory)).orElseGet(() -> new FileSystemModule(catalogName, context.getNodeManager(), context.getOpenTelemetry(), false)), new HiveProcedureModule(), new MBeanServerModule(), binder -> {
                binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
                binder.bind(Tracer.class).toInstance((Object)context.getTracer());
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder());
                binder.bind(MetadataProvider.class).toInstance((Object)context.getMetadataProvider());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
            }, binder -> Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(HiveSessionProperties.class).in(Scopes.SINGLETON), module});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            Set sessionPropertiesProviders = (Set)injector.getInstance((Key)new Key<Set<SessionPropertiesProvider>>(){});
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            HiveViewProperties hiveViewProperties = (HiveViewProperties)injector.getInstance(HiveViewProperties.class);
            HiveColumnProperties hiveColumnProperties = (HiveColumnProperties)injector.getInstance(HiveColumnProperties.class);
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            HiveMaterializedViewPropertiesProvider hiveMaterializedViewPropertiesProvider = (HiveMaterializedViewPropertiesProvider)injector.getInstance(HiveMaterializedViewPropertiesProvider.class);
            Set procedures = (Set)injector.getInstance((Key)new Key<Set<Procedure>>(){});
            Set tableProcedures = (Set)injector.getInstance((Key)new Key<Set<TableProcedureMetadata>>(){});
            Set systemTableProviders = (Set)injector.getInstance((Key)new Key<Set<SystemTableProvider>>(){});
            Optional<ConnectorAccessControl> hiveAccessControl = ((Optional)injector.getInstance((Key)new Key<Optional<ConnectorAccessControl>>(){})).map(accessControl -> new SystemTableAwareAccessControl((ConnectorAccessControl)accessControl, systemTableProviders)).map(accessControl -> new ClassLoaderSafeConnectorAccessControl((ConnectorAccessControl)accessControl, classLoader));
            HiveConnector hiveConnector = new HiveConnector(injector, lifeCycleManager, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), procedures, tableProcedures, sessionPropertiesProviders, HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveViewProperties.getViewProperties(), hiveColumnProperties.getColumnProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), hiveMaterializedViewPropertiesProvider.getMaterializedViewProperties(), hiveAccessControl, (Set)injector.getInstance((Key)new Key<Set<ConnectorTableFunction>>(){}), (FunctionProvider)injector.getInstance(FunctionProvider.class), ((HiveConfig)injector.getInstance(HiveConfig.class)).isSingleStatementWritesOnly(), classLoader);
            return hiveConnector;
        }
    }
}

