/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.metastore.HivePartition;
import io.trino.metastore.Partition;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePartitionResult;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class HivePartitionManager {
    private final int maxPartitionsForEagerLoad;
    private final int domainCompactionThreshold;

    @Inject
    public HivePartitionManager(HiveConfig hiveConfig) {
        this(hiveConfig.getMaxPartitionsForEagerLoad(), hiveConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(int maxPartitionsForEagerLoad, int domainCompactionThreshold) {
        Preconditions.checkArgument((maxPartitionsForEagerLoad >= 1 ? 1 : 0) != 0, (Object)"maxPartitionsForEagerLoad must be at least 1");
        this.maxPartitionsForEagerLoad = maxPartitionsForEagerLoad;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint constraint) {
        Iterable<HivePartition> partitionsIterable;
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary().intersect(hiveTableHandle.getEnforcedConstraint());
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Optional<HiveBucketHandle> hiveBucketHandle = hiveTableHandle.getBucketHandle();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, Optional.empty(), (Iterable<HivePartition>)ImmutableList.of(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<HiveColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = HiveBucketing.getHiveBucketFilter(hiveTableHandle, (TupleDomain<ColumnHandle>)effectivePredicate);
        TupleDomain compactEffectivePredicate = effectivePredicate.transformKeys(HiveColumnHandle.class::cast).simplify(this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, Optional.empty(), (Iterable<HivePartition>)ImmutableList.of((Object)new HivePartition(tableName)), (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<HiveColumnHandle>)compactEffectivePredicate, hiveBucketHandle, bucketFilter);
        }
        Optional<List<String>> partitionNames = Optional.empty();
        Predicate<Map> predicate = constraint.predicate().orElse(value -> true);
        if (hiveTableHandle.getPartitions().isPresent()) {
            partitionsIterable = (Iterable<HivePartition>)hiveTableHandle.getPartitions().get().stream().filter(partition -> HivePartitionManager.partitionMatches(partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate, predicate, partition)).collect(ImmutableList.toImmutableList());
        } else {
            List partitionNamesList = hiveTableHandle.getPartitionNames().orElseGet(() -> this.getFilteredPartitionNames(metastore, tableName, partitionColumns, (TupleDomain<HiveColumnHandle>)compactEffectivePredicate));
            partitionsIterable = () -> partitionNamesList.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate, predicate)).filter(Optional::isPresent).map(Optional::get).iterator();
            partitionNames = Optional.of(partitionNamesList);
        }
        return new HivePartitionResult(partitionColumns, partitionNames, partitionsIterable, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<HiveColumnHandle>)compactEffectivePredicate, hiveBucketHandle, bucketFilter);
    }

    public HivePartitionResult getPartitions(ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        Optional<HiveBucketHandle> bucketHandle = hiveTableHandle.getBucketHandle();
        List partitionColumnNames = (List)partitionColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        List partitionList = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.toPartitionName(partitionColumnNames, partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, (TupleDomain<ColumnHandle>)TupleDomain.all(), value -> true)).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        return new HivePartitionResult(partitionColumns, Optional.empty(), partitionList, (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty());
    }

    public HiveTableHandle applyPartitionResult(HiveTableHandle handle, HivePartitionResult partitions, Constraint constraint) {
        Optional<List<String>> partitionNames = partitions.getPartitionNames();
        TupleDomain enforcedConstraint = handle.getEnforcedConstraint();
        Optional<List<HivePartition>> partitionList = this.tryLoadPartitions(partitions);
        if (partitionList.isPresent()) {
            partitionNames = Optional.empty();
            List<HiveColumnHandle> partitionColumns = partitions.getPartitionColumns();
            enforcedConstraint = partitions.getEffectivePredicate().filter((column, domain) -> partitionColumns.contains(column));
        }
        return new HiveTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getTableParameters(), (List<HiveColumnHandle>)ImmutableList.copyOf(partitions.getPartitionColumns()), handle.getDataColumns(), partitionNames, partitionList, partitions.getCompactEffectivePredicate(), (TupleDomain<ColumnHandle>)enforcedConstraint, partitions.getBucketHandle(), partitions.getBucketFilter(), handle.getAnalyzePartitionValues(), (Set<HiveColumnHandle>)ImmutableSet.builder().addAll(handle.getConstraintColumns()).addAll((Iterable)constraint.getPredicateColumns().orElseGet(ImmutableSet::of).stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).build(), handle.getProjectedColumns(), handle.getTransaction(), handle.isRecordScannedFiles(), handle.getMaxScannedFileSize());
    }

    public Iterator<HivePartition> getPartitions(SemiTransactionalHiveMetastore metastore, HiveTableHandle table) {
        TupleDomain summary = table.getEnforcedConstraint().intersect(table.getCompactEffectivePredicate().transformKeys(ColumnHandle.class::cast));
        return table.getPartitions().map(List::iterator).orElseGet(() -> this.getPartitions(metastore, table, new Constraint(summary)).getPartitions());
    }

    public Optional<List<HivePartition>> tryLoadPartitions(HivePartitionResult partitionResult) {
        ImmutableList.Builder partitions = ImmutableList.builder();
        Iterator<HivePartition> iterator = partitionResult.getPartitions();
        int partitionCount = 0;
        while (iterator.hasNext()) {
            if (++partitionCount > this.maxPartitionsForEagerLoad) {
                return Optional.empty();
            }
            partitions.add((Object)iterator.next());
        }
        return Optional.of(partitions.build());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns);
        if (HivePartitionManager.partitionMatches(partitionColumns, constraintSummary, constraint, partition)) {
            return Optional.of(partition);
        }
        return Optional.empty();
    }

    private static boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint, HivePartition partition) {
        return HivePartitionManager.partitionMatches(partitionColumns, constraintSummary, partition) && constraint.test(partition.getKeys());
    }

    public static boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, HivePartition partition) {
        if (constraintSummary.isNone()) {
            return false;
        }
        Map domains = (Map)constraintSummary.getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = (NullableValue)partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return true;
    }

    private List<String> getFilteredPartitionNames(SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate) {
        List columnNames = (List)partitionKeys.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        TupleDomain<String> partitionKeysFilter = MetastoreUtil.computePartitionKeyFilter(partitionKeys, effectivePredicate);
        return metastore.getPartitionNamesByFilter(tableName.getSchemaName(), tableName.getTableName(), columnNames, partitionKeysFilter).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns) {
        List<String> partitionValues = HivePartitionManager.extractPartitionValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)partitionColumns.size());
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), column.getType());
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.buildOrThrow();
        return new HivePartition(tableName, partitionName, (Map)values);
    }

    public static List<String> extractPartitionValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
            values.add((Object)Partition.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
        values.add((Object)Partition.unescapePathName((String)partitionName.substring(valueStart)));
        return values.build();
    }
}

