/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class HivePartitioningHandle
implements ConnectorPartitioningHandle {
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final List<HiveType> hiveTypes;
    private final OptionalInt maxCompatibleBucketCount;
    private final boolean usePartitionedBucketing;

    @JsonCreator
    public HivePartitioningHandle(@JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="hiveBucketTypes") List<HiveType> hiveTypes, @JsonProperty(value="maxCompatibleBucketCount") OptionalInt maxCompatibleBucketCount, @JsonProperty(value="usePartitionedBucketing") boolean usePartitionedBucketing) {
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.hiveTypes = Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        this.maxCompatibleBucketCount = maxCompatibleBucketCount;
        this.usePartitionedBucketing = usePartitionedBucketing;
    }

    @JsonProperty
    public HiveBucketing.BucketingVersion getBucketingVersion() {
        return this.bucketingVersion;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<HiveType> getHiveTypes() {
        return this.hiveTypes;
    }

    @JsonProperty
    public OptionalInt getMaxCompatibleBucketCount() {
        return this.maxCompatibleBucketCount;
    }

    @JsonProperty
    public boolean isUsePartitionedBucketing() {
        return this.usePartitionedBucketing;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("buckets", this.bucketCount).add("hiveTypes", this.hiveTypes);
        if (this.usePartitionedBucketing) {
            helper.add("usePartitionedBucketing", this.usePartitionedBucketing);
        }
        return helper.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitioningHandle that = (HivePartitioningHandle)o;
        return this.bucketCount == that.bucketCount && this.usePartitionedBucketing == that.usePartitionedBucketing && Objects.equals(this.hiveTypes, that.hiveTypes);
    }

    public int hashCode() {
        return Objects.hash(this.bucketCount, this.hiveTypes, this.usePartitionedBucketing);
    }
}

