/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Predicates;
import io.trino.filesystem.FileEntry;
import java.util.function.Predicate;

public enum S3StorageClassFilter {
    READ_ALL,
    READ_NON_GLACIER,
    READ_NON_GLACIER_AND_RESTORED;

    private static final String S3_GLACIER_TAG = "s3:glacier";
    private static final String S3_GLACIER_AND_RESTORED_TAG = "s3:glacierRestored";

    private static boolean isNotGlacierObject(FileEntry fileEntry) {
        return !fileEntry.tags().contains(S3_GLACIER_TAG);
    }

    private static boolean isCompletedRestoredObject(FileEntry fileEntry) {
        return S3StorageClassFilter.isNotGlacierObject(fileEntry) || fileEntry.tags().contains(S3_GLACIER_AND_RESTORED_TAG);
    }

    public Predicate<FileEntry> toFileEntryPredicate() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Predicates.alwaysTrue();
            case 1 -> S3StorageClassFilter::isNotGlacierObject;
            case 2 -> S3StorageClassFilter::isCompletedRestoredObject;
        };
    }
}

