/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.cache.ImpersonationCachingConfig;
import io.trino.plugin.hive.metastore.cache.SharedHiveMetastoreCache;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.procedure.FlushMetadataCacheProcedure;
import io.trino.spi.procedure.Procedure;
import java.util.Optional;
import org.weakref.jmx.guice.ExportBinder;

public class CachingHiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final boolean installFlushMetadataCacheProcedure;

    public CachingHiveMetastoreModule(boolean installFlushMetadataCacheProcedure) {
        this.installFlushMetadataCacheProcedure = installFlushMetadataCacheProcedure;
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ImpersonationCachingConfig.class);
        binder.bind(SharedHiveMetastoreCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastoreFactory.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
        if (this.installFlushMetadataCacheProcedure) {
            OptionalBinder.newOptionalBinder((Binder)binder, GlueCache.class);
            OptionalBinder.newOptionalBinder((Binder)binder, DirectoryLister.class);
            Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(FlushMetadataCacheProcedure.class).in(Scopes.SINGLETON);
        }
    }

    @Provides
    @Singleton
    public static HiveMetastoreFactory createHiveMetastore(@RawHiveMetastoreFactory HiveMetastoreFactory metastoreFactory, SharedHiveMetastoreCache sharedHiveMetastoreCache) {
        return sharedHiveMetastoreCache.createCachingHiveMetastoreFactory(metastoreFactory);
    }

    @Provides
    @Singleton
    public static Optional<CachingHiveMetastore> createHiveMetastore(HiveMetastoreFactory metastoreFactory) {
        if (metastoreFactory instanceof SharedHiveMetastoreCache.CachingHiveMetastoreFactory) {
            return Optional.of(((SharedHiveMetastoreCache.CachingHiveMetastoreFactory)metastoreFactory).getMetastore());
        }
        return Optional.empty();
    }
}

