/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveType;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.PrimitiveTypeInfo;
import io.trino.metastore.type.TypeInfo;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public final class SparkMetastoreUtil {
    private static final String SPARK_SQL_STATS_PREFIX = "spark.sql.statistics.";
    private static final String COLUMN_STATS_PREFIX = "spark.sql.statistics.colStats.";
    private static final String NUM_FILES = "numFiles";
    private static final String RAW_DATA_SIZE = "rawDataSize";
    private static final String TOTAL_SIZE = "totalSize";
    private static final String COLUMN_MIN = "min";
    private static final String COLUMN_MAX = "max";

    private SparkMetastoreUtil() {
    }

    public static Optional<PartitionStatistics> getSparkTableStatistics(Map<String, String> parameters, Map<String, HiveType> columns) {
        if (SparkMetastoreUtil.toLong(parameters.get("numRows")).isPresent()) {
            return Optional.empty();
        }
        HiveBasicStatistics sparkBasicStatistics = SparkMetastoreUtil.getSparkBasicStatistics(parameters);
        if (sparkBasicStatistics.getRowCount().isEmpty()) {
            return Optional.empty();
        }
        Map columnStatistics = (Map)columns.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), SparkMetastoreUtil.fromMetastoreColumnStatistics((String)entry.getKey(), (HiveType)entry.getValue(), parameters))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return Optional.of(new PartitionStatistics(sparkBasicStatistics, columnStatistics));
    }

    public static HiveBasicStatistics getSparkBasicStatistics(Map<String, String> parameters) {
        OptionalLong rowCount = SparkMetastoreUtil.toLong(parameters.get("spark.sql.statistics.numRows"));
        if (rowCount.isEmpty()) {
            return HiveBasicStatistics.createEmptyStatistics();
        }
        OptionalLong fileCount = SparkMetastoreUtil.toLong(parameters.get("spark.sql.statistics.numFiles"));
        OptionalLong inMemoryDataSizeInBytes = SparkMetastoreUtil.toLong(parameters.get("spark.sql.statistics.rawDataSize"));
        OptionalLong onDiskDataSizeInBytes = SparkMetastoreUtil.toLong(parameters.get("spark.sql.statistics.totalSize"));
        return new HiveBasicStatistics(fileCount, rowCount, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    @VisibleForTesting
    static HiveColumnStatistics fromMetastoreColumnStatistics(String columnName, HiveType type, Map<String, String> parameters) {
        TypeInfo typeInfo = type.getTypeInfo();
        if (typeInfo.getCategory() != Category.PRIMITIVE) {
            return HiveColumnStatistics.empty();
        }
        String field = COLUMN_STATS_PREFIX + columnName + ".";
        OptionalLong maxLength = SparkMetastoreUtil.toLong(parameters.get(field + "maxLen"));
        OptionalDouble avgLength = SparkMetastoreUtil.toDouble(parameters.get(field + "avgLen"));
        OptionalLong nullsCount = SparkMetastoreUtil.toLong(parameters.get(field + "nullCount"));
        OptionalLong distinctValuesWithNullCount = SparkMetastoreUtil.toLong(parameters.get(field + "distinctCount"));
        return switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            default -> throw new MatchException(null, null);
            case PrimitiveCategory.BOOLEAN -> HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)nullsCount);
            case PrimitiveCategory.BYTE, PrimitiveCategory.SHORT, PrimitiveCategory.INT, PrimitiveCategory.LONG -> HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)SparkMetastoreUtil.toLong(parameters.get(field + COLUMN_MIN)), (OptionalLong)SparkMetastoreUtil.toLong(parameters.get(field + COLUMN_MAX)), (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.TIMESTAMP -> HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.FLOAT, PrimitiveCategory.DOUBLE -> HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)SparkMetastoreUtil.toDouble(parameters.get(field + COLUMN_MIN)), (OptionalDouble)SparkMetastoreUtil.toDouble(parameters.get(field + COLUMN_MAX)), (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.STRING, PrimitiveCategory.VARCHAR, PrimitiveCategory.CHAR -> HiveColumnStatistics.createStringColumnStatistics((OptionalLong)maxLength, (OptionalDouble)avgLength, (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.DATE -> HiveColumnStatistics.createDateColumnStatistics(SparkMetastoreUtil.toDate(parameters.get(field + COLUMN_MIN)), SparkMetastoreUtil.toDate(parameters.get(field + COLUMN_MAX)), (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.BINARY -> HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)maxLength, (OptionalDouble)avgLength, (OptionalLong)nullsCount);
            case PrimitiveCategory.DECIMAL -> HiveColumnStatistics.createDecimalColumnStatistics(SparkMetastoreUtil.toDecimal(parameters.get(field + COLUMN_MIN)), SparkMetastoreUtil.toDecimal(parameters.get(field + COLUMN_MAX)), (OptionalLong)nullsCount, (OptionalLong)distinctValuesWithNullCount);
            case PrimitiveCategory.TIMESTAMPLOCALTZ, PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveCategory.VOID, PrimitiveCategory.UNKNOWN -> HiveColumnStatistics.empty();
        };
    }

    private static OptionalLong toLong(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalLong.empty();
        }
        Long longValue = Longs.tryParse((String)parameterValue);
        if (longValue == null || longValue < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(longValue);
    }

    private static OptionalDouble toDouble(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalDouble.empty();
        }
        Double doubleValue = Doubles.tryParse((String)parameterValue);
        if (doubleValue == null || doubleValue < 0.0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(doubleValue);
    }

    private static Optional<BigDecimal> toDecimal(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return Optional.empty();
        }
        try {
            BigDecimal decimal = new BigDecimal(parameterValue);
            if (decimal.compareTo(BigDecimal.ZERO) < 0) {
                return Optional.empty();
            }
            return Optional.of(decimal);
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    private static Optional<LocalDate> toDate(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return Optional.empty();
        }
        try {
            LocalDate date = LocalDate.parse(parameterValue);
            return Optional.of(date);
        }
        catch (DateTimeException exception) {
            return Optional.empty();
        }
    }
}

