/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.cache.CacheStatsMBean;
import io.trino.cache.CacheUtils;
import io.trino.cache.SafeCaches;
import io.trino.metastore.Database;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.Partition;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.metastore.cache.ReentrantBoundedExecutor;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.PartitionName;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

class InMemoryGlueCache
implements GlueCache {
    private final ExecutorService refreshExecutor;
    private final LoadingCache<Global, ValueHolder<List<String>>> databaseNamesCache;
    private final LoadingCache<String, ValueHolder<Optional<Database>>> databaseCache;
    private final LoadingCache<String, ValueHolder<List<TableInfo>>> tableNamesCache;
    private final LoadingCache<SchemaTableName, ValueHolder<Optional<Table>>> tableCache;
    private final LoadingCache<SchemaTableName, ColumnStatisticsHolder> tableColumnStatsCache;
    private final LoadingCache<PartitionNamesKey, ValueHolder<Set<PartitionName>>> partitionNamesCache;
    private final LoadingCache<PartitionKey, ValueHolder<Optional<Partition>>> partitionCache;
    private final LoadingCache<PartitionKey, ColumnStatisticsHolder> partitionColumnStatsCache;
    private final LoadingCache<String, ValueHolder<Collection<LanguageFunction>>> allFunctionsCache;
    private final LoadingCache<FunctionKey, ValueHolder<Collection<LanguageFunction>>> functionCache;
    private final AtomicLong databaseInvalidationCounter = new AtomicLong();
    private final AtomicLong tableInvalidationCounter = new AtomicLong();
    private final AtomicLong partitionInvalidationCounter = new AtomicLong();

    public InMemoryGlueCache(CatalogName catalogName, Duration metadataCacheTtl, Duration statsCacheTtl, Optional<Duration> refreshInterval, int maxMetastoreRefreshThreads, long maximumSize) {
        this.refreshExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metastore-" + String.valueOf(catalogName) + "-%s")));
        ReentrantBoundedExecutor boundedRefreshExecutor = new ReentrantBoundedExecutor(this.refreshExecutor, maxMetastoreRefreshThreads);
        OptionalLong refreshMillis = refreshInterval.stream().mapToLong(Duration::toMillis).findAny();
        OptionalLong metadataCacheTtlMillis = OptionalLong.of(metadataCacheTtl.toMillis());
        this.databaseNamesCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.databaseCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.tableNamesCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.tableCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.partitionNamesCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.partitionCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.allFunctionsCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        this.functionCache = InMemoryGlueCache.buildCache(metadataCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ValueHolder::new);
        OptionalLong statsCacheTtlMillis = OptionalLong.of(statsCacheTtl.toMillis());
        this.tableColumnStatsCache = InMemoryGlueCache.buildCache(statsCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ColumnStatisticsHolder::new);
        this.partitionColumnStatsCache = InMemoryGlueCache.buildCache(statsCacheTtlMillis, refreshMillis, boundedRefreshExecutor, maximumSize, ColumnStatisticsHolder::new);
    }

    @PreDestroy
    public void stop() {
        this.refreshExecutor.shutdownNow();
    }

    @Override
    public List<String> getDatabaseNames(Function<Consumer<Database>, List<String>> loader) {
        long invalidationCounter = this.databaseInvalidationCounter.get();
        return ((ValueHolder)this.databaseNamesCache.getUnchecked((Object)Global.GLOBAL)).getValue(() -> (List)loader.apply(database -> this.cacheDatabase(invalidationCounter, (Database)database)));
    }

    private void cacheDatabase(long invalidationCounter, Database database) {
        InMemoryGlueCache.cacheValue(this.databaseCache, database.getDatabaseName(), Optional.of(database), () -> invalidationCounter == this.databaseInvalidationCounter.get());
    }

    @Override
    public void invalidateDatabase(String databaseName) {
        this.databaseInvalidationCounter.incrementAndGet();
        this.databaseCache.invalidate((Object)databaseName);
        for (SchemaTableName schemaTableName : Sets.union(this.tableCache.asMap().keySet(), this.tableColumnStatsCache.asMap().keySet())) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            this.invalidateTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), true);
        }
        for (PartitionKey partitionKey : Sets.union(this.partitionCache.asMap().keySet(), this.partitionColumnStatsCache.asMap().keySet())) {
            if (!partitionKey.databaseName().equals(databaseName)) continue;
            this.invalidatePartition(partitionKey);
        }
        CacheUtils.invalidateAllIf(this.partitionNamesCache, partitionNamesKey -> partitionNamesKey.databaseName().equals(databaseName));
        CacheUtils.invalidateAllIf(this.functionCache, functionKey -> functionKey.databaseName().equals(databaseName));
        this.allFunctionsCache.invalidate((Object)databaseName);
    }

    @Override
    public void invalidateDatabaseNames() {
        this.databaseNamesCache.invalidate((Object)Global.GLOBAL);
    }

    @Override
    public Optional<Database> getDatabase(String databaseName, Supplier<Optional<Database>> loader) {
        return ((ValueHolder)this.databaseCache.getUnchecked((Object)databaseName)).getValue(loader);
    }

    @Override
    public List<TableInfo> getTables(String databaseName, Function<Consumer<Table>, List<TableInfo>> loader) {
        long invalidationCounter = this.tableInvalidationCounter.get();
        return ((ValueHolder)this.tableNamesCache.getUnchecked((Object)databaseName)).getValue(() -> (List)loader.apply(table -> this.cacheTable(invalidationCounter, (Table)table)));
    }

    private void cacheTable(long invalidationCounter, Table table) {
        InMemoryGlueCache.cacheValue(this.tableCache, table.getSchemaTableName(), Optional.of(table), () -> invalidationCounter == this.tableInvalidationCounter.get());
    }

    @Override
    public void invalidateTables(String databaseName) {
        this.tableNamesCache.invalidate((Object)databaseName);
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName, Supplier<Optional<Table>> loader) {
        return ((ValueHolder)this.tableCache.getUnchecked((Object)new SchemaTableName(databaseName, tableName))).getValue(loader);
    }

    @Override
    public void invalidateTable(String databaseName, String tableName, boolean cascade) {
        this.tableInvalidationCounter.incrementAndGet();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        this.tableCache.invalidate((Object)schemaTableName);
        this.tableColumnStatsCache.invalidate((Object)schemaTableName);
        if (cascade) {
            for (PartitionKey partitionKey : Sets.union(this.partitionCache.asMap().keySet(), this.partitionColumnStatsCache.asMap().keySet())) {
                if (!partitionKey.databaseName().equals(databaseName) || !partitionKey.tableName().equals(tableName)) continue;
                this.invalidatePartition(partitionKey);
            }
            this.invalidatePartitionNames(databaseName, tableName);
        }
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames, Function<Set<String>, Map<String, HiveColumnStatistics>> loader) {
        return ((ColumnStatisticsHolder)this.tableColumnStatsCache.getUnchecked((Object)new SchemaTableName(databaseName, tableName))).getColumnStatistics(columnNames, loader);
    }

    @Override
    public void invalidateTableColumnStatistics(String databaseName, String tableName) {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        this.tableColumnStatsCache.invalidate((Object)schemaTableName);
    }

    @Override
    public Set<PartitionName> getPartitionNames(String databaseName, String tableName, String glueExpression, Function<Consumer<Partition>, Set<PartitionName>> loader) {
        long invalidationCounter = this.partitionInvalidationCounter.get();
        return ((ValueHolder)this.partitionNamesCache.getUnchecked((Object)new PartitionNamesKey(databaseName, tableName, glueExpression))).getValue(() -> (Set)loader.apply(partition -> this.cachePartition(invalidationCounter, (Partition)partition)));
    }

    private void invalidatePartitionNames(String databaseName, String tableName) {
        CacheUtils.invalidateAllIf(this.partitionNamesCache, partitionNamesKey -> partitionNamesKey.databaseName().equals(databaseName) && partitionNamesKey.tableName().equals(tableName));
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, PartitionName partitionName, Supplier<Optional<Partition>> loader) {
        return ((ValueHolder)this.partitionCache.getUnchecked((Object)new PartitionKey(databaseName, tableName, partitionName))).getValue(loader);
    }

    @Override
    public Collection<Partition> batchGetPartitions(String databaseName, String tableName, Collection<PartitionName> partitionNames, BiFunction<Consumer<Partition>, Collection<PartitionName>, Collection<Partition>> loader) {
        ImmutableList.Builder partitions = ImmutableList.builder();
        HashSet<PartitionName> missingPartitionNames = new HashSet<PartitionName>();
        for (PartitionName partitionName : partitionNames) {
            Optional partition2;
            ValueHolder valueHolder = (ValueHolder)this.partitionCache.getIfPresent((Object)new PartitionKey(databaseName, tableName, partitionName));
            if (valueHolder != null && (partition2 = valueHolder.getValueIfPresent().flatMap(Function.identity())).isPresent()) {
                partitions.add((Object)((Partition)partition2.get()));
                continue;
            }
            missingPartitionNames.add(partitionName);
        }
        if (!missingPartitionNames.isEmpty()) {
            long invalidationCounter = this.partitionInvalidationCounter.get();
            partitions.addAll((Iterable)loader.apply(partition -> this.cachePartition(invalidationCounter, (Partition)partition), missingPartitionNames));
        }
        return partitions.build();
    }

    private void cachePartition(long invalidationCounter, Partition partition) {
        PartitionKey partitionKey = new PartitionKey(partition.getDatabaseName(), partition.getTableName(), new PartitionName(partition.getValues()));
        InMemoryGlueCache.cacheValue(this.partitionCache, partitionKey, Optional.of(partition), () -> invalidationCounter == this.partitionInvalidationCounter.get());
    }

    @Override
    public void invalidatePartition(String databaseName, String tableName, PartitionName partitionName) {
        this.invalidatePartition(new PartitionKey(databaseName, tableName, partitionName));
    }

    private void invalidatePartition(PartitionKey partitionKey) {
        this.partitionInvalidationCounter.incrementAndGet();
        this.partitionCache.invalidate((Object)partitionKey);
        this.partitionColumnStatsCache.invalidate((Object)partitionKey);
    }

    @Override
    public Map<String, HiveColumnStatistics> getPartitionColumnStatistics(String databaseName, String tableName, PartitionName partitionName, Set<String> columnNames, Function<Set<String>, Map<String, HiveColumnStatistics>> loader) {
        return ((ColumnStatisticsHolder)this.partitionColumnStatsCache.getUnchecked((Object)new PartitionKey(databaseName, tableName, partitionName))).getColumnStatistics(columnNames, loader);
    }

    @Override
    public Collection<LanguageFunction> getAllFunctions(String databaseName, Supplier<Collection<LanguageFunction>> loader) {
        return ((ValueHolder)this.allFunctionsCache.getUnchecked((Object)databaseName)).getValue(loader);
    }

    @Override
    public Collection<LanguageFunction> getFunction(String databaseName, String functionName, Supplier<Collection<LanguageFunction>> loader) {
        return ((ValueHolder)this.functionCache.getUnchecked((Object)new FunctionKey(databaseName, functionName))).getValue(loader);
    }

    @Override
    public void invalidateFunction(String databaseName, String functionName) {
        this.functionCache.invalidate((Object)new FunctionKey(databaseName, functionName));
        this.allFunctionsCache.invalidate((Object)databaseName);
    }

    @Override
    public void flushCache() {
        this.databaseInvalidationCounter.incrementAndGet();
        this.tableInvalidationCounter.incrementAndGet();
        this.partitionInvalidationCounter.incrementAndGet();
        this.databaseNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.tableColumnStatsCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionColumnStatsCache.invalidateAll();
        this.allFunctionsCache.invalidateAll();
        this.functionCache.invalidateAll();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseNamesCacheStats() {
        return new CacheStatsMBean(this.databaseNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseCacheStats() {
        return new CacheStatsMBean(this.databaseCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesCacheStats() {
        return new CacheStatsMBean(this.tableNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableCacheStats() {
        return new CacheStatsMBean(this.tableCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableColumnStatsCacheStats() {
        return new CacheStatsMBean(this.tableColumnStatsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionNamesCacheStats() {
        return new CacheStatsMBean(this.partitionNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionCacheStats() {
        return new CacheStatsMBean(this.partitionCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionColumnStatsCacheStats() {
        return new CacheStatsMBean(this.partitionColumnStatsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getAllFunctionsCacheStats() {
        return new CacheStatsMBean(this.allFunctionsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getFunctionCacheStats() {
        return new CacheStatsMBean(this.functionCache);
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildCache(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Executor refreshExecutor, long maximumSize, Supplier<V> loader) {
        if (expiresAfterWriteMillis.isEmpty()) {
            return SafeCaches.emptyLoadingCache((CacheLoader)CacheLoader.from(ignores -> loader.get()), (boolean)true);
        }
        CacheLoader cacheLoader = CacheLoader.from(loader::get);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS).maximumSize(maximumSize).recordStats();
        if (refreshMillis.isPresent() && expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong()) {
            cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
            cacheLoader = CacheLoader.asyncReloading((CacheLoader)cacheLoader, (Executor)refreshExecutor);
        }
        return cacheBuilder.build(cacheLoader);
    }

    private static <K, V> void cacheValue(LoadingCache<K, ValueHolder<V>> cache, K key, V value, BooleanSupplier test) {
        ValueHolder valueHolder = (ValueHolder)cache.getUnchecked(key);
        if (!test.getAsBoolean()) {
            return;
        }
        valueHolder.tryOverwrite(value);
        cache.asMap().replace(key, valueHolder, valueHolder);
    }

    private static enum Global {
        GLOBAL;

    }

    private static class ValueHolder<V> {
        private final Lock writeLock = new ReentrantLock();
        private volatile V value;

        public V getValue(Supplier<V> loader) {
            if (this.value == null) {
                this.writeLock.lock();
                try {
                    if (this.value == null) {
                        this.value = loader.get();
                        if (this.value == null) {
                            throw new IllegalStateException("Value loader returned null");
                        }
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            return this.value;
        }

        public Optional<V> getValueIfPresent() {
            return Optional.ofNullable(this.value);
        }

        public void tryOverwrite(V value) {
            if (this.writeLock.tryLock()) {
                try {
                    this.value = value;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private record PartitionKey(String databaseName, String tableName, PartitionName partitionName) {
    }

    private static class ColumnStatisticsHolder {
        private final Lock writeLock = new ReentrantLock();
        private final Map<String, Optional<HiveColumnStatistics>> cache = new ConcurrentHashMap<String, Optional<HiveColumnStatistics>>();

        private ColumnStatisticsHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, HiveColumnStatistics> getColumnStatistics(Set<String> columnNames, Function<Set<String>, Map<String, HiveColumnStatistics>> loader) {
            HashSet<String> missingColumnNames = new HashSet<String>();
            ConcurrentHashMap<String, HiveColumnStatistics> result = new ConcurrentHashMap<String, HiveColumnStatistics>();
            for (String columnName : columnNames) {
                Optional<HiveColumnStatistics> columnStatistics = this.cache.get(columnName);
                if (columnStatistics == null) {
                    missingColumnNames.add(columnName);
                    continue;
                }
                columnStatistics.ifPresent(value -> result.put(columnName, (HiveColumnStatistics)value));
            }
            if (!missingColumnNames.isEmpty()) {
                this.writeLock.lock();
                try {
                    Map<String, HiveColumnStatistics> loadedColumnStatistics = loader.apply(missingColumnNames);
                    for (String missingColumnName : missingColumnNames) {
                        HiveColumnStatistics value2 = loadedColumnStatistics.get(missingColumnName);
                        this.cache.put(missingColumnName, Optional.ofNullable(value2));
                        if (value2 == null) continue;
                        result.put(missingColumnName, value2);
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            return result;
        }
    }

    private record PartitionNamesKey(String databaseName, String tableName, String glueFilterExpression) {
    }

    private record FunctionKey(String databaseName, String functionName) {
    }
}

