/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Table;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.glue.v1.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import java.util.function.Predicate;

public class DefaultGlueMetastoreTableFilterProvider
implements Provider<Predicate<Table>> {
    private final boolean hideDeltaLakeTables;

    @Inject
    public DefaultGlueMetastoreTableFilterProvider(@HideDeltaLakeTables boolean hideDeltaLakeTables) {
        this.hideDeltaLakeTables = hideDeltaLakeTables;
    }

    public Predicate<Table> get() {
        if (this.hideDeltaLakeTables) {
            return Predicate.not(table -> HiveUtil.isDeltaLakeTable(GlueToTrinoConverter.getTableParameters(table)));
        }
        return table -> true;
    }
}

