/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ThriftHttpMetastoreConfig {
    private Duration readTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private AuthenticationMode authenticationMode;
    private Optional<String> httpBearerToken = Optional.empty();
    private Map<String, String> additionalHeaders = ImmutableMap.of();

    @NotNull
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="hive.metastore.http.client.read-timeout")
    @ConfigDescription(value="Socket read timeout for metastore client")
    public ThriftHttpMetastoreConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @NotNull
    public Optional<AuthenticationMode> getAuthenticationMode() {
        return Optional.ofNullable(this.authenticationMode);
    }

    @Config(value="hive.metastore.http.client.authentication.type")
    @ConfigDescription(value="Authentication mode for thrift http based metastore client")
    public ThriftHttpMetastoreConfig setAuthenticationMode(AuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
        return this;
    }

    @NotNull
    public Optional<String> getHttpBearerToken() {
        return this.httpBearerToken;
    }

    @Config(value="hive.metastore.http.client.bearer-token")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Bearer token to authenticate with a HTTP transport based metastore service")
    public ThriftHttpMetastoreConfig setHttpBearerToken(String httpBearerToken) {
        this.httpBearerToken = Optional.ofNullable(httpBearerToken);
        return this;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    @Config(value="hive.metastore.http.client.additional-headers")
    @ConfigDescription(value="Comma separated key:value pairs to be send to metastore as additional headers")
    public ThriftHttpMetastoreConfig setAdditionalHeaders(String httpHeaders) {
        try {
            String headersDelim = "(?<!\\\\),";
            String kvDelim = "(?<!\\\\):";
            HashMap<String, String> temp = new HashMap<String, String>();
            if (httpHeaders != null) {
                for (String kv : httpHeaders.split(headersDelim)) {
                    String key = kv.split(kvDelim, 2)[0].trim();
                    String val = kv.split(kvDelim, 2)[1].trim();
                    temp.put(key, val);
                }
                this.additionalHeaders = ImmutableMap.copyOf(temp);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Invalid format for 'hive.metastore.http.client.additional-headers'. Value provided is %s", httpHeaders), e);
        }
        return this;
    }

    public static enum AuthenticationMode {
        BEARER;

    }
}

