/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Function;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.Table;
import io.trino.hive.thrift.metastore.TableMeta;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public sealed interface ThriftMetastore
permits ThriftHiveMetastore {
    public void createDatabase(Database var1);

    public void dropDatabase(String var1, boolean var2);

    public void alterDatabase(String var1, Database var2);

    public void createTable(Table var1);

    public void dropTable(String var1, String var2, boolean var3);

    public void alterTable(String var1, String var2, Table var3);

    public void alterTransactionalTable(Table var1, long var2, long var4);

    public List<String> getAllDatabases();

    public List<TableMeta> getTables(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(String var1, String var2, List<PartitionWithStatistics> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, PartitionWithStatistics var3);

    public Optional<List<String>> getPartitionNamesByFilter(String var1, String var2, List<String> var3, TupleDomain<String> var4);

    public Optional<Partition> getPartition(String var1, String var2, List<String> var3);

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3);

    public Optional<Table> getTable(String var1, String var2);

    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String var1, String var2, Set<String> var3);

    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String var1, String var2, Set<String> var3, Set<String> var4);

    public boolean useSparkTableStatistics();

    public void updateTableStatistics(String var1, String var2, OptionalLong var3, StatisticsUpdateMode var4, PartitionStatistics var5);

    public void updatePartitionStatistics(Table var1, String var2, StatisticsUpdateMode var3, PartitionStatistics var4);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public void revokeTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, Optional<String> var3, Optional<HivePrincipal> var4);

    default public Optional<List<FieldSchema>> getFields(String databaseName, String tableName) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getSd() == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return Optional.of(table.getSd().getCols());
    }

    default public void checkSupportsTransactions() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, this.getClass().getSimpleName() + " does not support ACID tables");
    }

    default public long openTransaction(AcidTransactionOwner transactionOwner) {
        throw new UnsupportedOperationException();
    }

    default public void commitTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void abortTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void sendTransactionHeartbeat(long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        throw new UnsupportedOperationException();
    }

    default public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    default public Optional<String> getConfigValue(String name) {
        return Optional.empty();
    }

    default public long allocateWriteId(String dbName, String tableName, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        throw new UnsupportedOperationException();
    }

    default public long acquireTableExclusiveLock(AcidTransactionOwner transactionOwner, String queryId, String dbName, String tableName) {
        throw new UnsupportedOperationException();
    }

    default public void releaseTableLock(long lockId) {
        throw new UnsupportedOperationException();
    }

    default public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        throw new UnsupportedOperationException();
    }

    default public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, DataOperationType operation) {
        throw new UnsupportedOperationException();
    }

    public Optional<Function> getFunction(String var1, String var2);

    public Collection<String> getFunctions(String var1, String var2);

    public void createFunction(Function var1);

    public void alterFunction(Function var1);

    public void dropFunction(String var1, String var2);
}

