/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.procedure.Procedures;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RegisterPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle REGISTER_PARTITION;
    private final boolean allowRegisterPartition;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public RegisterPartitionProcedure(HiveConfig hiveConfig, TransactionalMetadataFactory hiveMetadataFactory, TrinoFileSystemFactory fileSystemFactory) {
        this.allowRegisterPartition = hiveConfig.isAllowRegisterPartition();
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "register_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("PARTITION_COLUMNS", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("PARTITION_VALUES", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("LOCATION", (Type)VarcharType.VARCHAR, false, null)), REGISTER_PARTITION.bindTo(this));
    }

    public void registerPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues, String location) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doRegisterPartition(session, accessControl, schemaName, tableName, partitionColumns, partitionValues, location);
        }
    }

    private void doRegisterPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues, String location) {
        io.trino.plugin.base.util.Procedures.checkProcedureArgument((schemaName != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        io.trino.plugin.base.util.Procedures.checkProcedureArgument((tableName != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        io.trino.plugin.base.util.Procedures.checkProcedureArgument((partitionColumns != null ? 1 : 0) != 0, (String)"partition_columns cannot be null", (Object[])new Object[0]);
        io.trino.plugin.base.util.Procedures.checkProcedureArgument((partitionValues != null ? 1 : 0) != 0, (String)"partition_values cannot be null", (Object[])new Object[0]);
        if (!this.allowRegisterPartition) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "register_partition procedure is disabled");
        }
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create(session.getIdentity(), true);
        hiveMetadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> hiveMetadata.cleanupQuery(session);){
            SemiTransactionalHiveMetastore metastore = hiveMetadata.getMetastore();
            SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
            Table table = metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            accessControl.checkCanInsertIntoTable(null, schemaTableName);
            Procedures.checkIsPartitionedTable(table);
            Procedures.checkPartitionColumns(table, partitionColumns);
            Optional partition = metastore.unsafeGetRawHiveMetastore().getPartition(table, partitionValues);
            if (partition.isPresent()) {
                String partitionName = HiveUtil.makePartName(partitionColumns, partitionValues);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition [%s] is already registered with location %s", partitionName, ((Partition)partition.get()).getStorage().getLocation()));
            }
            Location partitionLocation = Optional.ofNullable(location).map(Location::of).orElseGet(() -> Location.of((String)table.getStorage().getLocation()).appendPath(HiveUtil.makePartName(partitionColumns, partitionValues)));
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try {
                if (!fileSystem.directoryExists(partitionLocation).orElse(true).booleanValue()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Partition location does not exist: " + String.valueOf(partitionLocation));
                }
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking partition location: " + String.valueOf(partitionLocation), (Throwable)e);
            }
            metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), RegisterPartitionProcedure.buildPartitionObject(session, table, partitionValues, partitionLocation), partitionLocation, Optional.empty(), PartitionStatistics.empty(), false);
            metastore.commit();
        }
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, List<String> partitionValues, Location location) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(partitionValues).setParameters((Map)ImmutableMap.of((Object)"trino_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(location.toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    static {
        try {
            REGISTER_PARTITION = MethodHandles.lookup().unreflect(RegisterPartitionProcedure.class.getMethod("registerPartition", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class, List.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

