/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SyncPartitionMetadataProcedure
implements Provider<Procedure> {
    private static final int PARTITION_NAMES_BATCH_SIZE = 1000;
    private static final MethodHandle SYNC_PARTITION_METADATA;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public SyncPartitionMetadataProcedure(TransactionalMetadataFactory hiveMetadataFactory, TrinoFileSystemFactory fileSystemFactory) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "sync_partition_metadata", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("MODE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("CASE_SENSITIVE", (Type)BooleanType.BOOLEAN, false, (Object)Boolean.TRUE)), SYNC_PARTITION_METADATA.bindTo(this));
    }

    public void syncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doSyncPartitionMetadata(session, accessControl, schemaName, tableName, mode, caseSensitive);
        }
    }

    private void doSyncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        Procedures.checkProcedureArgument((schemaName != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableName != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((mode != null ? 1 : 0) != 0, (String)"mode cannot be null", (Object[])new Object[0]);
        SyncMode syncMode = SyncPartitionMetadataProcedure.toSyncMode(mode);
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create(session.getIdentity(), true);
        hiveMetadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> hiveMetadata.cleanupQuery(session);){
            SemiTransactionalHiveMetastore metastore = hiveMetadata.getMetastore();
            SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
            Table table = metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            if (table.getPartitionColumns().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + String.valueOf(schemaTableName));
            }
            if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
                accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schemaName, tableName));
            }
            if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
                accessControl.checkCanDeleteFromTable(null, new SchemaTableName(schemaName, tableName));
            }
            Set partitionNamesInMetastore = (Set)metastore.getPartitionNames(schemaName, tableName).map(ImmutableSet::copyOf).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            String tableStorageLocation = table.getStorage().getLocation();
            Set canonicalPartitionNamesInMetastore = partitionNamesInMetastore;
            if (!caseSensitive) {
                canonicalPartitionNamesInMetastore = (Set)Lists.partition((List)ImmutableList.copyOf((Collection)partitionNamesInMetastore), (int)1000).stream().flatMap(partitionNames -> metastore.getPartitionsByNames(schemaName, tableName, (List<String>)partitionNames).values().stream()).flatMap(Optional::stream).flatMap(partition -> SyncPartitionMetadataProcedure.getCanonicalPartitionName(partition, table.getPartitionColumns(), tableStorageLocation).stream()).collect(ImmutableSet.toImmutableSet());
            }
            Set<String> partitionsInFileSystem = SyncPartitionMetadataProcedure.listPartitions(this.fileSystemFactory.create(session), Location.of((String)tableStorageLocation), table.getPartitionColumns(), caseSensitive);
            Sets.SetView partitionsToAdd = Sets.difference(partitionsInFileSystem, (Set)canonicalPartitionNamesInMetastore);
            Sets.SetView partitionsToDrop = Sets.difference((Set)canonicalPartitionNamesInMetastore, partitionsInFileSystem);
            SyncPartitionMetadataProcedure.syncPartitions((Set<String>)partitionsToAdd, (Set<String>)partitionsToDrop, syncMode, metastore, session, table);
        }
    }

    private static Optional<String> getCanonicalPartitionName(Partition partition, List<Column> partitionColumns, String tableLocation) {
        String[] partitionDirectories;
        String partitionStorageLocation = partition.getStorage().getLocation();
        if (!partitionStorageLocation.startsWith(tableLocation)) {
            return Optional.empty();
        }
        String partitionName = partitionStorageLocation.substring(tableLocation.length());
        if (partitionName.startsWith("/")) {
            partitionName = partitionName.replaceFirst("^/+", "");
        }
        if (partitionName.endsWith("/")) {
            partitionName = partitionName.replaceFirst("/+$", "");
        }
        if ((partitionDirectories = partitionName.split("/")).length != partitionColumns.size()) {
            return Optional.empty();
        }
        for (int i = 0; i < partitionDirectories.length; ++i) {
            String partitionDirectory = partitionDirectories[i];
            Column column = partitionColumns.get(i);
            if (SyncPartitionMetadataProcedure.isValidPartitionPath(partitionDirectory, column, false)) continue;
            return Optional.empty();
        }
        return Optional.of(partitionName);
    }

    private static Set<String> listPartitions(TrinoFileSystem fileSystem, Location directory, List<Column> partitionColumns, boolean caseSensitive) {
        return SyncPartitionMetadataProcedure.doListPartitions(fileSystem, directory, partitionColumns, partitionColumns.size(), caseSensitive, (List<String>)ImmutableList.of());
    }

    private static Set<String> doListPartitions(TrinoFileSystem fileSystem, Location directory, List<Column> partitionColumns, int depth, boolean caseSensitive, List<String> partitions) {
        if (depth == 0) {
            return ImmutableSet.of((Object)String.join((CharSequence)"/", partitions));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Location location : SyncPartitionMetadataProcedure.listDirectories(fileSystem, directory)) {
            Column column;
            String path = SyncPartitionMetadataProcedure.listedDirectoryName(directory, location);
            if (!SyncPartitionMetadataProcedure.isValidPartitionPath(path, column = partitionColumns.get(partitionColumns.size() - depth), caseSensitive)) continue;
            ImmutableList current = ImmutableList.builder().addAll(partitions).add((Object)path).build();
            result.addAll(SyncPartitionMetadataProcedure.doListPartitions(fileSystem, location, partitionColumns, depth - 1, caseSensitive, (List<String>)current));
        }
        return result.build();
    }

    private static Set<Location> listDirectories(TrinoFileSystem fileSystem, Location directory) {
        try {
            return fileSystem.listDirectories(directory);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static String listedDirectoryName(Location directory, Location location) {
        Object prefix = directory.path();
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        String path = location.path();
        Verify.verify((boolean)path.endsWith("/"), (String)"path does not end with slash: %s", (Object)location);
        Verify.verify((boolean)path.startsWith((String)prefix), (String)"path [%s] is not a child of directory [%s]", (Object)location, (Object)directory);
        return path.substring(((String)prefix).length(), path.length() - 1);
    }

    private static boolean isValidPartitionPath(String path, Column column, boolean caseSensitive) {
        if (!caseSensitive) {
            path = path.toLowerCase(Locale.ENGLISH);
        }
        return path.startsWith(column.getName() + "=");
    }

    private static void syncPartitions(Set<String> partitionsToAdd, Set<String> partitionsToDrop, SyncMode syncMode, SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.dropPartitions(metastore, session, table, partitionsToDrop);
        }
        if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.addPartitions(metastore, session, table, partitionsToAdd);
        }
        metastore.commit();
    }

    private static void addPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), SyncPartitionMetadataProcedure.buildPartitionObject(session, table, name), Location.of((String)table.getStorage().getLocation()).appendPath(name), Optional.empty(), PartitionStatistics.empty(), false);
        }
    }

    private static void dropPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), HivePartitionManager.extractPartitionValues(name), false);
        }
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionName)).setParameters((Map)ImmutableMap.of((Object)"trino_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(Location.of((String)table.getStorage().getLocation()).appendPath(partitionName).toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private static SyncMode toSyncMode(String mode) {
        try {
            return SyncMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Invalid partition metadata sync mode: " + mode);
        }
    }

    static {
        try {
            SYNC_PARTITION_METADATA = MethodHandles.lookup().unreflect(SyncPartitionMetadataProcedure.class.getMethod("syncPartitionMetadata", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, String.class, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum SyncMode {
        ADD,
        DROP,
        FULL;

    }
}

