/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.tpcds.TpcdsPlugin;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.SelectedRole;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.joda.time.DateTimeZone;

public final class HiveQueryRunner {
    private static final Logger log;
    public static final String HIVE_CATALOG = "hive";
    private static final String HIVE_BUCKETED_CATALOG = "hive_bucketed";
    public static final String TPCH_SCHEMA = "tpch";
    private static final String TPCH_BUCKETED_SCHEMA = "tpch_bucketed";
    private static final DateTimeZone TIME_ZONE;

    private HiveQueryRunner() {
    }

    public static QueryRunner create() throws Exception {
        return HiveQueryRunner.builder().build();
    }

    public static Builder<Builder<?>> builder() {
        return new Builder();
    }

    public static Builder<Builder<?>> builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private static Database createDatabaseMetastoreObject(String name, Optional<String> locationBase) {
        return Database.builder().setLocation(locationBase.map(base -> base + "/" + name)).setDatabaseName(name).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }

    private static Session createSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_CATALOG).setSchema(TPCH_SCHEMA).build();
    }

    public static Session createBucketedSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole, (Object)HIVE_BUCKETED_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_BUCKETED_CATALOG).setSchema(TPCH_BUCKETED_SCHEMA).build();
    }

    private static void copyTpchTablesBucketed(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables, ColumnNaming columnNaming) {
        for (TpchTable<?> table : tables) {
            HiveQueryRunner.copyTableBucketed(queryRunner, new QualifiedObjectName(sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH)), table, session, columnNaming);
        }
    }

    private static void copyTableBucketed(QueryRunner queryRunner, QualifiedObjectName tableName, TpchTable<?> table, Session session, ColumnNaming columnNaming) {
        long start = System.nanoTime();
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, switch (tableName.objectName()) {
            case "part", "partsupp", "supplier", "nation", "region" -> String.format("CREATE TABLE %s AS SELECT * FROM %s", tableName.objectName(), tableName);
            case "lineitem" -> String.format("CREATE TABLE %s WITH (bucketed_by=array['%s'], bucket_count=11) AS SELECT * FROM %s", tableName.objectName(), columnNaming.getName(table.getColumn("orderkey")), tableName);
            case "customer", "orders" -> String.format("CREATE TABLE %s WITH (bucketed_by=array['%s'], bucket_count=11) AS SELECT * FROM %s", tableName.objectName(), columnNaming.getName(table.getColumn("custkey")), tableName);
            default -> throw new UnsupportedOperationException();
        }).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows from %s in %s", new Object[]{rows, tableName, Duration.nanosSince((long)start)});
    }

    static {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.parquet.hadoop", Level.WARN);
        log = Logger.get(HiveQueryRunner.class);
        TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");
    }

    public static class Builder<SELF extends Builder<?>>
    extends DistributedQueryRunner.Builder<SELF> {
        private boolean skipTimezoneSetup;
        private ImmutableMap.Builder<String, String> hiveProperties = ImmutableMap.builder();
        private List<TpchTable<?>> initialTables = ImmutableList.of();
        private Optional<String> initialSchemasLocationBase = Optional.empty();
        private Optional<Function<DistributedQueryRunner, HiveMetastore>> metastore = Optional.empty();
        private boolean tpcdsCatalogEnabled;
        private boolean tpchBucketedCatalogEnabled;
        private boolean createTpchSchemas = true;
        private ColumnNaming tpchColumnNaming = ColumnNaming.SIMPLIFIED;
        private DecimalTypeMapping tpchDecimalTypeMapping = DecimalTypeMapping.DOUBLE;

        protected Builder() {
            this(HiveQueryRunner.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin")))));
        }

        protected Builder(Session defaultSession) {
            super(defaultSession);
        }

        @CanIgnoreReturnValue
        public SELF setSkipTimezoneSetup(boolean skipTimezoneSetup) {
            this.skipTimezoneSetup = skipTimezoneSetup;
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setHiveProperties(Map<String, String> hiveProperties) {
            this.hiveProperties = ImmutableMap.builder().putAll(Objects.requireNonNull(hiveProperties, "hiveProperties is null"));
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF addHiveProperty(String key, String value) {
            this.hiveProperties.put((Object)key, (Object)value);
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setInitialSchemasLocationBase(String initialSchemasLocationBase) {
            this.initialSchemasLocationBase = Optional.of(initialSchemasLocationBase);
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setMetastore(Function<DistributedQueryRunner, HiveMetastore> metastore) {
            this.metastore = Optional.of(metastore);
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setTpcdsCatalogEnabled(boolean tpcdsCatalogEnabled) {
            this.tpcdsCatalogEnabled = tpcdsCatalogEnabled;
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setTpchBucketedCatalogEnabled(boolean tpchBucketedCatalogEnabled) {
            this.tpchBucketedCatalogEnabled = tpchBucketedCatalogEnabled;
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setCreateTpchSchemas(boolean createTpchSchemas) {
            this.createTpchSchemas = createTpchSchemas;
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setTpchColumnNaming(ColumnNaming tpchColumnNaming) {
            this.tpchColumnNaming = Objects.requireNonNull(tpchColumnNaming, "tpchColumnNaming is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        @CanIgnoreReturnValue
        public SELF setTpchDecimalTypeMapping(DecimalTypeMapping tpchDecimalTypeMapping) {
            this.tpchDecimalTypeMapping = Objects.requireNonNull(tpchDecimalTypeMapping, "tpchDecimalTypeMapping is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                ImmutableMap tpchCatalogProperties = ImmutableMap.builder().put((Object)"tpch.column-naming", (Object)this.tpchColumnNaming.name()).put((Object)"tpch.double-type-mapping", (Object)this.tpchDecimalTypeMapping.name()).buildOrThrow();
                queryRunner.createCatalog(HiveQueryRunner.TPCH_SCHEMA, HiveQueryRunner.TPCH_SCHEMA, (Map)tpchCatalogProperties);
                if (this.tpcdsCatalogEnabled) {
                    queryRunner.installPlugin((Plugin)new TpcdsPlugin());
                    queryRunner.createCatalog("tpcds", "tpcds");
                }
                Optional<HiveMetastore> metastore = this.metastore.map(factory -> (HiveMetastore)factory.apply(queryRunner));
                Path dataDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data");
                if (metastore.isEmpty() && !this.hiveProperties.buildOrThrow().containsKey((Object)"hive.metastore")) {
                    this.hiveProperties.put((Object)"hive.metastore", (Object)"file");
                    this.hiveProperties.put((Object)"hive.metastore.catalog.dir", (Object)queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toString());
                }
                if (!this.hiveProperties.buildOrThrow().containsKey((Object)"fs.hadoop.enabled")) {
                    this.hiveProperties.put((Object)"fs.hadoop.enabled", (Object)"true");
                }
                queryRunner.installPlugin((Plugin)new TestingHivePlugin(dataDir, metastore));
                HashMap<String, String> hiveProperties = new HashMap<String, String>();
                if (!this.skipTimezoneSetup) {
                    ((ObjectAssert)Assertions.assertThat((Object)DateTimeZone.getDefault()).describedAs("Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments", new Object[0])).isEqualTo((Object)TIME_ZONE);
                    hiveProperties.put("hive.rcfile.time-zone", TIME_ZONE.getID());
                    hiveProperties.put("hive.parquet.time-zone", TIME_ZONE.getID());
                }
                hiveProperties.put("hive.max-partitions-per-scan", "1000");
                hiveProperties.put("hive.max-partitions-for-eager-load", "1000");
                hiveProperties.put("hive.security", "sql-standard");
                hiveProperties.putAll((Map<String, String>)this.hiveProperties.buildOrThrow());
                if (this.tpchBucketedCatalogEnabled) {
                    Object hiveBucketedProperties = ImmutableMap.builder().putAll(hiveProperties).put((Object)"hive.max-initial-split-size", (Object)"10kB").put((Object)"hive.max-split-size", (Object)"10kB").put((Object)"hive.storage-format", (Object)"TEXTFILE").buildOrThrow();
                    hiveBucketedProperties = new HashMap(hiveBucketedProperties);
                    hiveBucketedProperties.put("hive.compression-codec", "NONE");
                    queryRunner.createCatalog(HiveQueryRunner.HIVE_BUCKETED_CATALOG, HiveQueryRunner.HIVE_CATALOG, (Map)hiveBucketedProperties);
                }
                queryRunner.createCatalog(HiveQueryRunner.HIVE_CATALOG, HiveQueryRunner.HIVE_CATALOG, hiveProperties);
                if (this.createTpchSchemas) {
                    this.populateData((QueryRunner)queryRunner);
                }
                return queryRunner;
            }
            catch (Exception e) {
                queryRunner.close();
                throw e;
            }
        }

        private void populateData(QueryRunner queryRunner) {
            HiveMetastore metastore = TestingHiveUtils.getConnectorService(queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
            if (metastore.getDatabase(HiveQueryRunner.TPCH_SCHEMA).isEmpty()) {
                metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_SCHEMA, this.initialSchemasLocationBase));
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)HiveQueryRunner.TPCH_SCHEMA, (String)"tiny", this.initialTables);
            }
            if (this.tpchBucketedCatalogEnabled && metastore.getDatabase(HiveQueryRunner.TPCH_BUCKETED_SCHEMA).isEmpty()) {
                metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_BUCKETED_SCHEMA, this.initialSchemasLocationBase));
                Session session = HiveQueryRunner.createBucketedSession(Optional.empty());
                HiveQueryRunner.copyTpchTablesBucketed(queryRunner, HiveQueryRunner.TPCH_SCHEMA, "tiny", session, this.initialTables, this.tpchColumnNaming);
            }
        }
    }

    public static final class HiveGlueQueryRunnerMain {
        private HiveGlueQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            DistributedQueryRunner queryRunner = ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)HiveQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog(HiveQueryRunner.HIVE_CATALOG).setSchema(HiveQueryRunner.TPCH_SCHEMA).build()).addCoordinatorProperty("http-server.http.port", "8080")).addHiveProperty("hive.metastore", "glue"))).addHiveProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue"))).addHiveProperty("hive.security", "allow-all"))).setCreateTpchSchemas(false))).build();
            Logger log = Logger.get(HiveGlueQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class DefaultHiveQueryRunnerMain {
        public static void main(String[] args) throws Exception {
            Optional<Object> baseDataDir = Optional.empty();
            if (args.length > 0) {
                if (args.length != 1) {
                    System.err.println("usage: HiveQueryRunner [baseDataDir]");
                    System.exit(1);
                }
                Path path = Paths.get(args[0], new String[0]);
                Files.createDirectories(path, new FileAttribute[0]);
                baseDataDir = Optional.of(path);
            }
            DistributedQueryRunner queryRunner = ((Builder)((Object)((Builder)((Builder)((Object)((Builder)((Object)((Builder)HiveQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"allow-all")))).setSkipTimezoneSetup(true))).setInitialTables(TpchTable.getTables()).setBaseDataDir(baseDataDir)).setTpcdsCatalogEnabled(true))).build();
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }
}

