/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.hdfs.azure.HiveAzureConfig;
import io.trino.hdfs.azure.TrinoAzureConfigurationInitializer;
import io.trino.hdfs.gcs.GoogleGcsConfigurationInitializer;
import io.trino.hdfs.gcs.HiveGcsConfig;
import io.trino.hdfs.s3.HiveS3Config;
import io.trino.hdfs.s3.TrinoS3ConfigurationInitializer;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriterFactory;
import io.trino.plugin.hive.avro.AvroFileWriterFactory;
import io.trino.plugin.hive.avro.AvroPageSourceFactory;
import io.trino.plugin.hive.line.CsvFileWriterFactory;
import io.trino.plugin.hive.line.CsvPageSourceFactory;
import io.trino.plugin.hive.line.JsonFileWriterFactory;
import io.trino.plugin.hive.line.JsonPageSourceFactory;
import io.trino.plugin.hive.line.OpenXJsonFileWriterFactory;
import io.trino.plugin.hive.line.OpenXJsonPageSourceFactory;
import io.trino.plugin.hive.line.RegexFileWriterFactory;
import io.trino.plugin.hive.line.RegexPageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFileWriterFactory;
import io.trino.plugin.hive.line.SimpleTextFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleTextFileWriterFactory;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetFileWriterFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.block.ArrayValueBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hive.common.type.Date;

public final class HiveTestUtils {
    public static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(new HiveConfig());
    public static final Optional<HostAndPort> SOCKS_PROXY = Optional.ofNullable(System.getProperty("hive.metastore.thrift.client.socks-proxy")).map(HostAndPort::fromString);
    public static final DynamicHdfsConfiguration HDFS_CONFIGURATION = new DynamicHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig().setSocksProxy((HostAndPort)SOCKS_PROXY.orElse(null)), (Set)ImmutableSet.of((Object)new TrinoS3ConfigurationInitializer(new HiveS3Config()), (Object)new GoogleGcsConfigurationInitializer(new HiveGcsConfig()), (Object)new TrinoAzureConfigurationInitializer(new HiveAzureConfig()))), (Set)ImmutableSet.of());
    public static final HdfsEnvironment HDFS_ENVIRONMENT = new HdfsEnvironment((HdfsConfiguration)HDFS_CONFIGURATION, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
    public static final TrinoHdfsFileSystemStats HDFS_FILE_SYSTEM_STATS = new TrinoHdfsFileSystemStats();
    public static final HdfsFileSystemFactory HDFS_FILE_SYSTEM_FACTORY = new HdfsFileSystemFactory(HDFS_ENVIRONMENT, HDFS_FILE_SYSTEM_STATS);
    public static final PageSorter PAGE_SORTER = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));

    private HiveTestUtils() {
    }

    public static ConnectorSession getHiveSession(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSession(hiveConfig, new OrcReaderConfig());
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, orcReaderConfig).getSessionProperties()).build();
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, parquetWriterConfig).getSessionProperties()).build();
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSessionProperties(hiveConfig, new OrcReaderConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return new HiveSessionProperties(hiveConfig, orcReaderConfig, new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return new HiveSessionProperties(hiveConfig, new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), parquetWriterConfig);
    }

    public static Set<HivePageSourceFactory> getDefaultHivePageSourceFactories(HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig) {
        return HiveTestUtils.getDefaultHivePageSourceFactories((TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment, HDFS_FILE_SYSTEM_STATS), hiveConfig);
    }

    public static Set<HivePageSourceFactory> getDefaultHivePageSourceFactories(TrinoFileSystemFactory fileSystemFactory, HiveConfig hiveConfig) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        return ImmutableSet.builder().add((Object)new CsvPageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new JsonPageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new OpenXJsonPageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new RegexPageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new SimpleTextFilePageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new SimpleSequenceFilePageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new AvroPageSourceFactory(fileSystemFactory)).add((Object)new RcFilePageSourceFactory(fileSystemFactory, hiveConfig)).add((Object)new OrcPageSourceFactory(new OrcReaderConfig(), fileSystemFactory, stats, hiveConfig)).add((Object)new ParquetPageSourceFactory(fileSystemFactory, stats, new ParquetReaderConfig(), hiveConfig)).build();
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment) {
        return HiveTestUtils.getDefaultHiveFileWriterFactories(hiveConfig, (TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment, HDFS_FILE_SYSTEM_STATS));
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveConfig hiveConfig, TrinoFileSystemFactory fileSystemFactory) {
        NodeVersion nodeVersion = new NodeVersion("test_version");
        return ImmutableSet.builder().add((Object)new CsvFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new JsonFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new RegexFileWriterFactory()).add((Object)new OpenXJsonFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new SimpleTextFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new SimpleSequenceFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion)).add((Object)new AvroFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion)).add((Object)new RcFileFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion, hiveConfig)).add((Object)new OrcFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion, new FileFormatDataSourceStats(), new OrcWriterConfig())).add((Object)new ParquetFileWriterFactory(fileSystemFactory, nodeVersion, InternalTypeManager.TESTING_TYPE_MANAGER, hiveConfig, new FileFormatDataSourceStats())).build();
    }

    public static List<Type> getTypes(List<? extends ColumnHandle> columnHandles) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnHandle columnHandle : columnHandles) {
            types.add((Object)((HiveColumnHandle)columnHandle).getType());
        }
        return types.build();
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType.getTypeSignature())));
    }

    public static RowType rowType(List<NamedTypeSignature> elementTypeSignatures) {
        return (RowType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("row", (List)elementTypeSignatures.stream().map(TypeSignatureParameter::namedTypeParameter).collect(ImmutableList.toImmutableList()));
    }

    public static Object toNativeContainerValue(Type type, Object hiveValue) {
        if (hiveValue == null) {
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Collection hiveArray = (Collection)hiveValue;
            return ArrayValueBuilder.buildArrayValue((ArrayType)arrayType, (int)hiveArray.size(), valueBuilder -> {
                for (Object subElement : hiveArray) {
                    StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(0)), subElement, (BlockBuilder)valueBuilder);
                }
            });
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return RowValueBuilder.buildRowValue((RowType)rowType, fields -> {
                int fieldIndex = 0;
                for (Object subElement : (Iterable)hiveValue) {
                    StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(fieldIndex)), subElement, (BlockBuilder)((BlockBuilder)fields.get(fieldIndex)));
                    ++fieldIndex;
                }
            });
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Map hiveMap = (Map)hiveValue;
            return MapValueBuilder.buildMapValue((MapType)mapType, (int)hiveMap.size(), (keyBuilder, valueBuilder) -> hiveMap.forEach((key, value) -> {
                StructuralTestUtil.appendToBlockBuilder((Type)mapType.getKeyType(), (Object)key, (BlockBuilder)keyBuilder);
                StructuralTestUtil.appendToBlockBuilder((Type)mapType.getValueType(), (Object)value, (BlockBuilder)valueBuilder);
            }));
        }
        if (type instanceof BooleanType) {
            return hiveValue;
        }
        if (type instanceof TinyintType) {
            return (long)((Byte)hiveValue).byteValue();
        }
        if (type instanceof SmallintType) {
            return (long)((Short)hiveValue).shortValue();
        }
        if (type instanceof IntegerType) {
            return (long)((Integer)hiveValue).intValue();
        }
        if (type instanceof BigintType) {
            return hiveValue;
        }
        if (type instanceof RealType) {
            return (long)Float.floatToRawIntBits(((Float)hiveValue).floatValue());
        }
        if (type instanceof DoubleType) {
            return hiveValue;
        }
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)hiveValue.toString());
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((byte[])((byte[])hiveValue));
        }
        if (type instanceof UuidType) {
            return UuidType.javaUuidToTrinoUuid((UUID)HiveTestUtils.uuidFromBytes((byte[])hiveValue));
        }
        if (type instanceof DateType) {
            return (long)((Date)hiveValue).toEpochDay();
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    private static UUID uuidFromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }
}

