/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCloseIdleWriters
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder().setWorkerCount(0)).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.target-max-file-size", (Object)"100GB", (Object)"hive.idle-writer-min-file-size", (Object)"0.1MB")))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseIdleWriters() {
        String tableName = "task_close_idle_writers_" + TestingNames.randomNameSuffix();
        try {
            String createTableSql = "CREATE TABLE %s WITH (format = 'ORC', partitioned_by = ARRAY['shipmodeVal'])\nAS SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice,\ndiscount, tax, returnflag, linestatus, commitdate, receiptdate, shipinstruct,\ncomment, shipdate,\nCASE\n    WHEN shipmode IN ('AIR', 'FOB', 'SHIP', 'TRUCK') THEN 0\n    WHEN shipmode IN ('MAIL', 'RAIL', 'REG AIR') THEN 1\n    ELSE 2\nEND AS shipmodeVal\nFROM tpch.tiny.lineitem\nORDER BY shipmode\nLIMIT 60174\n".formatted(tableName);
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "false").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("task_max_writer_count", "1").setSystemProperty("task_min_writer_count", "1").setSystemProperty("idle_writer_min_data_size_threshold", "0.1MB").build(), createTableSql, 60174L);
            long files = (Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName);
            Assertions.assertThat((long)files).isGreaterThan(2L);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }
}

