/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.minio.MinioClient;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestHive3OnDataLake
extends AbstractTestQueryFramework {
    private static final String HIVE_TEST_SCHEMA = "hive_datalake";
    private static final DataSize HIVE_S3_STREAMING_PART_SIZE = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private String bucketName;
    private HiveMinioDataLake hiveMinioDataLake;
    private HiveMetastore metastoreClient;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "test-hive-insert-overwrite-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake(this.bucketName, HiveHadoop.HIVE3_IMAGE));
        this.hiveMinioDataLake.start();
        this.metastoreClient = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint()).build(x$0 -> this.closeAfterClass((AutoCloseable)x$0)));
        return ((S3HiveQueryRunner.Builder)((Object)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)S3HiveQueryRunner.builder(this.hiveMinioDataLake).addExtraProperty("sql.path", "hive.functions")).addExtraProperty("sql.default-function-catalog", "hive")).addExtraProperty("sql.default-function-schema", "functions")).setHiveProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.insert-existing-partitions-behavior", (Object)"OVERWRITE").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.metastore-cache-ttl", (Object)"1d").put((Object)"hive.metastore-refresh-interval", (Object)"1d").put((Object)"s3.streaming.part-size", (Object)HIVE_S3_STREAMING_PART_SIZE.toString()).put((Object)"hive.partition-projection-enabled", (Object)"true").buildOrThrow()))).build();
    }

    @BeforeAll
    public void setUp() {
        this.computeActual(String.format("CREATE SCHEMA hive.%1$s WITH (location='s3a://%2$s/%1$s')", HIVE_TEST_SCHEMA, this.bucketName));
        this.computeActual("CREATE SCHEMA hive.functions");
    }

    @Test
    public void testInsertOverwriteInTransaction() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']"));
        Assertions.assertThatThrownBy(() -> this.newTransaction().execute(this.getSession(), session -> this.getQueryRunner().execute(session, this.createInsertAsSelectFromTpchStatement(testTable)))).hasMessage("Overwriting existing partition in non auto commit context doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    @Test
    public void testInsertOverwriteNonPartitionedTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, new String[0]));
        this.assertInsertFailure(testTable, "Overwriting unpartitioned table not supported when writing directly to target directory");
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    @Test
    public void testInsertOverwriteNonPartitionedBucketedTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "bucketed_by = ARRAY['nationkey']", "bucket_count = 3"));
        this.assertInsertFailure(testTable, "Overwriting unpartitioned table not supported when writing directly to target directory");
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    @Test
    public void testInsertOverwritePartitionedTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']"));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(testTable);
    }

    @Test
    public void testInsertOverwritePartitionedAndBucketedTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3"));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(testTable);
    }

    @Test
    public void testInsertOverwritePartitionedAndBucketedExternalTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3"));
        this.copyTpchNationToTable(testTable);
        String externalTableName = testTable + "_ext";
        this.computeActual(this.getCreateTableStatement(externalTableName, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3", String.format("external_location = 's3a://%s/%s/%s/'", this.bucketName, HIVE_TEST_SCHEMA, testTable)));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(externalTableName);
    }

    @Test
    public void testSyncPartitionOnBucketRoot() {
        String tableName = "test_sync_partition_on_bucket_root_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "hello\u0001world\nbye\u0001world".getBytes(StandardCharsets.UTF_8), "part_key=part_val/data.txt");
        this.assertUpdate("CREATE TABLE " + fullyQualifiedTestTableName + "( a varchar, b varchar, part_key varchar)WITH ( external_location='s3://" + this.bucketName + "/', partitioned_by=ARRAY['part_key'], format='TEXTFILE')");
        this.getQueryRunner().execute("CALL system.sync_partition_metadata(schema_name => 'hive_datalake', table_name => '" + tableName + "', mode => 'ADD')");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES ('hello', 'world', 'part_val'), ('bye', 'world', 'part_val')");
        this.assertUpdate("DROP TABLE " + fullyQualifiedTestTableName);
    }

    @Test
    public void testSyncPartitionCaseSensitivePathVariation() {
        String tableName = "test_sync_partition_case_variation_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        String tableLocation = String.format("s3://%s/%s/%s/", this.bucketName, HIVE_TEST_SCHEMA, tableName);
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=part_val/data.txt");
        this.assertUpdate("CREATE TABLE " + fullyQualifiedTestTableName + "( a varchar, b varchar, part_key varchar)WITH ( external_location='" + tableLocation + "', partitioned_by=ARRAY['part_key'], format='TEXTFILE')");
        this.getQueryRunner().execute("CALL system.sync_partition_metadata(schema_name => 'hive_datalake', table_name => '" + tableName + "', mode => 'ADD')");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES ('Trino', 'rocks', 'part_val')");
        this.hiveMinioDataLake.getMinioClient().removeObject(this.bucketName, "hive_datalake/" + tableName + "/part_key=part_val/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/PART_KEY=part_val/data.txt");
        this.getQueryRunner().execute("CALL system.sync_partition_metadata(schema_name => 'hive_datalake', table_name => '" + tableName + "', mode => 'FULL', case_sensitive => false)");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES ('Trino', 'rocks', 'part_val')");
        this.getQueryRunner().execute("CALL system.sync_partition_metadata(schema_name => 'hive_datalake', table_name => '" + tableName + "', mode => 'FULL', case_sensitive => false)");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES ('Trino', 'rocks', 'part_val')");
        this.assertUpdate("DROP TABLE " + fullyQualifiedTestTableName);
    }

    @Test
    public void testSyncPartitionSpecialCharacters() {
        String tableName = "test_sync_partition_special_characters_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        String tableLocation = String.format("s3://%s/%s/%s/", this.bucketName, HIVE_TEST_SCHEMA, tableName);
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001hyphens".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with-hyphen/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001dots".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with.dot/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001colons".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with%3Acolon/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001slashes".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with%2Fslash/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001backslashes".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with%5Cbackslash/data.txt");
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, "Trino\u0001rocks\u0001percents".getBytes(StandardCharsets.UTF_8), "hive_datalake/" + tableName + "/part_key=with%25percent/data.txt");
        this.assertUpdate("CREATE TABLE " + fullyQualifiedTestTableName + "( a varchar, b varchar, c varchar, part_key varchar)WITH ( external_location='" + tableLocation + "', partitioned_by=ARRAY['part_key'], format='TEXTFILE')");
        this.getQueryRunner().execute("CALL system.sync_partition_metadata(schema_name => 'hive_datalake', table_name => '" + tableName + "', mode => 'ADD')");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES\n        ('Trino', 'rocks', 'hyphens', 'with-hyphen'),\n        ('Trino', 'rocks', 'dots', 'with.dot'),\n        ('Trino', 'rocks', 'colons', 'with:colon'),\n        ('Trino', 'rocks', 'slashes', 'with/slash'),\n        ('Trino', 'rocks', 'backslashes', 'with\\backslash'),\n        ('Trino', 'rocks', 'percents', 'with%percent')\n");
        this.assertUpdate("DROP TABLE " + fullyQualifiedTestTableName);
    }

    @Test
    public void testFlushPartitionCache() {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        String partitionColumn = "regionkey";
        this.testFlushPartitionCache(tableName, fullyQualifiedTestTableName, partitionColumn, String.format("CALL system.flush_metadata_cache(schema_name => '%s', table_name => '%s', partition_columns => ARRAY['%s'], partition_values => ARRAY['0'])", HIVE_TEST_SCHEMA, tableName, partitionColumn));
    }

    private void testFlushPartitionCache(String tableName, String fullyQualifiedTestTableName, String partitionColumn, String flushCacheProcedureSql) {
        this.computeActual(this.getCreateTableStatement(fullyQualifiedTestTableName, String.format("partitioned_by=ARRAY['%s']", partitionColumn)));
        this.copyTpchNationToTable(fullyQualifiedTestTableName);
        String queryUsingPartitionCacheTemplate = "SELECT name FROM %s WHERE %s=%s";
        String partitionValue1 = "0";
        String queryUsingPartitionCacheForValue1 = String.format(queryUsingPartitionCacheTemplate, fullyQualifiedTestTableName, partitionColumn, partitionValue1);
        String expectedQueryResultForValue1 = "VALUES 'ALGERIA', 'MOROCCO', 'MOZAMBIQUE', 'ETHIOPIA', 'KENYA'";
        String partitionValue2 = "1";
        String queryUsingPartitionCacheForValue2 = String.format(queryUsingPartitionCacheTemplate, fullyQualifiedTestTableName, partitionColumn, partitionValue2);
        String expectedQueryResultForValue2 = "VALUES 'ARGENTINA', 'BRAZIL', 'CANADA', 'PERU', 'UNITED STATES'";
        this.assertQuery(queryUsingPartitionCacheForValue1, expectedQueryResultForValue1);
        this.assertQuery(queryUsingPartitionCacheForValue2, expectedQueryResultForValue2);
        this.renamePartitionResourcesOutsideTrino(tableName, partitionColumn, partitionValue1);
        this.renamePartitionResourcesOutsideTrino(tableName, partitionColumn, partitionValue2);
        this.assertQueryReturnsEmptyResult(queryUsingPartitionCacheForValue1);
        this.assertQueryReturnsEmptyResult(queryUsingPartitionCacheForValue2);
        this.getQueryRunner().execute(flushCacheProcedureSql);
        this.assertQuery(queryUsingPartitionCacheForValue1, expectedQueryResultForValue1);
        this.assertQueryReturnsEmptyResult(queryUsingPartitionCacheForValue2);
        this.getQueryRunner().execute(String.format("CALL system.flush_metadata_cache(schema_name => '%s', table_name => '%s')", HIVE_TEST_SCHEMA, tableName));
        this.assertQuery(queryUsingPartitionCacheForValue1, expectedQueryResultForValue1);
        this.assertQuery(queryUsingPartitionCacheForValue2, expectedQueryResultForValue2);
        this.computeActual(String.format("DROP TABLE %s", fullyQualifiedTestTableName));
    }

    @Test
    public void testWriteDifferentSizes() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(String.format("CREATE TABLE %s (    col1 varchar,     col2 varchar,     regionkey bigint)     WITH (partitioned_by=ARRAY['regionkey'])", testTable));
        long partSizeInBytes = HIVE_S3_STREAMING_PART_SIZE.toBytes();
        this.testWriteWithFileSize(testTable, 50, 0L, partSizeInBytes);
        this.testWriteWithFileSize(testTable, 100, partSizeInBytes + 1L, partSizeInBytes * 2L);
        this.testWriteWithFileSize(testTable, 150, partSizeInBytes * 2L + 1L, partSizeInBytes * 3L);
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    @Test
    public void testEnumPartitionProjectionOnVarcharColumnWithWhitespace() {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (  name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   \"short name\" varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   )) WITH (   partitioned_by=ARRAY['short name'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short name\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short name\\.values[ |]+PL1,CZ1[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL2'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ2'"))));
        this.assertQuery(String.format("SELECT * FROM %s", this.getFullyQualifiedTestTableName("\"" + tableName + "$partitions\"")), "VALUES 'PL1', 'CZ1'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE \"short name\"='PL1'", fullyQualifiedTestTableName), "VALUES 'POLAND_1'");
        this.assertQueryReturnsEmptyResult(String.format("SELECT name FROM %s WHERE \"short name\"='PL2'", fullyQualifiedTestTableName));
        this.assertQuery(String.format("SELECT name FROM %s WHERE \"short name\"='PL1' OR \"short name\"='CZ1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('CZECH_1')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE \"short name\"='PL1' OR \"short name\"='CZ2'", fullyQualifiedTestTableName), "VALUES ('POLAND_1')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('CZECH_1')");
    }

    @Test
    public void testEnumPartitionProjectionOnVarcharColumnWithStorageLocationTemplateCreatedOnTrino() {
        String schemaName = "Hive_Datalake_MixedCase";
        String tableName = this.getRandomTestTableName();
        this.computeActual("CREATE SCHEMA hive.%1$s WITH (location='s3a://%2$s/%1$s')".formatted(schemaName, this.bucketName));
        String storageFormat = String.format("s3a://%s/%s/%s/short_name1=${short_name1}/short_name2=${short_name2}/", this.bucketName, schemaName, tableName);
        this.computeActual("CREATE TABLE " + this.getFullyQualifiedTestTableName(schemaName, tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL2', 'CZ2']   )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true,   partition_projection_location_template='" + storageFormat + "' )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(schemaName, tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)("[ |]+storage\\.location\\.template[ |]+" + Pattern.quote(storageFormat) + "[ |]+"))).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.values[ |]+PL2,CZ2[ |]+");
        this.testEnumPartitionProjectionOnVarcharColumnWithStorageLocationTemplate(schemaName, tableName);
    }

    @Test
    public void testEnumPartitionProjectionOnVarcharColumnWithStorageLocationTemplateCreatedOnHive() {
        String tableName = this.getRandomTestTableName();
        String storageFormat = String.format("'s3a://%s/%s/%s/short_name1=${short_name1}/short_name2=${short_name2}/'", this.bucketName, HIVE_TEST_SCHEMA, tableName);
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE TABLE " + this.getHiveTestTableName(tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint ) PARTITIONED BY (  short_name1 varchar(152),   short_name2 varchar(152)) TBLPROPERTIES (   'projection.enabled'='true',   'storage.location.template'=" + storageFormat + ",   'projection.short_name1.type'='enum',   'projection.short_name1.values'='PL1,CZ1',   'projection.short_name2.type'='enum',   'projection.short_name2.values'='PL2,CZ2' )");
        this.testEnumPartitionProjectionOnVarcharColumnWithStorageLocationTemplate(HIVE_TEST_SCHEMA, tableName);
    }

    private void testEnumPartitionProjectionOnVarcharColumnWithStorageLocationTemplate(String schemaName, String tableName) {
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(schemaName, tableName);
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'PL2'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'CZ2'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'PL2'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'CZ2'"))));
        this.assertQuery(String.format("SELECT * FROM %s", this.getFullyQualifiedTestTableName(schemaName, "\"" + tableName + "$partitions\"")), "VALUES ('PL1','PL2'), ('PL1','CZ2'), ('CZ1','PL2'), ('CZ1','CZ2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='CZ2'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testEnumPartitionProjectionOnVarcharColumn() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL2', 'CZ2']  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.values[ |]+PL2,CZ2[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'PL2'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'CZ2'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'PL2'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'CZ2'"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='CZ2'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='CZ2' OR short_name2='PL2' )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testIntegerPartitionProjectionOnVarcharColumnWithDigitsAlignCreatedOnTrino() {
        String tableName = this.getRandomTestTableName();
        this.computeActual("CREATE TABLE " + this.getFullyQualifiedTestTableName(tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar(152) WITH (    partition_projection_type='integer',     partition_projection_range=ARRAY['1', '4'],     partition_projection_digits=3  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+integer[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+1,4[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.digits[ |]+3[ |]+");
        this.testIntegerPartitionProjectionOnVarcharColumnWithDigitsAlign(tableName);
    }

    @Test
    public void testIntegerPartitionProjectionOnVarcharColumnWithDigitsAlignCreatedOnHive() {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE TABLE " + this.getHiveTestTableName(tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint ) PARTITIONED BY (   short_name1 varchar(152),   short_name2 varchar(152)) TBLPROPERTIES (   'projection.enabled'='true',   'projection.short_name1.type'='enum',   'projection.short_name1.values'='PL1,CZ1',   'projection.short_name2.type'='integer',   'projection.short_name2.range'='1,4',   'projection.short_name2.digits'='3')");
        this.testIntegerPartitionProjectionOnVarcharColumnWithDigitsAlign(tableName);
    }

    private void testIntegerPartitionProjectionOnVarcharColumnWithDigitsAlign(String tableName) {
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'001'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'002'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'003'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'004'"))));
        this.assertQuery(String.format("SELECT * FROM %s", this.getFullyQualifiedTestTableName("\"" + tableName + "$partitions\"")), "VALUES ('PL1','001'), ('PL1','002'), ('PL1','003'), ('PL1','004'),('CZ1','001'), ('CZ1','002'), ('CZ1','003'), ('CZ1','004')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='002'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='002' OR short_name2='001' )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testIntegerPartitionProjectionOnIntegerColumnWithInterval() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 integer WITH (    partition_projection_type='integer',     partition_projection_range=ARRAY['0', '10'],     partition_projection_interval=3  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+integer[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+0,10[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval[ |]+3[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"0"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"3"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"6"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"9"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2=3", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2=3 OR short_name2=0 )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testIntegerPartitionProjectionOnIntegerColumnWithDefaults() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 integer WITH (    partition_projection_type='integer',     partition_projection_range=ARRAY['1', '4']  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+integer[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+1,4[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"1"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"2"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"3"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"4"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2=2", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2=2 OR short_name2=1 )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnDateColumnWithDefaults() {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 date WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['2001-1-22', '2001-1-25']  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+date[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.format[ |]+yyyy-MM-dd[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+2001-1-22,2001-1-25[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"DATE '2001-1-22'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"DATE '2001-1-23'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"DATE '2001-1-24'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"DATE '2001-1-25'"), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)"DATE '2001-1-26'"))));
        this.assertQuery(String.format("SELECT * FROM %s", this.getFullyQualifiedTestTableName("\"" + tableName + "$partitions\"")), "VALUES ('PL1','2001-1-22'), ('PL1','2001-1-23'), ('PL1','2001-1-24'), ('PL1','2001-1-25'),('CZ1','2001-1-22'), ('CZ1','2001-1-23'), ('CZ1','2001-1-24'), ('CZ1','2001-1-25')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2=(DATE '2001-1-23')", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2=(DATE '2001-1-23') OR short_name2=(DATE '2001-1-22') )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > DATE '2001-1-23'", fullyQualifiedTestTableName), "VALUES ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 >= DATE '2001-1-23' AND short_name2 <= DATE '2001-1-25'", fullyQualifiedTestTableName), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnTimestampColumnWithInterval() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 timestamp WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd HH:mm:ss',     partition_projection_range=ARRAY['2001-1-22 00:00:00', '2001-1-22 00:00:06'],     partition_projection_interval=2,     partition_projection_interval_unit='SECONDS'  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+date[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.format[ |]+yyyy-MM-dd HH:mm:ss[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+2001-1-22 00:00:00,2001-1-22 00:00:06[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval[ |]+2[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval\\.unit[ |]+seconds[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"TIMESTAMP '2001-1-22 00:00:00'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"TIMESTAMP '2001-1-22 00:00:02'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"TIMESTAMP '2001-1-22 00:00:04'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"TIMESTAMP '2001-1-22 00:00:06'"), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)"TIMESTAMP '2001-1-22 00:00:08'"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2=(TIMESTAMP '2001-1-22 00:00:02')", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2=(TIMESTAMP '2001-1-22 00:00:00') OR short_name2=(TIMESTAMP '2001-1-22 00:00:02') )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > TIMESTAMP '2001-1-22 00:00:02'", fullyQualifiedTestTableName), "VALUES ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 >= TIMESTAMP '2001-1-22 00:00:02' AND short_name2 <= TIMESTAMP '2001-1-22 00:00:06'", fullyQualifiedTestTableName), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnTimestampColumnWithIntervalExpressionCreatedOnTrino() {
        String tableName = this.getRandomTestTableName();
        String dateProjectionFormat = "yyyy-MM-dd HH:mm:ss";
        this.computeActual("CREATE TABLE " + this.getFullyQualifiedTestTableName(tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 timestamp WITH (    partition_projection_type='date',     partition_projection_format='" + dateProjectionFormat + "',     partition_projection_range=ARRAY['NOW-5MINUTES', 'NOW'],     partition_projection_interval=1,     partition_projection_interval_unit='SECONDS'  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)("[ |]+projection\\.short_name2\\.format[ |]+" + Pattern.quote(dateProjectionFormat) + "[ |]+"))).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+NOW-5MINUTES,NOW[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval[ |]+1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval\\.unit[ |]+seconds[ |]+");
        this.testDatePartitionProjectionOnTimestampColumnWithIntervalExpression(tableName, dateProjectionFormat);
    }

    @Test
    public void testDatePartitionProjectionOnTimestampColumnWithIntervalExpressionCreatedOnHive() {
        String tableName = this.getRandomTestTableName();
        String dateProjectionFormat = "yyyy-MM-dd HH:mm:ss";
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE TABLE " + this.getHiveTestTableName(tableName) + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint ) PARTITIONED BY (  short_name1 varchar(152),   short_name2 timestamp ) TBLPROPERTIES (   'projection.enabled'='true',   'projection.short_name1.type'='enum',   'projection.short_name1.values'='PL1,CZ1',   'projection.short_name2.type'='date',   'projection.short_name2.format'='" + dateProjectionFormat + "',   'projection.short_name2.range'='NOW-5MINUTES,NOW',   'projection.short_name2.interval'='1',   'projection.short_name2.interval.unit'='SECONDS')");
        this.testDatePartitionProjectionOnTimestampColumnWithIntervalExpression(tableName, dateProjectionFormat);
    }

    private void testDatePartitionProjectionOnTimestampColumnWithIntervalExpression(String tableName, String dateProjectionFormat) {
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        Instant dayToday = Instant.now();
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateProjectionFormat);
        dateFormat.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        String minutesNowFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.MINUTES, 0);
        String minutes1AgoFormatter = this.moveDate(dateFormat, dayToday, ChronoUnit.MINUTES, -1);
        String minutes2AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.MINUTES, -2);
        String minutes3AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.MINUTES, -3);
        String minutes4AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.MINUTES, -4);
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)("TIMESTAMP '" + minutesNowFormatted + "'")), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)("TIMESTAMP '" + minutes1AgoFormatter + "'")), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)("TIMESTAMP '" + minutes2AgoFormatted + "'")), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)("TIMESTAMP '" + minutes3AgoFormatted + "'")), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)("TIMESTAMP '" + minutes4AgoFormatted + "'")))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > ( TIMESTAMP '%s' ) AND short_name2 <= ( TIMESTAMP '%s' )", fullyQualifiedTestTableName, minutes4AgoFormatted, minutes1AgoFormatter), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnVarcharColumnWithHoursInterval() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd HH',     partition_projection_range=ARRAY['2001-01-22 00', '2001-01-22 06'],     partition_projection_interval=2,     partition_projection_interval_unit='HOURS'  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+date[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.format[ |]+yyyy-MM-dd HH[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+2001-01-22 00,2001-01-22 06[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval[ |]+2[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval\\.unit[ |]+hours[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'2001-01-22 00'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'2001-01-22 02'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-22 04'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-22 06'"), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-22 08'"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='2001-01-22 02'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='2001-01-22 00' OR short_name2='2001-01-22 02' )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > '2001-01-22 02'", fullyQualifiedTestTableName), "VALUES ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 >= '2001-01-22 02' AND short_name2 <= '2001-01-22 06'", fullyQualifiedTestTableName), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnVarcharColumnWithDaysInterval() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['2001-01-01', '2001-01-07'],     partition_projection_interval=2,     partition_projection_interval_unit='DAYS'  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+date[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.format[ |]+yyyy-MM-dd[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+2001-01-01,2001-01-07[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval[ |]+2[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.interval\\.unit[ |]+days[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'2001-01-01'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'2001-01-03'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-05'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-07'"), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)"'2001-01-09'"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='2001-01-03'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='2001-01-01' OR short_name2='2001-01-03' )", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > '2001-01-03'", fullyQualifiedTestTableName), "VALUES ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 >= '2001-01-03' AND short_name2 <= '2001-01-07'", fullyQualifiedTestTableName), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    @Test
    public void testDatePartitionProjectionOnVarcharColumnWithIntervalExpression() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        String dateProjectionFormat = "yyyy-MM-dd";
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar WITH (    partition_projection_type='date',     partition_projection_format='" + dateProjectionFormat + "',     partition_projection_range=ARRAY['NOW-3DAYS', 'NOW']  )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+date[ |]+")).containsPattern((CharSequence)("[ |]+projection\\.short_name2\\.format[ |]+" + Pattern.quote(dateProjectionFormat) + "[ |]+"))).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.range[ |]+NOW-3DAYS,NOW[ |]+");
        Instant dayToday = Instant.now();
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateProjectionFormat);
        dateFormat.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        String dayTodayFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.DAYS, 0);
        String day1AgoFormatter = this.moveDate(dateFormat, dayToday, ChronoUnit.DAYS, -1);
        String day2AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.DAYS, -2);
        String day3AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.DAYS, -3);
        String day4AgoFormatted = this.moveDate(dateFormat, dayToday, ChronoUnit.DAYS, -4);
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)("'" + dayTodayFormatted + "'")), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)("'" + day1AgoFormatter + "'")), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)("'" + day2AgoFormatted + "'")), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)("'" + day3AgoFormatted + "'")), (Object)ImmutableList.of((Object)"'CZECH_3'", (Object)"'Comment'", (Object)"4", (Object)"5", (Object)"'CZ1'", (Object)("'" + day4AgoFormatted + "'")))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='%s'", fullyQualifiedTestTableName, day1AgoFormatter), "VALUES 'POLAND_2'");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='%s' OR short_name2='%s' )", fullyQualifiedTestTableName, dayTodayFormatted, day1AgoFormatter), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 > '%s'", fullyQualifiedTestTableName, day2AgoFormatted), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name2 >= '%s' AND short_name2 <= '%s'", fullyQualifiedTestTableName, day4AgoFormatted, day1AgoFormatter), "VALUES ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2')");
        this.assertQuery(String.format("SELECT name FROM %s", fullyQualifiedTestTableName), "VALUES ('POLAND_1'), ('POLAND_2'), ('CZECH_1'), ('CZECH_2')");
    }

    private String moveDate(DateFormat format, Instant today, TemporalUnit unit, int move) {
        return format.format(new Date(today.plus((long)move, unit).toEpochMilli()));
    }

    @Test
    public void testDatePartitionProjectionFormatTextWillNotCauseIntervalRequirement() {
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName();
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='''start''yyyy-MM-dd''end''''s''',     partition_projection_range=ARRAY['start2001-01-01end''s', 'start2001-01-07end''s']   )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )");
    }

    @Test
    public void testInjectedPartitionProjectionOnVarcharColumn() {
        String tableName = this.getRandomTestTableName();
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.computeActual("CREATE TABLE " + fullyQualifiedTestTableName + " (   name varchar(25),   comment varchar(152),   nationkey bigint,   regionkey bigint,   short_name1 varchar(152) WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']    ),   short_name2 varchar(152) WITH (    partition_projection_type='injected'   ) ) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.hiveMinioDataLake.getHiveHadoop().runOnHive("SHOW TBLPROPERTIES " + this.getHiveTestTableName(tableName))).containsPattern((CharSequence)"[ |]+projection\\.enabled[ |]+true[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.type[ |]+enum[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name1\\.values[ |]+PL1,CZ1[ |]+")).containsPattern((CharSequence)"[ |]+projection\\.short_name2\\.type[ |]+injected[ |]+");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'Comment'", (Object)"0", (Object)"5", (Object)"'PL1'", (Object)"'001'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'Comment'", (Object)"1", (Object)"5", (Object)"'PL1'", (Object)"'002'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'Comment'", (Object)"2", (Object)"5", (Object)"'CZ1'", (Object)"'003'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'Comment'", (Object)"3", (Object)"5", (Object)"'CZ1'", (Object)"'004'"))));
        this.assertQuery(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND short_name2='002'", fullyQualifiedTestTableName), "VALUES 'POLAND_2'");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(String.format("SELECT name FROM %s WHERE short_name1='PL1' AND ( short_name2='002' OR short_name2='001' )", fullyQualifiedTestTableName))).hasMessage("Column projection for column 'short_name2' failed. Injected projection requires single predicate for it's column in where clause. Currently provided can't be converted to single partition.");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(String.format("SELECT name FROM %s", fullyQualifiedTestTableName))).hasMessage("Column projection for column 'short_name2' failed. Injected projection requires single predicate for it's column in where clause");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(String.format("SELECT name FROM %s WHERE short_name1='PL1'", fullyQualifiedTestTableName))).hasMessage("Column projection for column 'short_name2' failed. Injected projection requires single predicate for it's column in where clause");
    }

    @Test
    public void testPartitionProjectionInvalidTableProperties() {
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar ) WITH (   partition_projection_enabled=true )")).hasMessage("Partition projection cannot be enabled on a table that is not partitioned");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar WITH (     partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']  ),   short_name1 varchar ) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Partition projection cannot be defined for non-partition column: 'name'");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (     partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']  ),   short_name2 varchar ) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name2' failed. Projection type property missing");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   ),   short_name2 varchar WITH (    partition_projection_type='injected'   )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true,   partition_projection_location_template='s3a://dummy/short_name1=${short_name1}/')")).hasMessage("Partition projection location template: s3a://dummy/short_name1=${short_name1}/ is missing partition column: 'short_name2' placeholder");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='integer',     partition_projection_range=ARRAY['1', '2', '3']   ),   short_name2 varchar WITH (    partition_projection_type='enum',     partition_projection_values=ARRAY['PL1', 'CZ1']   )) WITH (   partitioned_by=ARRAY['short_name1', 'short_name2'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_range' needs to be list of 2 integers");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_values=ARRAY['2001-01-01', '2001-01-02']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Missing required property: 'partition_projection_format'");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd HH',     partition_projection_range=ARRAY['2001-01-01', '2001-01-02']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_range' needs to be a list of 2 valid dates formatted as 'yyyy-MM-dd HH' or '^\\s*NOW\\s*(([+-])\\s*([0-9]+)\\s*(DAY|HOUR|MINUTE|SECOND)S?\\s*)?$' that are sequential: Unparseable date: \"2001-01-01\"");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['NOW*3DAYS', '2001-01-02']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_range' needs to be a list of 2 valid dates formatted as 'yyyy-MM-dd' or '^\\s*NOW\\s*(([+-])\\s*([0-9]+)\\s*(DAY|HOUR|MINUTE|SECOND)S?\\s*)?$' that are sequential: Unparseable date: \"NOW*3DAYS\"");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['2001-01-02', '2001-01-01']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_range' needs to be a list of 2 valid dates formatted as 'yyyy-MM-dd' or '^\\s*NOW\\s*(([+-])\\s*([0-9]+)\\s*(DAY|HOUR|MINUTE|SECOND)S?\\s*)?$' that are sequential");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['2001-01-01', '2001-01-02'],     partition_projection_interval_unit='Decades'  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_interval_unit' value 'Decades' is invalid. Available options: [Days, Hours, Minutes, Seconds]");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd HH',     partition_projection_range=ARRAY['2001-01-01 10', '2001-01-02 10']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_interval_unit' needs to be set when provided 'partition_projection_format' is less that single-day precision. Interval defaults to 1 day or 1 month, respectively. Otherwise, interval is required");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd',     partition_projection_range=ARRAY['2001-01-01 10', '2001-01-02 10']  )) WITH (   partitioned_by=ARRAY['short_name1'] )")).hasMessage("Columns partition projection properties cannot be set when 'partition_projection_enabled' is not set");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("CREATE TABLE " + this.getFullyQualifiedTestTableName("nation_" + TestingNames.randomNameSuffix()) + " (   name varchar,   short_name1 varchar WITH (    partition_projection_type='date',     partition_projection_format='yyyy-MM-dd HH',     partition_projection_range=ARRAY['2001-01-01 10', '2001-01-02 10']  )) WITH (   partitioned_by=ARRAY['short_name1'],   partition_projection_enabled=true,   partition_projection_ignore=true )")).hasMessage("Column projection for column 'short_name1' failed. Property: 'partition_projection_interval_unit' needs to be set when provided 'partition_projection_format' is less that single-day precision. Interval defaults to 1 day or 1 month, respectively. Otherwise, interval is required");
    }

    @Test
    public void testPartitionProjectionIgnore() {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        String hiveTestTableName = this.getHiveTestTableName(tableName);
        String fullyQualifiedTestTableName = this.getFullyQualifiedTestTableName(tableName);
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE TABLE " + hiveTestTableName + " (   name varchar(25) ) PARTITIONED BY (  date_time varchar(152) ) TBLPROPERTIES (   'projection.enabled'='true',   'projection.date_time.type'='date',   'projection.date_time.format'='yyyy-MM-dd HH',   'projection.date_time.range'='2001-01-01,2001-01-02' )");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("SELECT * FROM " + fullyQualifiedTestTableName)).hasMessage("Column projection for column 'date_time' failed. Property: 'partition_projection_range' needs to be a list of 2 valid dates formatted as 'yyyy-MM-dd HH' or '^\\s*NOW\\s*(([+-])\\s*([0-9]+)\\s*(DAY|HOUR|MINUTE|SECOND)S?\\s*)?$' that are sequential: Unparseable date: \"2001-01-01\"");
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("ALTER TABLE " + hiveTestTableName + " SET TBLPROPERTIES ( 'trino.partition_projection.ignore'='TRUE' )");
        this.computeActual("CALL system.flush_metadata_cache(schema_name => 'hive_datalake', table_name => '" + tableName + "')");
        this.computeActual(this.createInsertStatement(fullyQualifiedTestTableName, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND_1'", (Object)"'2022-02-01 12'"), (Object)ImmutableList.of((Object)"'POLAND_2'", (Object)"'2022-02-01 12'"), (Object)ImmutableList.of((Object)"'CZECH_1'", (Object)"'2022-02-01 13'"), (Object)ImmutableList.of((Object)"'CZECH_2'", (Object)"'2022-02-01 13'"))));
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName, "VALUES ('POLAND_1', '2022-02-01 12'), ('POLAND_2', '2022-02-01 12'), ('CZECH_1', '2022-02-01 13'), ('CZECH_2', '2022-02-01 13')");
        this.assertQuery("SELECT * FROM " + fullyQualifiedTestTableName + " WHERE date_time = '2022-02-01 12'", "VALUES ('POLAND_1', '2022-02-01 12'), ('POLAND_2', '2022-02-01 12')");
    }

    @Test
    public void testAnalyzePartitionedTableWithCanonicalization() {
        String tableName = "test_analyze_table_canonicalization_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (a_varchar varchar, month varchar) WITH (partitioned_by = ARRAY['month'])".formatted(this.getFullyQualifiedTestTableName(tableName)));
        this.assertUpdate("INSERT INTO " + this.getFullyQualifiedTestTableName(tableName) + " VALUES ('A', '01'), ('B', '01'), ('C', '02'), ('D', '03')", 4L);
        String tableLocation = (String)this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*/[^/]*$', '') FROM " + this.getFullyQualifiedTestTableName(tableName)).getOnlyValue();
        String externalTableName = "external_" + tableName;
        List<String> partitionColumnNames = List.of("month");
        this.assertUpdate("CREATE TABLE %s(\n  a_varchar varchar,\n  month integer)\nWITH (\n   partitioned_by = ARRAY['month'],\n   external_location='%s')\n".formatted(this.getFullyQualifiedTestTableName(externalTableName), tableLocation));
        this.addPartitions(tableName, externalTableName, partitionColumnNames, (TupleDomain<String>)TupleDomain.all());
        this.assertQuery("SELECT * FROM hive_datalake.\"" + externalTableName + "$partitions\"", "VALUES 1, 2, 3");
        this.assertUpdate("ANALYZE " + this.getFullyQualifiedTestTableName(externalTableName), 4L);
        this.assertQuery("SHOW STATS FOR " + this.getFullyQualifiedTestTableName(externalTableName), "VALUES\n    ('a_varchar', 4.0, 2.0, 0.0, null, null, null),\n    ('month', null, 3.0, 0.0, null, 1, 3),\n    (null, null, null, null, 4.0, null, null)\n");
        this.assertUpdate("INSERT INTO " + this.getFullyQualifiedTestTableName(tableName) + " VALUES ('E', '04')", 1L);
        this.addPartitions(tableName, externalTableName, partitionColumnNames, (TupleDomain<String>)TupleDomain.fromFixedValues(Map.of("month", new NullableValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"04")))));
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => 'hive_datalake', table_name => '" + externalTableName + "')");
        this.assertQuery("SELECT * FROM hive_datalake.\"" + externalTableName + "$partitions\"", "VALUES 1, 2, 3, 4");
        this.assertUpdate("ANALYZE " + this.getFullyQualifiedTestTableName(externalTableName) + " WITH (partitions = ARRAY[ARRAY['04']])", 1L);
        this.assertQuery("SHOW STATS FOR " + this.getFullyQualifiedTestTableName(externalTableName), "VALUES\n    ('a_varchar', 5.0, 2.0, 0.0, null, null, null),\n    ('month', null, 4.0, 0.0, null, 1, 4),\n    (null, null, null, null, 5.0, null, null)\n");
        this.assertQueryFails("ANALYZE " + this.getFullyQualifiedTestTableName(externalTableName) + " WITH (partitions = ARRAY[ARRAY['4']])", ".*Partition.*not found.*");
        this.assertUpdate("DROP TABLE " + this.getFullyQualifiedTestTableName(externalTableName));
        this.assertUpdate("DROP TABLE " + this.getFullyQualifiedTestTableName(tableName));
    }

    @Test
    public void testExternalLocationWithTrailingSpace() {
        String tableName = "test_external_location_with_trailing_space_" + TestingNames.randomNameSuffix();
        String tableLocationDirWithTrailingSpace = tableName + " ";
        String tableLocation = String.format("s3a://%s/%s/%s", this.bucketName, HIVE_TEST_SCHEMA, tableLocationDirWithTrailingSpace);
        byte[] contents = "hello\u0001world\nbye\u0001world".getBytes(StandardCharsets.UTF_8);
        String targetPath = String.format("%s/%s/test.txt", HIVE_TEST_SCHEMA, tableLocationDirWithTrailingSpace);
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, contents, targetPath);
        this.assertUpdate(String.format("CREATE TABLE %s (  a varchar,   b varchar) WITH (format='TEXTFILE', external_location='%s')", tableName, tableLocation));
        this.assertQuery("SELECT a, b FROM " + tableName, "VALUES ('hello', 'world'), ('bye', 'world')");
        String actualTableLocation = this.getTableLocation(tableName);
        Assertions.assertThat((String)actualTableLocation).isEqualTo(tableLocation);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSchemaInvalidName() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE SCHEMA \".\"")).hasMessage("Invalid object name: '.'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE SCHEMA \"..\"")).hasMessage("Invalid object name: '..'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE SCHEMA \"foo/bar\"")).hasMessage("Invalid object name: 'foo/bar'");
    }

    @Test
    public void testCreateTableInvalidName() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE hive_datalake.\".\" (col integer)")).hasMessageContaining("Invalid table name");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE hive_datalake.\"..\" (col integer)")).hasMessageContaining("Invalid table name");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE hive_datalake.\"...\" (col integer)")).hasMessage("Invalid table name");
        for (String tableName : Arrays.asList("foo/bar", "foo/./bar", "foo/../bar")) {
            Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE hive_datalake.\"" + tableName + "\" (col integer)")).hasMessage(String.format("Invalid object name: '%s'", tableName));
            Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE hive_datalake.\"" + tableName + "\" (col) AS VALUES 1")).hasMessage(String.format("Invalid object name: '%s'", tableName));
        }
    }

    @Test
    public void testRenameSchemaToInvalidObjectName() {
        String schemaName = "test_rename_schema_invalid_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA %1$s WITH (location='s3a://%2$s/%1$s')".formatted(schemaName, this.bucketName));
        for (String invalidSchemaName : Arrays.asList(".", "..", "foo/bar")) {
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER SCHEMA hive." + schemaName + " RENAME TO  \"" + invalidSchemaName + "\"")).hasMessage(String.format("Invalid object name: '%s'", invalidSchemaName));
        }
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testRenameTableToInvalidObjectName() {
        String tableName = "test_rename_table_invalid_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (a_varchar varchar)".formatted(this.getFullyQualifiedTestTableName(tableName)));
        for (String invalidTableName : Arrays.asList(".", "..", "foo/bar")) {
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + this.getFullyQualifiedTestTableName(tableName) + " RENAME TO  \"" + invalidTableName + "\"")).hasMessage(String.format("Invalid object name: '%s'", invalidTableName));
        }
        for (String invalidSchemaName : Arrays.asList(".", "..", "foo/bar")) {
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + this.getFullyQualifiedTestTableName(tableName) + " RENAME TO  \"" + invalidSchemaName + "\".validTableName")).hasMessage(String.format("Invalid object name: '%s'", invalidSchemaName));
        }
        this.assertUpdate("DROP TABLE " + this.getFullyQualifiedTestTableName(tableName));
    }

    @Test
    public void testUnpartitionedTableExternalLocationWithTrainingSlash() {
        String tableName = "test_external_location_trailing_slash_" + TestingNames.randomNameSuffix();
        String tableLocationWithTrailingSlash = String.format("s3://%s/%s/%s/", this.bucketName, HIVE_TEST_SCHEMA, tableName);
        byte[] contents = "Trino\nSQL\non\neverything".getBytes(StandardCharsets.UTF_8);
        String dataFilePath = String.format("%s/%s/data.txt", HIVE_TEST_SCHEMA, tableName);
        this.hiveMinioDataLake.getMinioClient().putObject(this.bucketName, contents, dataFilePath);
        this.assertUpdate(String.format("CREATE TABLE %s (  a_varchar varchar) WITH (   external_location='%s',   format='TEXTFILE')", tableName, tableLocationWithTrailingSlash));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'Trino', 'SQL', 'on', 'everything'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnpartitionedTableExternalLocationOnTopOfTheBucket() {
        String topBucketName = "test-hive-unpartitioned-top-of-the-bucket-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getMinio().createBucket(topBucketName);
        String tableName = "test_external_location_top_of_the_bucket_" + TestingNames.randomNameSuffix();
        byte[] contents = "Trino\nSQL\non\neverything".getBytes(StandardCharsets.UTF_8);
        this.hiveMinioDataLake.getMinioClient().putObject(topBucketName, contents, "data.txt");
        this.assertUpdate(String.format("CREATE TABLE %s (  a_varchar varchar) WITH (   external_location='%s',   format='TEXTFILE')", tableName, String.format("s3://%s/", topBucketName)));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'Trino', 'SQL', 'on', 'everything'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionedTableExternalLocationOnTopOfTheBucket() {
        String topBucketName = "test-hive-partitioned-top-of-the-bucket-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getMinio().createBucket(topBucketName);
        String tableName = "test_external_location_top_of_the_bucket_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (  a_varchar varchar,   pkey integer) WITH (   external_location='%s',   partitioned_by=ARRAY['pkey'])", tableName, String.format("s3://%s/", topBucketName)));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', 1) , ('b', 1), ('c', 2), ('d', 2)", 4L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('a', 1), ('b',1), ('c', 2), ('d', 2)");
        this.assertUpdate("DELETE FROM " + tableName + " where pkey = 2");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('a', 1), ('b',1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropStatsPartitionedTable() {
        String tableName = "test_hive_drop_stats_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (  data integer,  p_varchar varchar,  p_integer integer) WITH (  partitioned_by=ARRAY['p_varchar', 'p_integer'])".formatted(this.getFullyQualifiedTestTableName(tableName)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['partnotfound', '999']])", HIVE_TEST_SCHEMA, tableName)))).failure().hasMessage("No partition found for name: p_varchar=partnotfound/p_integer=999");
        this.assertUpdate("INSERT INTO " + this.getFullyQualifiedTestTableName(tableName) + " VALUES (1, 'part1', 10) , (2, 'part2', 10), (12, 'part2', 20)", 3L);
        this.assertUpdate("ANALYZE " + this.getFullyQualifiedTestTableName(tableName), 3L);
        this.assertQuery("SHOW STATS FOR " + this.getFullyQualifiedTestTableName(tableName), "VALUES\n    ('data', null, 1.0, 0.0, null, 1, 12),\n    ('p_varchar', 15.0, 2.0, 0.0, null, null, null),\n    ('p_integer', null, 2.0, 0.0, null, 10, 20),\n    (null, null, null, null, 3.0, null, null)\n");
        this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['part1', '10']])", HIVE_TEST_SCHEMA, tableName));
        this.assertQuery("SHOW STATS FOR " + this.getFullyQualifiedTestTableName(tableName), "VALUES\n    ('data', null, 1.0, 0.0, null, 2, 12),\n    ('p_varchar', 15.0, 2.0, 0.0, null, null, null),\n    ('p_integer', null, 2.0, 0.0, null, 10, 20),\n    (null, null, null, null, 3.0, null, null)\n");
        this.assertUpdate("DELETE FROM " + this.getFullyQualifiedTestTableName(tableName) + " WHERE p_varchar ='part1' and p_integer = 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['part1', '10']])", HIVE_TEST_SCHEMA, tableName)))).failure().hasMessage("No partition found for name: p_varchar=part1/p_integer=10");
        this.assertQuery("SHOW STATS FOR " + this.getFullyQualifiedTestTableName(tableName), "VALUES\n    ('data', null, 1.0, 0.0, null, 2, 12),\n    ('p_varchar', 10.0, 1.0, 0.0, null, null, null),\n    ('p_integer', null, 2.0, 0.0, null, 10, 20),\n    (null, null, null, null, 2.0, null, null)\n");
        this.assertUpdate("DROP TABLE " + this.getFullyQualifiedTestTableName(tableName));
    }

    @Test
    public void testUnsupportedDropSchemaCascadeWithNonHiveTable() {
        String schemaName = "test_unsupported_drop_schema_cascade_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_dummy_iceberg_table" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE DATABASE %2$s LOCATION 's3a://%1$s/%2$s'".formatted(this.bucketName, schemaName));
        try {
            this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE TABLE " + schemaName + "." + icebergTableName + " TBLPROPERTIES ('table_type'='iceberg') AS SELECT 1 a");
            this.assertQueryFails("DROP SCHEMA " + schemaName + " CASCADE", "\\QCannot query Iceberg table '%s.%s'".formatted(schemaName, icebergTableName));
            Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
            Assertions.assertThat((Collection)this.computeActual("SHOW TABLES FROM " + schemaName).getOnlyColumnAsSet()).contains(new Object[]{icebergTableName});
            Assertions.assertThat(this.hiveMinioDataLake.getMinioClient().listObjects(this.bucketName, schemaName).stream()).isNotEmpty();
        }
        finally {
            this.hiveMinioDataLake.getHiveHadoop().runOnHive("DROP DATABASE IF EXISTS " + schemaName + " CASCADE");
        }
    }

    @Test
    public void testUnsupportedCommentOnHiveView() {
        String viewName = "hive_datalake.test_unsupported_comment_on_hive_view_" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getHiveHadoop().runOnHive("CREATE VIEW " + viewName + " AS SELECT 1 x");
        try {
            this.assertQueryFails("COMMENT ON COLUMN " + viewName + ".x IS NULL", "Hive views are not supported.*");
        }
        finally {
            this.hiveMinioDataLake.getHiveHadoop().runOnHive("DROP VIEW " + viewName);
        }
    }

    @Test
    public void testCreateFunction() {
        String name = "test_" + TestingNames.randomNameSuffix();
        String name2 = "test_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE FUNCTION " + name + "(x integer) RETURNS bigint RETURN x * 10");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 990");
        this.assertUpdate("CREATE OR REPLACE FUNCTION " + name + "(x integer) RETURNS bigint COMMENT 't42' RETURN x * 42");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQueryFails("SELECT " + name + "(2.9)", ".*Unexpected parameters.*");
        this.assertUpdate("CREATE FUNCTION " + name + "(x double) RETURNS double COMMENT 't88' RETURN x * 8.8");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).build());
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQueryFails("CREATE FUNCTION " + name + "(x int) RETURNS bigint RETURN x", "line 1:1: Function already exists");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertUpdate("CREATE OR REPLACE FUNCTION " + name + "(x bigint) RETURNS bigint RETURN x * 23");
        this.assertUpdate("CREATE FUNCTION " + name2 + "(s varchar) RETURNS varchar RETURN 'Hello ' || s");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "bigint", "bigint", "scalar", true, ""}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).row(new Object[]{name2, "varchar", "varchar", "scalar", true, ""}).build());
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(cast(99 as bigint))", "SELECT 2277");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQuery("SELECT " + name2 + "('world')", "SELECT 'Hello world'");
        this.assertQueryFails("DROP FUNCTION " + name + "(varchar)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION " + name + "(z bigint)");
        this.assertUpdate("DROP FUNCTION " + name + "(double)");
        this.assertUpdate("DROP FUNCTION " + name + "(int)");
        this.assertQueryFails("DROP FUNCTION " + name + "(bigint)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION IF EXISTS " + name + "(bigint)");
        this.assertUpdate("DROP FUNCTION " + name2 + "(varchar)");
        this.assertQueryFails("DROP FUNCTION " + name2 + "(varchar)", "line 1:1: Function not found");
    }

    private void renamePartitionResourcesOutsideTrino(String tableName, String partitionColumn, String regionKey) {
        String partitionName = String.format("%s=%s", partitionColumn, regionKey);
        String partitionS3KeyPrefix = String.format("%s/%s/%s", HIVE_TEST_SCHEMA, tableName, partitionName);
        String renamedPartitionSuffix = "CP";
        MinioClient minioClient = this.hiveMinioDataLake.getMinioClient();
        minioClient.listObjects(this.bucketName, "").forEach(objectKey -> {
            if (objectKey.startsWith(partitionS3KeyPrefix)) {
                String fileName = objectKey.substring(objectKey.lastIndexOf(47));
                String destinationKey = partitionS3KeyPrefix + renamedPartitionSuffix + fileName;
                minioClient.copyObject(this.bucketName, objectKey, this.bucketName, destinationKey);
            }
        });
        Table hiveTable = (Table)this.metastoreClient.getTable(HIVE_TEST_SCHEMA, tableName).orElseThrow();
        Partition partition = (Partition)this.metastoreClient.getPartition(hiveTable, List.of(regionKey)).orElseThrow();
        Map partitionStatistics = this.metastoreClient.getPartitionColumnStatistics(HIVE_TEST_SCHEMA, tableName, (Set)ImmutableSet.of((Object)partitionName), partition.getColumns().stream().map(Column::getName).collect(Collectors.toSet()));
        this.metastoreClient.dropPartition(HIVE_TEST_SCHEMA, tableName, List.of(regionKey), true);
        this.metastoreClient.addPartitions(HIVE_TEST_SCHEMA, tableName, List.of(new PartitionWithStatistics(Partition.builder((Partition)partition).withStorage(builder -> builder.setLocation(partition.getStorage().getLocation() + renamedPartitionSuffix)).build(), partitionName, new PartitionStatistics(MetastoreUtil.getHiveBasicStatistics((Map)partition.getParameters()), (Map)partitionStatistics.get(partitionName)))));
    }

    protected void assertInsertFailure(String testTable, String expectedMessageRegExp) {
        this.assertInsertFailure(this.getSession(), testTable, expectedMessageRegExp);
    }

    protected void assertInsertFailure(Session session, String testTable, String expectedMessageRegExp) {
        this.assertQueryFails(session, this.createInsertAsSelectFromTpchStatement(testTable), expectedMessageRegExp);
    }

    private String createInsertAsSelectFromTpchStatement(String testTable) {
        return String.format("INSERT INTO %s SELECT name, comment, nationkey, regionkey FROM tpch.tiny.nation", testTable);
    }

    protected String createInsertStatement(String testTable, List<List<String>> data) {
        String values = data.stream().map(row -> String.join((CharSequence)", ", row)).collect(Collectors.joining("), ("));
        return String.format("INSERT INTO %s VALUES (%s)", testTable, values);
    }

    protected void assertOverwritePartition(String testTable) {
        this.computeActual(this.createInsertStatement(testTable, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND'", (Object)"'Test Data'", (Object)"25", (Object)"5"), (Object)ImmutableList.of((Object)"'CZECH'", (Object)"'Test Data'", (Object)"26", (Object)"5"))));
        ((QueryAssertions.QueryAssert)this.query(String.format("SELECT name, comment, nationkey, regionkey FROM %s WHERE regionkey = 5", testTable)).assertThat()).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{"POLAND", "Test Data", 25L, 5L}).row(new Object[]{"CZECH", "Test Data", 26L, 5L}).build());
        this.computeActual(this.createInsertStatement(testTable, (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"'POLAND'", (Object)"'Overwrite'", (Object)"25", (Object)"5"))));
        ((QueryAssertions.QueryAssert)this.query(String.format("SELECT name, comment, nationkey, regionkey FROM %s WHERE regionkey = 5", testTable)).assertThat()).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{"POLAND", "Overwrite", 25L, 5L}).build());
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    protected String getRandomTestTableName() {
        return "nation_" + TestingNames.randomNameSuffix();
    }

    protected String getFullyQualifiedTestTableName() {
        return this.getFullyQualifiedTestTableName(this.getRandomTestTableName());
    }

    protected String getFullyQualifiedTestTableName(String tableName) {
        return this.getFullyQualifiedTestTableName(HIVE_TEST_SCHEMA, tableName);
    }

    protected String getFullyQualifiedTestTableName(String schemaName, String tableName) {
        return "hive.%s.%s".formatted(schemaName, tableName);
    }

    protected String getHiveTestTableName(String tableName) {
        return this.getHiveTestTableName(HIVE_TEST_SCHEMA, tableName);
    }

    protected String getHiveTestTableName(String schemaName, String tableName) {
        return "%s.%s".formatted(schemaName, tableName);
    }

    protected String getCreateTableStatement(String tableName, String ... propertiesEntries) {
        return this.getCreateTableStatement(tableName, Arrays.asList(propertiesEntries));
    }

    protected String getCreateTableStatement(String tableName, List<String> propertiesEntries) {
        return String.format("CREATE TABLE %s (    name varchar(25),     comment varchar(152),      nationkey bigint,     regionkey bigint) " + (propertiesEntries.isEmpty() ? "" : propertiesEntries.stream().collect(Collectors.joining(",", "WITH (", ")"))), tableName);
    }

    protected void copyTpchNationToTable(String testTable) {
        this.computeActual(String.format("INSERT INTO " + testTable + " SELECT name, comment, nationkey, regionkey FROM tpch.tiny.nation", new Object[0]));
    }

    private void testWriteWithFileSize(String testTable, int scaleFactorInThousands, long fileSizeRangeStart, long fileSizeRangeEnd) {
        String scaledColumnExpression = String.format("array_join(transform(sequence(1, %d), x-> array_join(repeat(comment, 1000), '')), '')", scaleFactorInThousands);
        this.computeActual(String.format("INSERT INTO " + testTable + " SELECT %s, %s, regionkey FROM tpch.tiny.nation WHERE nationkey = 9", scaledColumnExpression, scaledColumnExpression));
        ((QueryAssertions.QueryAssert)this.query(String.format("SELECT length(col1) FROM %s", testTable)).assertThat()).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{114L * (long)scaleFactorInThousands * 1000L}).build());
        ((QueryAssertions.QueryAssert)this.query(String.format("SELECT \"$file_size\" BETWEEN %d AND %d FROM %s", fileSizeRangeStart, fileSizeRangeEnd, testTable)).assertThat()).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{true}).build());
    }

    private void addPartitions(String sourceTableName, String destinationExternalTableName, List<String> columnNames, TupleDomain<String> partitionsKeyFilter) {
        Optional partitionNames = this.metastoreClient.getPartitionNamesByFilter(HIVE_TEST_SCHEMA, sourceTableName, columnNames, partitionsKeyFilter);
        if (partitionNames.isEmpty()) {
            return;
        }
        Table table = (Table)this.metastoreClient.getTable(HIVE_TEST_SCHEMA, sourceTableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(HIVE_TEST_SCHEMA, sourceTableName)));
        Map partitionsByNames = this.metastoreClient.getPartitionsByNames(table, (List)partitionNames.get());
        this.metastoreClient.addPartitions(HIVE_TEST_SCHEMA, destinationExternalTableName, (List)partitionsByNames.entrySet().stream().map(e -> new PartitionWithStatistics(((Optional)e.getValue()).map(p -> Partition.builder((Partition)p).setTableName(destinationExternalTableName).build()).orElseThrow(), (String)e.getKey(), PartitionStatistics.empty())).collect(ImmutableList.toImmutableList()));
    }

    private String getTableLocation(String tableName) {
        return (String)this.computeScalar("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + tableName);
    }

    @Test
    public void testInsertOverwritePartitionedAndBucketedAcidTable() {
        String testTable = this.getFullyQualifiedTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3", "format = 'ORC'", "transactional = true"));
        this.assertInsertFailure(testTable, "Overwriting existing partition in transactional tables doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
    }
}

