/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.BaseConnectorSmokeTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveConnectorSmokeTest
extends BaseConnectorSmokeTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES -> true;
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_TRUNCATE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testRowLevelDelete() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDelete()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testRowLevelUpdate() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelUpdate()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).isEqualTo("CREATE TABLE hive.tpch.region (\n   regionkey bigint,\n   name varchar(25),\n   comment varchar(152)\n)\nWITH (\n   format = 'ORC'\n)");
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        Assertions.assertThatThrownBy(() -> super.testCreateSchemaWithNonLowercaseOwnerName()).hasMessageContaining("Access Denied: Cannot create schema").hasStackTraceContaining("CREATE SCHEMA");
    }
}

