/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.BaseConnectorSmokeTest;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveCustomCatalogConnectorSmokeTest
extends BaseConnectorSmokeTest {
    private static final String HIVE_CUSTOM_CATALOG = "custom";

    protected QueryRunner createQueryRunner() throws Exception {
        String bucketName = "test-hive-metastore-catalog-smoke-test-" + TestingNames.randomNameSuffix();
        HiveMinioDataLake hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake(bucketName, HiveHadoop.HIVE3_IMAGE));
        hiveMinioDataLake.start();
        hiveMinioDataLake.getHiveHadoop().runOnMetastore("INSERT INTO CTLGS VALUES (2, '%s', 'Custom catalog', 's3://%s/custom')".formatted(HIVE_CUSTOM_CATALOG, bucketName));
        DistributedQueryRunner queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().addHiveProperty("hive.metastore", "thrift").addHiveProperty("hive.metastore.uri", hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString()))).addHiveProperty("hive.metastore.thrift.catalog-name", HIVE_CUSTOM_CATALOG))).addHiveProperty("fs.hadoop.enabled", "false"))).addHiveProperty("fs.native-s3.enabled", "true"))).addHiveProperty("s3.path-style-access", "true"))).addHiveProperty("s3.region", "us-east-1"))).addHiveProperty("s3.endpoint", hiveMinioDataLake.getMinio().getMinioAddress()))).addHiveProperty("s3.aws-access-key", "accesskey"))).addHiveProperty("s3.aws-secret-key", "secretkey"))).setCreateTpchSchemas(false))).build();
        HiveMetastore metastore = TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        metastore.createDatabase(TestHiveCustomCatalogConnectorSmokeTest.createDatabaseMetastoreObject("tpch", Optional.of("s3://%s/%s".formatted(bucketName, "tpch"))));
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Iterable)REQUIRED_TPCH_TABLES);
        return queryRunner;
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES -> true;
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_TRUNCATE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testRowLevelDelete() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDelete()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testRowLevelUpdate() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelUpdate()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).isEqualTo("CREATE TABLE hive.tpch.region (\n   regionkey bigint,\n   name varchar(25),\n   comment varchar(152)\n)\nWITH (\n   format = 'ORC'\n)");
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        Assertions.assertThatThrownBy(() -> super.testCreateSchemaWithNonLowercaseOwnerName()).hasMessageContaining("Access Denied: Cannot create schema").hasStackTraceContaining("CREATE SCHEMA");
    }

    @Test
    public void testRenameSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestingNames.randomNameSuffix()), "Hive metastore does not support renaming schemas");
    }

    private static Database createDatabaseMetastoreObject(String name, Optional<String> locationBase) {
        return Database.builder().setLocation(locationBase.map(base -> base + "/" + name)).setDatabaseName(name).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }
}

