/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.BaseDynamicPartitionPruningTest;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestHiveDynamicPartitionPruningTest
extends BaseDynamicPartitionPruningTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder().setExtraProperties(EXTRA_PROPERTIES)).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.dynamic-filtering.wait-timeout", (Object)"1h")))).setInitialTables(REQUIRED_TABLES))).build();
    }

    protected void createLineitemTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s WITH (format = 'TEXTFILE', partitioned_by=array[%s]) AS SELECT %s FROM tpch.tiny.lineitem", tableName, partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")), String.join((CharSequence)",", columns));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s (%s) WITH (partitioned_by=array[%s])", tableName, String.join((CharSequence)",", columns), partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedAndBucketedTable(String tableName, List<String> columns, List<String> partitionColumns, List<String> bucketColumns) {
        String sql = String.format("CREATE TABLE %s (%s) WITH (partitioned_by=array[%s], bucketed_by=array[%s], bucket_count=10)", tableName, String.join((CharSequence)",", columns), partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")), bucketColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")));
        this.getQueryRunner().execute(sql);
    }
}

