/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestDynamicRowFiltering;
import io.trino.testing.QueryRunner;
import java.util.Map;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public final class TestHiveDynamicRowFiltering
extends AbstractTestDynamicRowFiltering {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setInitialTables(REQUIRED_TPCH_TABLES).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.dynamic-filtering.wait-timeout", (Object)"1h", (Object)"hive.target-max-file-size", (Object)"10kB")))).build();
    }

    @BeforeAll
    public void createTestData() {
        this.assertUpdate("CREATE TABLE orders AS SELECT CAST(clerk AS CHAR(15)) clerk, CAST(orderstatus AS CHAR(5)) orderstatus, custkey FROM tpch.tiny.orders", 15000L);
    }

    @Test
    @Timeout(value=30L)
    public void testRowFilteringWithCharStrings() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertRowFiltering("SELECT o1.clerk, o1.custkey, CAST(o1.orderstatus AS VARCHAR(1)) FROM orders o1, orders o2 WHERE o1.clerk = o2.clerk AND o2.custkey < 10", joinDistributionType, "orders");
            this.assertNoRowFiltering("SELECT COUNT(*) FROM orders o1, orders o2 WHERE o1.orderstatus = o2.orderstatus AND o2.custkey < 20", joinDistributionType, "orders");
        }
    }

    protected SchemaTableName getSchemaTableName(ConnectorTableHandle connectorHandle) {
        return ((HiveTableHandle)connectorHandle).getSchemaTableName();
    }
}

