/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.TableInput;

public class TestHiveGlueMetadataListing
extends AbstractTestQueryFramework {
    public static final String FAILING_TABLE_WITH_NULL_STORAGE_DESCRIPTOR_NAME = "failing_table_with_null_storage_descriptor";
    private static final Logger LOG = Logger.get(TestHiveGlueMetadataListing.class);
    private static final String HIVE_CATALOG = "hive";
    private final String tpchSchema = "test_tpch_schema_" + TestingNames.randomNameSuffix();
    private GlueHiveMetastore glueMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session hiveSession = TestingSession.testSessionBuilder().setCatalog(HIVE_CATALOG).setSchema(this.tpchSchema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)hiveSession).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        Path dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data");
        dataDirectory.toFile().deleteOnExit();
        this.glueMetastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore(dataDirectory, x$0 -> this.closeAfterClass((AutoCloseable)x$0));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(dataDirectory, (HiveMetastore)this.glueMetastore));
        queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG, (Map)ImmutableMap.of((Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.execute("CREATE SCHEMA " + this.tpchSchema + " WITH (location = '" + String.valueOf(dataDirectory.toUri()) + "')");
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)hiveSession, (Iterable)ImmutableList.of((Object)TpchTable.REGION, (Object)TpchTable.NATION));
        this.createBrokenTable(dataDirectory);
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        try {
            if (this.glueMetastore != null) {
                this.glueMetastore.dropDatabase(this.tpchSchema, false);
                this.glueMetastore.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to clean up Glue database: %s", new Object[]{this.tpchSchema});
        }
    }

    @Test
    public void testReadInformationSchema() {
        String expectedTables = String.format("VALUES '%s', '%s', '%s'", TpchTable.REGION.getTableName(), TpchTable.NATION.getTableName(), FAILING_TABLE_WITH_NULL_STORAGE_DESCRIPTOR_NAME);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_name FROM hive.information_schema.tables"))).skippingTypesCheck().containsAll(expectedTables);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_name FROM hive.information_schema.tables WHERE table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().matches(expectedTables);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_name FROM hive.information_schema.tables WHERE table_name = 'region' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().matches("VALUES 'region'");
        this.assertQueryReturnsEmptyResult(String.format("SELECT table_name FROM hive.information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", FAILING_TABLE_WITH_NULL_STORAGE_DESCRIPTOR_NAME, this.tpchSchema));
        this.assertQuery("SELECT table_name, column_name from hive.information_schema.columns WHERE table_schema = '" + this.tpchSchema + "'", "VALUES ('region', 'regionkey'), ('region', 'name'), ('region', 'comment'), ('nation', 'nationkey'), ('nation', 'name'), ('nation', 'regionkey'), ('nation', 'comment')");
        this.assertQuery("SELECT table_name, column_name from hive.information_schema.columns WHERE table_name = 'region' AND table_schema='" + this.tpchSchema + "'", "VALUES ('region', 'regionkey'), ('region', 'name'), ('region', 'comment')");
        this.assertQueryReturnsEmptyResult(String.format("SELECT table_name FROM hive.information_schema.columns WHERE table_name = '%s' AND table_schema='%s'", FAILING_TABLE_WITH_NULL_STORAGE_DESCRIPTOR_NAME, this.tpchSchema));
        this.assertQuery("SHOW TABLES FROM hive." + this.tpchSchema, expectedTables);
    }

    private void createBrokenTable(Path dataDirectory) {
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig().setDefaultWarehouseDir(dataDirectory.toString());
        try (GlueClient glueClient = GlueMetastoreModule.createGlueClient((GlueHiveMetastoreConfig)glueConfig, (OpenTelemetry)OpenTelemetry.noop());){
            TableInput tableInput = (TableInput)TableInput.builder().name(FAILING_TABLE_WITH_NULL_STORAGE_DESCRIPTOR_NAME).tableType("HIVE").build();
            CreateTableRequest createTableRequest = (CreateTableRequest)CreateTableRequest.builder().databaseName(this.tpchSchema).tableInput(tableInput).build();
            glueClient.createTable(createTableRequest);
        }
    }
}

