/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveLocationService {
    @Test
    public void testGetTableWriteInfoAppend() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/write", LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/target", LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/target", LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY));
    }

    @Test
    public void testGetTableWriteInfoOverwriteSuccess() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), true).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/write", LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
    }

    @Test
    public void testGetTableWriteInfoOverwriteFailDirectNew() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), true)).hasMessage("Overwriting unpartitioned table not supported when writing directly to target directory");
    }

    @Test
    public void testGetTableWriteInfoOverwriteFailDirectExisting() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), true)).hasMessage("Overwriting unpartitioned table not supported when writing directly to target directory");
    }

    private static Assertion assertThat(LocationHandle locationHandle, boolean overwrite) {
        return new Assertion(locationHandle, overwrite);
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode) {
        return TestHiveLocationService.locationHandle(writeMode, "/target", "/write");
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode, String targetPath, String writePath) {
        return new LocationHandle(Location.of((String)targetPath), Location.of((String)writePath), writeMode);
    }

    private static LocationService.WriteInfo writeInfo(String targetPath, String writePath, LocationHandle.WriteMode writeMode) {
        return new LocationService.WriteInfo(Location.of((String)targetPath), Location.of((String)writePath), writeMode);
    }

    public static class Assertion {
        private final LocationService.WriteInfo actual;

        public Assertion(LocationHandle locationHandle, boolean overwrite) {
            HiveLocationService service = new HiveLocationService((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig());
            this.actual = service.getTableWriteInfo(locationHandle, overwrite);
        }

        public void producesWriteInfo(LocationService.WriteInfo expected) {
            Assertions.assertThat((Object)this.actual.writePath()).isEqualTo((Object)expected.writePath());
            Assertions.assertThat((Object)this.actual.targetPath()).isEqualTo((Object)expected.targetPath());
            Assertions.assertThat((Comparable)this.actual.writeMode()).isEqualTo((Object)expected.writeMode());
        }
    }
}

