/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestHiveMetadata {
    private static final HiveColumnHandle TEST_COLUMN_HANDLE = HiveColumnHandle.createBaseColumn((String)"test", (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    private static final HiveColumnHandle DOUBLE_COLUMN_HANDLE = HiveColumnHandle.createBaseColumn((String)"test", (int)0, (HiveType)HiveType.HIVE_DOUBLE, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    @Test
    @Timeout(value=10L)
    public void testCreatePredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i2 = 0; i2 < 5000; ++i2) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i2), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i2))))));
        }
        Domain domain = (Domain)((Map)HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build()).getDomains().orElseThrow()).get(TEST_COLUMN_HANDLE);
        Assertions.assertThat((Object)domain).isEqualTo((Object)Domain.create((ValueSet)ValueSet.copyOf((Type)VarcharType.VARCHAR, (Collection)((Collection)IntStream.range(0, 5000).mapToObj(i -> Slices.utf8Slice((String)Integer.toString(i))).collect(ImmutableList.toImmutableList()))), (boolean)false));
    }

    @Test
    public void testCreateOnlyNullsPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        }
        Domain domain = (Domain)((Map)HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build()).getDomains().orElseThrow()).get(TEST_COLUMN_HANDLE);
        Assertions.assertThat((Object)domain).isEqualTo((Object)Domain.onlyNull((Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCreatePredicateWithNaN() {
        HiveColumnHandle columnHandle = DOUBLE_COLUMN_HANDLE;
        ImmutableList.Builder partitions = ImmutableList.builder();
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "p1", (Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)Double.NaN))));
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "p2", (Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)4.2))));
        Domain domain = (Domain)((Map)HiveMetadata.createPredicate((List)ImmutableList.of((Object)columnHandle), (List)partitions.build()).getDomains().orElseThrow()).get(columnHandle);
        Assertions.assertThat((Object)domain).isEqualTo((Object)Domain.notNull((Type)DoubleType.DOUBLE));
    }

    @Test
    public void testCreatePredicateWithNaNAndNull() {
        HiveColumnHandle columnHandle = DOUBLE_COLUMN_HANDLE;
        ImmutableList.Builder partitions = ImmutableList.builder();
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "p1", (Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)Double.NaN))));
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "p2", (Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)DoubleType.DOUBLE, (Object)4.2))));
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "p3", (Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.asNull((Type)DoubleType.DOUBLE))));
        Domain domain = (Domain)((Map)HiveMetadata.createPredicate((List)ImmutableList.of((Object)columnHandle), (List)partitions.build()).getDomains().orElseThrow()).get(columnHandle);
        Assertions.assertThat((Object)domain).isNull();
    }

    @Test
    public void testCreateMixedPredicate() {
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), Integer.toString(i), (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)Integer.toString(i))))));
        }
        partitions.add((Object)new HivePartition(new SchemaTableName("test", "test"), "null", (Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE, (Object)NullableValue.asNull((Type)VarcharType.VARCHAR))));
        Domain domain = (Domain)((Map)HiveMetadata.createPredicate((List)ImmutableList.of((Object)TEST_COLUMN_HANDLE), (List)partitions.build()).getDomains().orElseThrow()).get(TEST_COLUMN_HANDLE);
        Assertions.assertThat((Object)domain).isEqualTo((Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"0"), (Object[])new Object[]{Slices.utf8Slice((String)"1"), Slices.utf8Slice((String)"2"), Slices.utf8Slice((String)"3"), Slices.utf8Slice((String)"4")}), (boolean)true));
    }
}

