/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveMetadataListing
extends AbstractTestQueryFramework {
    private static final String DATABASE_NAME = "database";
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"), (Map)ImmutableMap.of());
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), Optional.of("location"), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)))), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"));
    private static final Table CORRECT_VIEW = new Table("database", "correct_view", Optional.of("owner"), "VIRTUAL_VIEW", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"PRESTO_VIEW_FLAG", (Object)"value3"), Optional.of("SELECT 1"), Optional.of("SELECT 1"), OptionalLong.empty());
    private static final Table FAILING_STORAGE_DESCRIPTOR_VIEW = new Table("database", "failing_storage_descriptor_view", Optional.of("owner"), "VIRTUAL_VIEW", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"PRESTO_VIEW_FLAG", (Object)"value3"), Optional.of("SELECT 1"), Optional.of("SELECT 1"), OptionalLong.empty());
    private static final Table FAILING_GENERAL_VIEW = new Table("database", "failing_general_view", Optional.of("owner"), "VIRTUAL_VIEW", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"PRESTO_VIEW_FLAG", (Object)"value3"), Optional.of("SELECT 1"), Optional.of("SELECT 1"), OptionalLong.empty());
    private static final Table CORRECT_TABLE = new Table("database", "correct_table", Optional.of("owner"), "MANAGED_TABLE", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.empty(), Optional.empty(), OptionalLong.empty());
    private static final Table FAILING_SERDE_INFO_TABLE = new Table("database", "failing_serde_info_table", Optional.of("owner"), "MANAGED_TABLE", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.empty(), Optional.empty(), OptionalLong.empty());
    private static final Table FAILING_GENERAL_TABLE = new Table("database", "failing_general_table", Optional.of("owner"), "MANAGED_TABLE", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.empty(), Optional.empty(), OptionalLong.empty());

    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setCreateTpchSchemas(false).addHiveProperty("hive.security", "allow-all"))).addHiveProperty("hive.hive-views.enabled", "true"))).setMetastore(runner -> new TestingHiveMetastore()))).build();
    }

    @Test
    public void testViewListing() {
        String withNoFilter = "SELECT table_name FROM information_schema.views";
        Assertions.assertThat((Object)this.computeScalar(withNoFilter)).isEqualTo((Object)CORRECT_VIEW.getSchemaTableName().getTableName());
        String withSchemaFilter = String.format("SELECT table_name FROM information_schema.views WHERE table_schema = '%s'", DATABASE_NAME);
        Assertions.assertThat((Object)this.computeScalar(withSchemaFilter)).isEqualTo((Object)CORRECT_VIEW.getSchemaTableName().getTableName());
        String withSchemaAndCorrectViewFilter = String.format("SELECT table_name FROM information_schema.views WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, CORRECT_VIEW.getSchemaTableName().getTableName());
        Assertions.assertThat((Object)this.computeScalar(withSchemaAndCorrectViewFilter)).isEqualTo((Object)CORRECT_VIEW.getSchemaTableName().getTableName());
        String withSchemaAndFailingSDViewFilter = String.format("SELECT table_name FROM information_schema.views WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, FAILING_STORAGE_DESCRIPTOR_VIEW.getSchemaTableName().getTableName());
        this.assertQueryReturnsEmptyResult(withSchemaAndFailingSDViewFilter);
        String withSchemaAndFailingGeneralViewFilter = String.format("SELECT table_name FROM information_schema.views WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, FAILING_GENERAL_VIEW.getSchemaTableName().getTableName());
        this.assertQueryReturnsEmptyResult(withSchemaAndFailingGeneralViewFilter);
    }

    @Test
    public void testTableListing() {
        String withSchemaFilter = String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", DATABASE_NAME);
        this.assertQuery(withSchemaFilter, "VALUES ('correct_view'),\n('failing_general_view'),\n('failing_storage_descriptor_view'),\n('correct_table'),\n('failing_serde_info_table'),\n('failing_general_table')");
        String withSchemaAndCorrectTableFilter = String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, CORRECT_TABLE.getSchemaTableName().getTableName());
        Assertions.assertThat((Object)this.computeScalar(withSchemaAndCorrectTableFilter)).isEqualTo((Object)CORRECT_TABLE.getSchemaTableName().getTableName());
        String withSchemaAndFailingSDTableFilter = String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, FAILING_SERDE_INFO_TABLE.getSchemaTableName().getTableName());
        this.assertQueryReturnsEmptyResult(withSchemaAndFailingSDTableFilter);
        String withSchemaAndFailingGeneralTableFilter = String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s'", DATABASE_NAME, FAILING_GENERAL_TABLE.getSchemaTableName().getTableName());
        this.assertQueryReturnsEmptyResult(withSchemaAndFailingGeneralTableFilter);
    }

    private static class TestingHiveMetastore
    implements HiveMetastore {
        private TestingHiveMetastore() {
        }

        public List<String> getAllDatabases() {
            return ImmutableList.of((Object)TestHiveMetadataListing.DATABASE_NAME);
        }

        public List<TableInfo> getTables(String databaseName) {
            return ImmutableList.builder().add((Object)new TableInfo(CORRECT_VIEW.getSchemaTableName(), TableInfo.ExtendedRelationType.OTHER_VIEW)).add((Object)new TableInfo(FAILING_STORAGE_DESCRIPTOR_VIEW.getSchemaTableName(), TableInfo.ExtendedRelationType.OTHER_VIEW)).add((Object)new TableInfo(FAILING_GENERAL_VIEW.getSchemaTableName(), TableInfo.ExtendedRelationType.OTHER_VIEW)).add((Object)new TableInfo(CORRECT_TABLE.getSchemaTableName(), TableInfo.ExtendedRelationType.TABLE)).add((Object)new TableInfo(FAILING_SERDE_INFO_TABLE.getSchemaTableName(), TableInfo.ExtendedRelationType.TABLE)).add((Object)new TableInfo(FAILING_GENERAL_TABLE.getSchemaTableName(), TableInfo.ExtendedRelationType.TABLE)).build();
        }

        public Optional<Table> getTable(String databaseName, String tableName) {
            SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
            if (schemaTableName.equals((Object)CORRECT_VIEW.getSchemaTableName())) {
                return Optional.of(CORRECT_VIEW);
            }
            if (schemaTableName.equals((Object)FAILING_STORAGE_DESCRIPTOR_VIEW.getSchemaTableName())) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table StorageDescriptor is null for failing_view");
            }
            if (schemaTableName.equals((Object)FAILING_GENERAL_VIEW.getSchemaTableName())) {
                throw new RuntimeException("General error");
            }
            if (schemaTableName.equals((Object)FAILING_SERDE_INFO_TABLE.getSchemaTableName())) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table SerdeInfo is null for table failing_table");
            }
            if (schemaTableName.equals((Object)FAILING_GENERAL_TABLE.getSchemaTableName())) {
                throw new RuntimeException("General error");
            }
            return Optional.empty();
        }

        public Optional<Database> getDatabase(String databaseName) {
            throw new UnsupportedOperationException();
        }

        public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
            throw new UnsupportedOperationException();
        }

        public void updateTableStatistics(String databaseName, String tableName, OptionalLong acidWriteId, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
            throw new UnsupportedOperationException();
        }

        public void updatePartitionStatistics(Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
            throw new UnsupportedOperationException();
        }

        public void createDatabase(Database database) {
            throw new UnsupportedOperationException();
        }

        public void dropDatabase(String databaseName, boolean deleteData) {
            throw new UnsupportedOperationException();
        }

        public void renameDatabase(String databaseName, String newDatabaseName) {
            throw new UnsupportedOperationException();
        }

        public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
            throw new UnsupportedOperationException();
        }

        public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
            throw new UnsupportedOperationException();
        }

        public void dropTable(String databaseName, String tableName, boolean deleteData) {
            throw new UnsupportedOperationException();
        }

        public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
            throw new UnsupportedOperationException();
        }

        public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
            throw new UnsupportedOperationException();
        }

        public void commentTable(String databaseName, String tableName, Optional<String> comment) {
            throw new UnsupportedOperationException();
        }

        public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
            throw new UnsupportedOperationException();
        }

        public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
            throw new UnsupportedOperationException();
        }

        public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
            throw new UnsupportedOperationException();
        }

        public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
            throw new UnsupportedOperationException();
        }

        public void dropColumn(String databaseName, String tableName, String columnName) {
            throw new UnsupportedOperationException();
        }

        public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
            throw new UnsupportedOperationException();
        }

        public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
            throw new UnsupportedOperationException();
        }

        public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
            throw new UnsupportedOperationException();
        }

        public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
            throw new UnsupportedOperationException();
        }

        public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
            throw new UnsupportedOperationException();
        }

        public void createRole(String role, String grantor) {
            throw new UnsupportedOperationException();
        }

        public void dropRole(String role) {
            throw new UnsupportedOperationException();
        }

        public Set<String> listRoles() {
            throw new UnsupportedOperationException();
        }

        public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
            throw new UnsupportedOperationException();
        }

        public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
            throw new UnsupportedOperationException();
        }

        public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
            throw new UnsupportedOperationException();
        }

        public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
            throw new UnsupportedOperationException();
        }

        public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
            throw new UnsupportedOperationException();
        }

        public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
            throw new UnsupportedOperationException();
        }

        public boolean functionExists(String databaseName, String functionName, String signatureToken) {
            throw new UnsupportedOperationException();
        }

        public Collection<LanguageFunction> getAllFunctions(String databaseName) {
            throw new UnsupportedOperationException();
        }

        public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
            throw new UnsupportedOperationException();
        }

        public void createFunction(String databaseName, String functionName, LanguageFunction function) {
            throw new UnsupportedOperationException();
        }

        public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
            throw new UnsupportedOperationException();
        }

        public void dropFunction(String databaseName, String functionName, String signatureToken) {
            throw new UnsupportedOperationException();
        }
    }
}

