/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveType;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePageSinkProvider;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.SplitWeight;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingPageSinkId;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemColumn;
import io.trino.tpch.LineItemGenerator;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHivePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    @Test
    void testAllFormats() throws Exception {
        HiveConfig config = new HiveConfig();
        SortingFileWriterConfig sortingFileWriterConfig = new SortingFileWriterConfig();
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)fileSystemFactory, Location.of((String)"memory:///metastore"));
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (format == HiveStorageFormat.CSV || format == HiveStorageFormat.REGEX) continue;
            config.setHiveStorageFormat(format);
            config.setHiveCompressionCodec(HiveCompressionOption.NONE);
            long uncompressedLength = TestHivePageSink.writeTestFile((TrinoFileSystemFactory)fileSystemFactory, config, sortingFileWriterConfig, (HiveMetastore)metastore, TestHivePageSink.makeFileName(config));
            Assertions.assertThat((long)uncompressedLength).isGreaterThan(0L);
            for (HiveCompressionOption codec : HiveCompressionOption.values()) {
                if (codec == HiveCompressionOption.NONE) continue;
                config.setHiveCompressionCodec(codec);
                if (!TestHivePageSink.isSupportedCodec(format, codec)) {
                    Assertions.assertThatThrownBy(() -> TestHivePageSink.lambda$testAllFormats$0((TrinoFileSystemFactory)fileSystemFactory, config, sortingFileWriterConfig, (HiveMetastore)metastore)).hasMessage("Compression codec " + String.valueOf(codec) + " not supported for " + format.humanName());
                    continue;
                }
                long length = TestHivePageSink.writeTestFile((TrinoFileSystemFactory)fileSystemFactory, config, sortingFileWriterConfig, (HiveMetastore)metastore, TestHivePageSink.makeFileName(config));
                ((AbstractBooleanAssert)Assertions.assertThat((uncompressedLength > length ? 1 : 0) != 0).describedAs(String.format("%s with %s compressed to %s which is not less than %s", format, codec, length, uncompressedLength), new Object[0])).isTrue();
            }
        }
    }

    @Test
    public void testCloseIdleWritersWhenIdleWriterMinFileSizeLimitIsReached() throws IOException {
        this.testCloseIdleWriters(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.BYTE), 2, 1);
    }

    @Test
    public void testCloseIdleWritersWhenIdleWriterMinFileSizeLimitIsNotReached() throws IOException {
        this.testCloseIdleWriters(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 1, 1);
    }

    private void testCloseIdleWriters(DataSize idleWritersMinFileSize, int expectedTruckFiles, int expectedShipFiles) throws IOException {
        HiveConfig config = new HiveConfig().setIdleWriterMinFileSize(idleWritersMinFileSize).setHiveStorageFormat(HiveStorageFormat.PARQUET).setHiveCompressionCodec(HiveCompressionOption.NONE);
        SortingFileWriterConfig sortingFileWriterConfig = new SortingFileWriterConfig();
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)fileSystemFactory, Location.of((String)"memory:///metastore"));
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        HiveWriterStats stats = new HiveWriterStats();
        List<HiveColumnHandle> columnHandles = TestHivePageSink.getPartitionedColumnHandles(LineItemColumn.SHIP_MODE.getColumnName());
        Location location = TestHivePageSink.makeFileName(config);
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink((TrinoFileSystemFactory)fileSystemFactory, transaction, config, sortingFileWriterConfig, (HiveMetastore)metastore, location, stats, columnHandles);
        Page truckPage = TestHivePageSink.createPage(lineItem -> lineItem.shipMode().equals("TRUCK"));
        Page shipPage = TestHivePageSink.createPage(lineItem -> lineItem.shipMode().equals("SHIP"));
        pageSink.appendPage(truckPage);
        pageSink.appendPage(shipPage);
        pageSink.closeIdleWriters();
        pageSink.appendPage(shipPage);
        pageSink.closeIdleWriters();
        pageSink.appendPage(truckPage);
        pageSink.appendPage(shipPage);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        FileIterator fileIterator = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).listFiles(location);
        int truckFileCount = 0;
        int shipFileCount = 0;
        while (fileIterator.hasNext()) {
            FileEntry file = fileIterator.next();
            if (file.location().toString().contains("TRUCK")) {
                ++truckFileCount;
                continue;
            }
            if (!file.location().toString().contains("SHIP")) continue;
            ++shipFileCount;
        }
        Assertions.assertThat((int)truckFileCount).isEqualTo(expectedTruckFiles);
        Assertions.assertThat((int)shipFileCount).isEqualTo(expectedShipFiles);
    }

    private static boolean isSupportedCodec(HiveStorageFormat storageFormat, HiveCompressionOption compressionOption) {
        return storageFormat != HiveStorageFormat.AVRO && storageFormat != HiveStorageFormat.PARQUET || compressionOption != HiveCompressionOption.LZ4;
    }

    private static Location makeFileName(HiveConfig config) {
        return Location.of((String)("memory:///" + config.getHiveStorageFormat().name() + "." + config.getHiveCompressionCodec().name()));
    }

    private static long writeTestFile(TrinoFileSystemFactory fileSystemFactory, HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore, Location location) throws IOException {
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        HiveWriterStats stats = new HiveWriterStats();
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink(fileSystemFactory, transaction, config, sortingFileWriterConfig, metastore, location, stats, TestHivePageSink.getColumnHandles());
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List<Type> columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getType).map(hiveType -> InternalTypeManager.TESTING_TYPE_MANAGER.getType(hiveType.getTypeSignature())).collect(Collectors.toList());
        Page page = TestHivePageSink.createPage(lineItem -> true);
        pageSink.appendPage(page);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        FileIterator fileIterator = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).listFiles(location);
        FileEntry fileEntry = fileIterator.next();
        Assertions.assertThat((boolean)fileIterator.hasNext()).isFalse();
        ArrayList<Page> pages = new ArrayList<Page>();
        try (ConnectorPageSource pageSource = TestHivePageSink.createPageSource(fileSystemFactory, transaction, config, fileEntry.location());){
            while (!pageSource.isFinished()) {
                Page nextPage = pageSource.getNextPage();
                if (nextPage == null) continue;
                pages.add(nextPage.getLoadedPage());
            }
        }
        MaterializedResult expectedResults = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, (List<Page>)ImmutableList.of((Object)page));
        MaterializedResult results = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, pages);
        Assertions.assertThat((Iterable)results).containsExactlyElementsOf((Iterable)expectedResults);
        Assertions.assertThat((long)Math.round(stats.getInputPageSizeInBytes().getAllTime().getMax())).isEqualTo(page.getRetainedSizeInBytes());
        return fileEntry.length();
    }

    private static Page createPage(Function<LineItem, Boolean> filter) {
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getType).map(hiveType -> InternalTypeManager.TESTING_TYPE_MANAGER.getType(hiveType.getTypeSignature())).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        int rows = 0;
        for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
            if (!filter.apply(lineItem).booleanValue()) continue;
            if (++rows >= 1000) break;
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                LineItemColumn column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                        continue block8;
                    }
                    case DATE: {
                        DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + String.valueOf(column.getType()));
                    }
                }
            }
        }
        return pageBuilder.build();
    }

    static MaterializedResult toMaterializedResult(ConnectorSession session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    private static ConnectorPageSource createPageSource(TrinoFileSystemFactory fileSystemFactory, HiveTransactionHandle transaction, HiveConfig config, Location location) throws IOException {
        long length = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newInputFile(location).length();
        ImmutableMap splitProperties = ImmutableMap.builder().put((Object)"file.inputformat", (Object)config.getHiveStorageFormat().getInputFormat()).put((Object)"columns", (Object)Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList()))).put((Object)"columns.types", (Object)Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getHiveType).map(hiveType -> hiveType.getHiveTypeName().toString()).collect(ImmutableList.toImmutableList()))).buildOrThrow();
        HiveSplit split = new HiveSplit("", location.toString(), 0L, length, length, 0L, new Schema(config.getHiveStorageFormat().getSerde(), false, (Map)splitProperties), (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), false, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), Optional.empty(), SplitWeight.standard());
        HiveTableHandle table = new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        HivePageSourceProvider provider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, config, HiveTestUtils.getDefaultHivePageSourceFactories(fileSystemFactory, config));
        return provider.createPageSource((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorSplit)split, (ConnectorTableHandle)table, (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()), DynamicFilter.EMPTY);
    }

    private static ConnectorPageSink createPageSink(TrinoFileSystemFactory fileSystemFactory, HiveTransactionHandle transaction, HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore, Location location, HiveWriterStats stats, List<HiveColumnHandle> columnHandles) {
        LocationHandle locationHandle = new LocationHandle(location, location, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
        HiveOutputTableHandle handle = new HiveOutputTableHandle("test", "test", columnHandles, new HivePageSinkMetadata(new SchemaTableName("test", "test"), metastore.getTable("test", "test"), (Map)ImmutableMap.of()), locationHandle, config.getHiveStorageFormat(), config.getHiveStorageFormat(), (List)ImmutableList.of(), Optional.empty(), "test", (Map)ImmutableMap.of(), AcidTransaction.NO_ACID_TRANSACTION, false, false);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        HivePageSinkProvider provider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config, fileSystemFactory), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, HiveTestUtils.PAGE_SORTER, HiveMetastoreFactory.ofInstance((HiveMetastore)metastore), (PageIndexerFactory)new GroupByHashPageIndexerFactory(new FlatHashStrategyCompiler(new TypeOperators())), InternalTypeManager.TESTING_TYPE_MANAGER, config, sortingFileWriterConfig, (LocationService)new HiveLocationService((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, config), partitionUpdateCodec, stats);
        return provider.createPageSink((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorOutputTableHandle)handle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
    }

    private static List<HiveColumnHandle> getColumnHandles() {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            Type type = TestHivePageSink.getType(column.getType());
            handles.add((Object)HiveColumnHandle.createBaseColumn((String)column.getColumnName(), (int)i, (HiveType)HiveTypeTranslator.toHiveType((Type)type), (Type)type, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static List<HiveColumnHandle> getPartitionedColumnHandles(String partitionColumn) {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            Type type = TestHivePageSink.getType(column.getType());
            if (column.getColumnName().equals(partitionColumn)) {
                handles.add((Object)HiveColumnHandle.createBaseColumn((String)column.getColumnName(), (int)i, (HiveType)HiveTypeTranslator.toHiveType((Type)type), (Type)type, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty()));
                continue;
            }
            handles.add((Object)HiveColumnHandle.createBaseColumn((String)column.getColumnName(), (int)i, (HiveType)HiveTypeTranslator.toHiveType((Type)type), (Type)type, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static List<LineItemColumn> getTestColumns() {
        return Stream.of(LineItemColumn.values()).filter(column -> !column.getType().equals((Object)TpchColumnTypes.DATE)).collect(Collectors.toList());
    }

    private static Type getType(TpchColumnType type) {
        return switch (type.getBase()) {
            default -> throw new MatchException(null, null);
            case TpchColumnType.Base.IDENTIFIER -> BigintType.BIGINT;
            case TpchColumnType.Base.INTEGER -> IntegerType.INTEGER;
            case TpchColumnType.Base.DATE -> DateType.DATE;
            case TpchColumnType.Base.DOUBLE -> DoubleType.DOUBLE;
            case TpchColumnType.Base.VARCHAR -> VarcharType.VARCHAR;
        };
    }

    private static /* synthetic */ void lambda$testAllFormats$0(TrinoFileSystemFactory fileSystemFactory, HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore) throws Throwable {
        TestHivePageSink.writeTestFile(fileSystemFactory, config, sortingFileWriterConfig, metastore, TestHivePageSink.makeFileName(config));
    }
}

