/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveType;
import io.trino.operator.TestScanFilterAndProjectOperator;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Utils;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHivePageSource {
    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectorPageSource.class, HivePageSource.class);
    }

    @Test
    public void testGetNextPageSucceedsWhenHiveBucketingEnabled() throws IOException {
        this.testGetNextPageWhenHiveBucketingEnabled(OptionalInt.of(1));
    }

    @Test
    public void testGetNextPageThrowsExceptionWhenHiveBucketingEnabled() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testGetNextPageWhenHiveBucketingEnabled(OptionalInt.of(-1))).isInstanceOf(TrinoException.class)).hasMessageContaining("Hive table is corrupt.");
    }

    private void testGetNextPageWhenHiveBucketingEnabled(OptionalInt tableBucketNumber) throws IOException {
        String partitionColumnName = "partition_col";
        String bucketColumnName = "bucket_col";
        ImmutableList columns = ImmutableList.of((Object)new HiveColumnHandle(partitionColumnName, 0, HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty()), (Object)new HiveColumnHandle("regular_col", 1, HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, Optional.empty(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)new HiveColumnHandle(bucketColumnName, 2, HiveType.HIVE_LONG, (Type)BigintType.BIGINT, Optional.empty(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        String partitionColumnValue = "1";
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey(partitionColumnName, partitionColumnValue));
        List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)partitionColumnValue, (List)partitionKeys, (List)columns, (List)ImmutableList.of(), (Map)ImmutableMap.of(), null, (OptionalInt)tableBucketNumber, (long)0L, (long)0L);
        List regularAndInterimColumnMappings = HivePageSourceProvider.ColumnMapping.extractRegularAndInterimColumnMappings((List)columnMappings);
        List<HiveColumnHandle> bucketColumns = columns.stream().filter(c -> c.getName().equals(bucketColumnName)).toList();
        Optional<HiveSplit.BucketValidation> bucketValidation = Optional.of(new HiveSplit.BucketValidation(HiveBucketing.BucketingVersion.BUCKETING_V1, 8, bucketColumns));
        Optional bucketValidator = HivePageSourceProvider.createBucketValidator((Location)Location.of((String)"memory:///test"), bucketValidation, (OptionalInt)tableBucketNumber, (List)regularAndInterimColumnMappings);
        Block[] blocks = new Block[]{Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)1L)};
        Page page = new Page(1, blocks);
        try (TestScanFilterAndProjectOperator.SinglePagePageSource pageSource = new TestScanFilterAndProjectOperator.SinglePagePageSource(page);
             HivePageSource hivePageSource = new HivePageSource(columnMappings, Optional.empty(), bucketValidator, Optional.empty(), InternalTypeManager.TESTING_TYPE_MANAGER, new CoercionUtils.CoercionContext(HiveTimestampPrecision.DEFAULT_PRECISION, HiveStorageFormat.PARQUET), (ConnectorPageSource)pageSource);){
            hivePageSource.getNextPage();
        }
    }
}

