/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import io.trino.plugin.hive.HivePlugin;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.session.PropertyMetadata;
import io.trino.testing.TestingConnectorContext;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHivePlugin {
    @Test
    public void testCreateConnector() {
        ConnectorFactory factory = TestHivePlugin.getHiveConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testTestingFileMetastore() {
        ConnectorFactory factory = TestHivePlugin.getHiveConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"file", (Object)"hive.metastore.catalog.dir", (Object)"/tmp", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testThriftMetastore() {
        ConnectorFactory factory = TestHivePlugin.getHiveConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"thrift", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testGlueV1Metastore() {
        ConnectorFactory factory = TestHivePlugin.getHiveConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue-v1", (Object)"hive.metastore.glue.region", (Object)"us-east-2", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Assertions.assertThatThrownBy(() -> factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Configuration property 'hive.metastore.uri' was not used");
    }

    @Test
    public void testGlueMetastore() {
        ConnectorFactory factory = TestHivePlugin.getHiveConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue", (Object)"hive.metastore.glue.region", (Object)"us-east-2", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Assertions.assertThatThrownBy(() -> factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Configuration property 'hive.metastore.uri' was not used");
    }

    @Test
    public void testImmutablePartitionsAndInsertOverwriteMutuallyExclusive() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.insert-existing-partitions-behavior", (Object)"APPEND").put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("insert-existing-partitions-behavior cannot be APPEND when immutable-partitions is true");
    }

    @Test
    public void testInsertOverwriteIsSetToErrorWhenImmutablePartitionsIsTrue() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        Connector connector = connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assertions.assertThat((Object)this.getDefaultValueInsertExistingPartitionsBehavior(connector)).isEqualTo((Object)HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR);
        connector.shutdown();
    }

    @Test
    public void testInsertOverwriteIsSetToAppendWhenImmutablePartitionsIsFalseByDefault() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        Connector connector = connectorFactory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext());
        Assertions.assertThat((Object)this.getDefaultValueInsertExistingPartitionsBehavior(connector)).isEqualTo((Object)HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND);
        connector.shutdown();
    }

    private Object getDefaultValueInsertExistingPartitionsBehavior(Connector connector) {
        return ((PropertyMetadata)connector.getSessionProperties().stream().filter(propertyMetadata -> "insert_existing_partitions_behavior".equals(propertyMetadata.getName())).collect(MoreCollectors.onlyElement())).getDefaultValue();
    }

    @Test
    public void testAllowAllAccessControl() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"hive.security", (Object)"allow-all").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testReadOnlyAllAccessControl() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"hive.security", (Object)"read-only").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testFileBasedAccessControl() throws Exception {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        File tempFile = File.createTempFile("test-hive-plugin-access-control", ".json");
        tempFile.deleteOnExit();
        Files.write(tempFile.toPath(), "{}".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"hive.security", (Object)"file").put((Object)"security.config-file", (Object)tempFile.getAbsolutePath()).put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testSystemAccessControl() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        Connector connector = connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"hive.security", (Object)"system").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assertions.assertThatThrownBy(() -> ((Connector)connector).getAccessControl()).isInstanceOf(UnsupportedOperationException.class);
        connector.shutdown();
    }

    @Test
    public void testHttpMetastoreConfigs() {
        ConnectorFactory connectorFactory = TestHivePlugin.getHiveConnectorFactory();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"https://localhost:443").put((Object)"hive.metastore.http.client.bearer-token", (Object)"token").put((Object)"hive.metastore.http.client.additional-headers", (Object)"key:value").put((Object)"hive.metastore.http.client.authentication.type", (Object)"BEARER").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"http://localhost:443").put((Object)"hive.metastore.http.client.additional-headers", (Object)"key:value").put((Object)"hive.metastore.http.client.authentication.type", (Object)"BEARER").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"http://localhost:443").put((Object)"hive.metastore.http.client.bearer-token", (Object)"token").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("'hive.metastore.http.client.bearer-token' must not be set while using http metastore URIs in 'hive.metastore.uri'");
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"http://localhost:443, https://localhost:443").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("'hive.metastore.uri' cannot contain both http and https URI schemes");
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"http://localhost:443, thrift://localhost:443").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("'hive.metastore.uri' cannot contain both http(s) and thrift URI schemes");
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"https://localhost:443").put((Object)"hive.metastore.http.client.bearer-token", (Object)"token").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("'hive.metastore.http.client.authentication.type' must be set while using http/https metastore URIs in 'hive.metastore.uri'");
        Assertions.assertThatThrownBy(() -> connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"https://localhost:443").put((Object)"hive.metastore.http.client.authentication.type", (Object)"BEARER").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("'hive.metastore.http.client.bearer-token' must be set while using https metastore URIs in 'hive.metastore.uri'");
    }

    private static ConnectorFactory getHiveConnectorFactory() {
        HivePlugin plugin = new HivePlugin();
        return (ConnectorFactory)((Optional)Streams.stream((Iterable)plugin.getConnectorFactories()).filter(factory -> factory.getName().equals("hive")).collect(MoreCollectors.toOptional())).orElseThrow();
    }
}

