/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Module;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.exchange.filesystem.containers.MinioStorage;
import io.trino.plugin.hive.BaseHiveFailureRecoveryTest;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.spi.Plugin;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHiveQueryFailureRecoveryTest
extends BaseHiveFailureRecoveryTest {
    private HiveMinioDataLake hiveMinioDataLake;
    private MinioStorage minioStorage;

    public TestHiveQueryFailureRecoveryTest() {
        super(RetryPolicy.QUERY);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties, Module failureInjectionModule) throws Exception {
        String bucketName = "test-hive-insert-overwrite-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake(bucketName));
        this.hiveMinioDataLake.start();
        this.minioStorage = (MinioStorage)this.closeAfterClass((AutoCloseable)new MinioStorage("test-exchange-spooling-" + TestingNames.randomNameSuffix()));
        this.minioStorage.start();
        return ((S3HiveQueryRunner.Builder)((Object)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)S3HiveQueryRunner.builder(this.hiveMinioDataLake).setExtraProperties(configProperties)).setCoordinatorProperties(coordinatorProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", MinioStorage.getExchangeManagerProperties((MinioStorage)this.minioStorage));
        })).setAdditionalModule(failureInjectionModule)).setInitialTables(requiredTpchTables))).build();
    }

    @AfterAll
    public void destroy() throws Exception {
        this.hiveMinioDataLake = null;
        this.minioStorage = null;
    }
}

