/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.DefaultCachingHostAddressProvider;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveSplitLoader;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.Schema;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSplitSource {
    @Test
    public void testOutstandingSplitCount() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(i + 1);
        }
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1)).hasSize(1);
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(9);
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 4)).hasSize(4);
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(5);
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 20)).hasSize(5);
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(0);
    }

    @Test
    public void testDynamicPartitionPruning() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0, () -> false));
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(1, () -> true));
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(2);
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 2)).hasSize(1);
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(0);
    }

    @Test
    public void testEvenlySizedSplitRemainder() {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newSingleThreadExecutor(), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        DataSize fileSize = DataSize.ofBytes((long)(initialSplitSize.toBytes() + 1L));
        long halfOfSize = fileSize.toBytes() / 2L;
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(1, OptionalInt.empty(), fileSize));
        HiveSplit first = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assertions.assertThat((long)first.getLength()).isEqualTo(halfOfSize);
        HiveSplit second = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assertions.assertThat((long)second.getLength()).isEqualTo(fileSize.toBytes() - halfOfSize);
    }

    @Test
    public void testFail() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        for (int i = 0; i < 5; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(i + 1);
        }
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1)).hasSize(1);
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(4);
        hiveSplitSource.fail((Throwable)new RuntimeException("test"));
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(4);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1)).isInstanceOf(RuntimeException.class)).hasMessage("test");
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(4);
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(99));
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(4);
        hiveSplitSource.fail((Throwable)new RuntimeException("another failure"));
        Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(4);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1)).isInstanceOf(RuntimeException.class)).hasMessage("test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWaitsForSplits() throws Exception {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        SettableFuture splits = SettableFuture.create();
        CountDownLatch started = new CountDownLatch(1);
        Thread getterThread = new Thread(() -> {
            try {
                started.countDown();
                List<ConnectorSplit> batch = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
                Assertions.assertThat(batch).hasSize(1);
                splits.set((Object)batch.get(0));
            }
            catch (Throwable e) {
                splits.setException(e);
            }
        });
        getterThread.start();
        try {
            Assertions.assertThat((boolean)started.await(1L, TimeUnit.SECONDS)).isTrue();
            TimeUnit.MILLISECONDS.sleep(200L);
            Assertions.assertThat((!splits.isDone() ? 1 : 0) != 0).isTrue();
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(33));
            ConnectorSplit split = (ConnectorSplit)splits.get(800L, TimeUnit.MILLISECONDS);
            Assertions.assertThat((Map)((HiveSplit)split).getSchema().serdeProperties()).containsEntry((Object)"id", (Object)"33");
        }
        finally {
            getterThread.interrupt();
        }
    }

    @Test
    public void testOutstandingSplitSize() {
        int i;
        DataSize maxOutstandingSplitsSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10000, (DataSize)maxOutstandingSplitsSize, (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
        int testSplitSizeInBytes = new TestSplit(0).getEstimatedSizeInBytes();
        int maxSplitCount = Math.toIntExact(maxOutstandingSplitsSize.toBytes()) / testSplitSizeInBytes;
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(i + 1);
        }
        Assertions.assertThat(TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, maxSplitCount)).hasSize(maxSplitCount);
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assertions.assertThat((int)hiveSplitSource.getBufferedInternalSplitCount()).isEqualTo(i + 1);
        }
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0))).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_EXCEEDED_SPLIT_BUFFERING_LIMIT}).hasMessageContaining("Split buffering for database.table exceeded memory limit");
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, int maxSize) {
        return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch(maxSize))).getSplits();
    }

    private static class TestingHiveSplitLoader
    implements HiveSplitLoader {
        private TestingHiveSplitLoader() {
        }

        public void start(HiveSplitSource splitSource) {
        }

        public void stop() {
        }
    }

    private static class TestSplit
    extends InternalHiveSplit {
        private TestSplit(int id) {
            this(id, OptionalInt.empty());
        }

        private TestSplit(int id, BooleanSupplier partitionMatchSupplier) {
            this(id, OptionalInt.empty(), DataSize.ofBytes((long)100L), partitionMatchSupplier);
        }

        private TestSplit(int id, OptionalInt bucketNumber) {
            this(id, bucketNumber, DataSize.ofBytes((long)100L));
        }

        private TestSplit(int id, OptionalInt bucketNumber, DataSize fileSize) {
            this(id, bucketNumber, fileSize, () -> true);
        }

        private TestSplit(int id, OptionalInt bucketNumber, DataSize fileSize, BooleanSupplier partitionMatchSupplier) {
            super("partition-name", "path", 0L, fileSize.toBytes(), fileSize.toBytes(), Instant.now().toEpochMilli(), new Schema("abc", false, (Map)ImmutableMap.of((Object)"id", (Object)String.valueOf(id))), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(0L, fileSize.toBytes(), (List)ImmutableList.of())), bucketNumber, bucketNumber, true, false, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), Optional.empty(), partitionMatchSupplier);
        }
    }
}

