/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIssue14317 {
    @Test
    public void test() throws Exception {
        HiveQueryRunner.Builder<?> builder = HiveQueryRunner.builder().setCreateTpchSchemas(false);
        try (DistributedQueryRunner queryRunner = builder.build();
             QueryAssertions assertions = new QueryAssertions((QueryRunner)queryRunner);){
            queryRunner.execute("CREATE SCHEMA s");
            queryRunner.execute("CREATE TABLE s.t (a bigint, b bigint)");
            queryRunner.execute("CREATE TABLE s.u (c bigint, d bigint) WITH (partitioned_by = array['d'])");
            queryRunner.execute("CREATE TABLE s.v (e bigint, f bigint)");
            queryRunner.execute("INSERT INTO s.t VALUES (5, 6)");
            queryRunner.execute("INSERT INTO s.u VALUES (5, 6)");
            queryRunner.execute("INSERT INTO s.v VALUES (5, 6)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)assertions.query("WITH t1 AS (\n  SELECT a\n  FROM (\n    SELECT a, ROW_NUMBER() OVER (PARTITION BY a) AS rn\n    FROM s.t)\n  WHERE rn = 1),\nt2 AS (SELECT c FROM s.u WHERE d - 5 = 8)\nSELECT v.e\nFROM s.v\n  INNER JOIN t1 on v.e = t1.a\n  INNER JOIN t2 ON v.e = t2.c\n"))).returnsEmptyResult();
            queryRunner.execute("DROP TABLE s.t");
            queryRunner.execute("DROP TABLE s.u");
            queryRunner.execute("DROP TABLE s.v");
            queryRunner.execute("DROP SCHEMA s");
        }
    }
}

